#include "mbed.h"
#include "datos.h"

#define longitudTrama 500

Timer timer;
float resultado;
int tiempo;

struct estructuraMedidas {
    float vrms;
    float irms;
    float potenciaActiva;
    float potenciaReactiva;
    float potenciaAparente;
    float energiaConsumida;
    float factorDePotencia;
};

float calcularRMS(int16_t *datos, int longitud);

void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas);


int main()
{

    timer.reset();
    timer.start();
    resultado=calcularRMS(datos, longitudTrama);
    timer.stop();
    printf("****El valor Vrms es %f calculado en %d us ****\n",resultado,timer.read_us());

    estructuraMedidas medidas;
    medidas.energiaConsumida=0;

    timer.reset();
    timer.start();
    calcularDatos(datosV,datosI,longitudTrama,&medidas);
    timer.stop();
    printf("**** Datos calculados en %d us ****\n",timer.read_us());
    printf("**** El valor Vrms es %f ****\n",medidas.vrms);
    printf("**** El valor Irms es %f ****\n",medidas.irms);
    printf("**** La potencia activa es %f ****\n",medidas.potenciaActiva);
    printf("**** La potencia reactiva es %f ****\n",medidas.potenciaReactiva);
    printf("**** La potencia aparente es %f ****\n",medidas.potenciaAparente);
    printf("**** La energia consumida es %f ****\n",medidas.energiaConsumida);
    printf("**** El factor de potencia es es %f ****\n",medidas.factorDePotencia);

}

float calcularRMS(int16_t *datos, int longitud)
{
    float sumatorio;

    const float constante =6.6/65536.0*6.6/65536.0;
    int16_t dato;
    int64_t sum = 0;
    int32_t mult;



    for (int n = 0; n<longitud; n++) {
        dato = datos[n];
        mult=dato*dato;
        sum+=mult;
    }

    sumatorio = sum*constante/longitud;
    return sqrt(sumatorio);

}

void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas)
{
    int16_t voltajes;
    int32_t product_volt;
    int64_t sumatorio_volt=0;
    float resultado_v;
    int16_t intens;
    int32_t product_i;
    int64_t sumatorio_i=0;
    float resultado_i;
    int32_t pot;
    int64_t sumatorio_pot=0;
    float resultado_pot;
    float cte=6.6/65536.0*6.6/65536.0;

    for (int n=0;n<longitud;n++){
            
            voltajes=datosV[n];
            product_volt=voltajes*voltajes;
            sumatorio_volt+=product_volt;
            
            intens=datosI[n];
            product_i=intens*intens;
            sumatorio_i+=product_i;
            
            pot=voltajes*intens;
            sumatorio_pot+=pot;
            
        }
        resultado_v=sumatorio_volt*cte/longitud;
        resultado_i=sumatorio_i*cte/longitud;
        resultado_pot=sumatorio_pot*cte/longitud;
    
    (*medidas).vrms=sqrt(resultado_v);    
    (*medidas).irms=sqrt(resultado_i);
    (*medidas).potenciaActiva=resultado_pot;
    (*medidas).potenciaAparente=(*medidas).vrms*(*medidas).irms;
    (*medidas).potenciaReactiva=sqrt(-((*medidas).potenciaActiva*(*medidas).potenciaActiva)+((*medidas).potenciaAparente*(*medidas).potenciaAparente));
    (*medidas).factorDePotencia=(*medidas).potenciaActiva/(*medidas).potenciaAparente;

}

