#include "mbed.h"
#include "hcsr04.h"



#include "Adafruit_SSD1306.h"
 
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};
 
 
I2CPreInit gI2C(PB_9,PB_8);
 
// an SPI sub-class that provides a constructed default
 
Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);


Serial pc(USBTX, USBRX); // tx, rx
Ticker tickerMideDistancia;
unsigned distancia=20;

HCSR04  usensor(D7,D8); //(PinName TrigPin,PinName EchoPin):
DigitalIn finalDer(D2);
DigitalIn finalIzq(D3);
DigitalOut step(D13);
DigitalOut dir(D12);
DigitalOut enable(D11);

int contador=0;


enum estados {cerrada, abriendose, cerrandose, abierta};
estados estado;


void mideDistancia()
{
    usensor.start();
}

void paso(int d)
{
    dir=d;
    step=1;
    wait_us(100);   // Este es el cambio de paso
    step=0;
    wait_us(900);  //Este hay que cambiar
}

void estadoCerrada()
{
   
    if( (finalIzq == 1) && contador <3) {
        wait(1.0);
        enable=1;
        estado=abriendose;
       // pc.printf("Distance =%d\n",distancia);
        pc.printf("Final2 pulsado\r\n");
        
       
        //distancia < 5 
    }
    
}

void estadoAbriendose()
{
    //pc.printf("Distance =%d\n",distancia);
    if((finalDer==1)) {
        
        estado=abierta;
        enable=0;
             
    } else  {
        
        paso(1);
        //pc.printf("paso\n");
        
    }
  //  if (distancia<4){
        //estado=cerrandose;
        
       // }
}

void estadoCerrandose(){
     //pc.printf("Distance =%d\n",distancia);
     if((finalIzq==1)) {
        
        estado=cerrada;
        enable=0;
    } else  {
        
        paso(0);
        //pc.printf("paso\n");
        
    }
}

void estadoAbierta()
{
    //pc.printf("Distance =%d\n",distancia);
    //if (finalDer==1) {
        
        
        enable=1;
        estado=cerrandose;
        pc.printf("Final1 pulsado\r\n");
        
    //}
    contador++;
    gOled.clearDisplay();
    gOled.printf("piezas transportadas %d\n",contador);
    gOled.display();
        gOled.setTextCursor(0,0);
}

int main()
{
    pc.baud(115200);
    tickerMideDistancia.attach(&mideDistancia, 0.5);
    estado=cerrada;
     gOled.begin();
    gOled.clearDisplay();
     gOled.printf("Hola\n");
    //pc.printf("Estado cerrada\n");
    
    while(1) {
        distancia=usensor.get_dist_cm();
        
        switch ( estado ) {
            case cerrada:
                estadoCerrada();
                break;
            case abriendose:
                estadoAbriendose();
                break;
            case abierta:
                estadoAbierta();
                break;
            case cerrandose:
                estadoCerrandose();
                break;
            default:
                break;
        }
    }
}
