#include "mbed.h"
#define period 0.0002 //1/5000
#define sizeVector 100
#define Constant 2.5355257093906402587890625e-11 
//USER_BUTTON o PC_13

InterruptIn button(PC_13);
AnalogIn values(A0);

uint16_t vA[sizeVector];
uint16_t vB[sizeVector];
uint16_t iA[sizeVector];
uint16_t iB[sizeVector];

uint32_t temporal;

int counter=0;
int flag=0;
int whatVector=0;
uint16_t temp=0;
uint64_t sum_values=0;
float RMS_value=0;
float Vpp_value=0;
uint16_t Max_value=0;
uint16_t Min_value=1000;
int state=0;

Ticker sample;  //Puntero para el attach
Ticker visualize;

void fsample()
{
    if (whatVector) {
        temporal=((values.read_u16()+values.read_u16()+values.read_u16()+values.read_u16())/4);
        vB[counter]=(uint16_t)temporal;
    } 
    else {
        temporal=((values.read_u16()+values.read_u16()+values.read_u16()+values.read_u16())/4);
        vA[counter]=(uint16_t)temporal;
    }
    counter++;
    if (counter==100) {
        counter=0;
        flag=1;
        whatVector=!whatVector;
    }
}
void change_button()
{
    state++;
    if(state>8){
        state=0;
    }
}
void visualiza()
{
    switch(state){
        
        case 1:
            printf("RMS value is =%f\r\n",RMS_value);
        case 2:
                printf("Vpp value is =%f\n\r",Vpp_value);
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
}

int main()
{  
    sample.attach(&fsample,period);
    visualize.attach(&visualiza,1);
    button.rise(&change_button);
   
    while(1) {
        if (flag) {
            flag=0; //Para que entre en el if cuando haya un cambio a 1 de flag, es decir, counter=100
            sum_values=0; //Inicializar a 0
            if(whatVector) {
                for(int n=0; n<100; n++) {
                    temp=vA[n];
                    temporal=temp*temp;
                    sum_values=sum_values+temporal;

                    if(Max_value<temp) {
                        Max_value=temp;
                    }
                    if(Min_value>temp) {
                        Min_value=temp;
                    }
                }
            }
                else {

                    for(int n=0; n<100; n++) {
                        temp=vB[n];
                    temporal=temp*temp;
                    sum_values=sum_values+temporal;

                        if(Max_value<temp) {
                            Max_value=temp;
                        }
                        if(Min_value>temp) {
                            Min_value=temp;
                        }
                    }
                }
            RMS_value=sqrt((float)Constant*(float)sum_values);
            Vpp_value=(Max_value-Min_value)*0.00005035400390625;

        }
    }

}
