#include "mbed.h"
#define period 0.0002 //1/5000
#define sizeVector 100
#define Constant_v 1.2092e-06
#define Constant_i 5.5641e-06//((3,3*2000/(2^16*Rburn))^2)*(1/100)
//USER_BUTTON o PC_13
#include "TextLCD.h"
#define dato_p 202.6327 //para calcular el precio 

InterruptIn button(PC_13);
AnalogIn valuesV(A0);
AnalogIn valuesOffset(A1);
AnalogIn valuesI(A5);

Serial bluetooth(D10,D2);
TextLCD lcd(D8, D9, D3, D4, D5, D6 ,TextLCD::LCD16x2); // rs, e, d4-d7

int16_t vA[sizeVector];
int16_t vB[sizeVector];
int16_t iA[sizeVector];
int16_t iB[sizeVector];
uint16_t valorOffset;

uint32_t temporal;

int counter=0;
int flag=0;
int whatVector=0;
int state=0;
int16_t temp_v=0;
int16_t temp_i=0;
int64_t sum_values_v=0;
int64_t sum_values_i=0;
float VRMS=0;
float IRMS=0;
float Pact=0;
float Preactiva=0;
float Paparente=0;
float EnergiActiva=0;
float EnergiaReactiva=0;
float cosPHI=0;
float precio=0;
 


Ticker sample;  //Puntero para el attach
Ticker visualize;

void fsample()
{
    valorOffset=(int16_t)(valuesOffset.read_u16()^0x8000);
    if (whatVector) {
        temporal=((valuesV.read_u16()+valuesV.read_u16()+valuesV.read_u16()+valuesV.read_u16())/4);
        
        vB[counter]=((int16_t)(temporal^0xFFFF8000))-valorOffset;
        //printf("%u %d\r\n",vB[counter], counter);
        temporal=((valuesI.read_u16()+valuesI.read_u16()+valuesI.read_u16()+valuesI.read_u16())/4);
        iB[counter]=((int16_t)(temporal^0xFFFF8000))-valorOffset;
    } else {
        temporal=((valuesV.read_u16()+valuesV.read_u16()+valuesV.read_u16()+valuesV.read_u16())/4);
        vA[counter]=((int16_t)(temporal^0xFFFF8000))-valorOffset;

        temporal=((valuesI.read_u16()+valuesI.read_u16()+valuesI.read_u16()+valuesI.read_u16())/4);
        iA[counter]=((int16_t)(temporal^0xFFFF8000))-valorOffset;
    }
    counter++;
    if (counter==100) {
        counter=0;
        flag=1;
        whatVector=!whatVector;
    }
}
void change_button()
{
    state++;
    if(state>8) {
        state=0;
    }
}
void visualiza()
{
    lcd.cls();
    bluetooth.printf("%f|%f|%f|%f|%f|%f|%f\n\r",VRMS,IRMS,Pact,EnergiActiva,EnergiaReactiva,Preactiva,Paparente);
    switch(state) {

        case 0:
            lcd.printf("VRMS: \n %f",VRMS);
            break;
        case 1:
            lcd.printf("IRMS: \n %f",IRMS);
            break;
        case 2:
            lcd.printf("Potencia Activa: \n %f",Pact);
            break;
        case 3:
            lcd.printf("Energia Activa:\n\r%f",EnergiActiva);
            break;
        case 4:
            lcd.printf("Energía Reactiva:\n\r%f",EnergiaReactiva);
            break;
        case 5:
            lcd.printf("Potecia Reactiva:\n\r%f",Preactiva);
            break;
        case 6:
            lcd.printf("Potencia Aparente:\n\r%f",Paparente);
            break;
        case 7:
            lcd.printf("Coseno de phi:\n\r%f",cosPHI);
            break;
    
    bluetooth.printf("%f | %f | %f | %f | %f \n",VRMS,IRMS,Pact,Preactiva,Paparente); 
    }
}
int main()
{
    sample.attach(&fsample,period);
    visualize.attach(&visualiza,1);
    button.rise(&change_button);
    int32_t productoTemp;

    while(1) {
        if (flag) {
            flag=0; //Para que entre en el if cuando haya un cambio a 1 de flag, es decir, counter=100
            sum_values_v=0; //Inicializar a 0
            sum_values_i=0;
            //printf("****************************\n\r");
            for(int n=0; n<100; n++) {
                if(whatVector) {
                    temp_v=vA[n];
                    temp_i=iA[n];
                } else {
                    temp_v=vB[n];
                    temp_i=iB[n];
                }
               //printf("%d\n\r",temp_v);
                productoTemp=temp_v*temp_v;
                sum_values_v=sum_values_v+productoTemp;
                productoTemp=temp_i*temp_i;
                sum_values_i=sum_values_i+productoTemp;
                sum_values_pa=sum_values_pa+(sum_values_i*sum_values_v);
                sum_values_pr=
                sum_values_papa=
                
                             
            }
            
        }
        printf("%f\n\r",(float)sum_values_v);    
        VRMS=sqrt(Constant_v*(float)sum_values_v);
        //VRMS=sqrt((((float)Constant_v*(float)Constant_v)*(1/100))*(float)sum_values_v);
        //IRMS=sqrt((((float)Constant_i*(float)Constant_i)*(1/100))*(float)sum_values_i);
        IRMS=sqrt(Constant_i*(float)sum_values_i);
        //Pact=(((((float)Constant_v*(float)Constant_i)*(1/100))*(float)sum_values_v)*(float)sum_values_i);
        Pact=202.63*sum_values_pa;
        EnergiActiva=EnergiActiva+Pact*20e-3/(3600*1000);  //kWh
        Paparente=VRMS*IRMS;
        Preactiva=sqrt((Paparente*Paparente)-(Pact*Pact));
        EnergiaReactiva=EnergiaReactiva+Preactiva*20e-3/(3600*1000);
        cosPHI=Pact/Paparente;
        precio=EnergiActiva*dato_p;
       
    }
}


