#include "mbed.h"              
#include "vga640x400/vga640x400.h"
#include <string.h>
#include <fichier.h>



// P8 et P25 pour horloge, P5 data
//Serial pc(USBTX, USBRX); // tx, rx
// This must be an SPI MOSI pin.
#define DATA_PIN p11


extern unsigned char font_lin[256*16];
Ticker timer1;

InterruptIn CAPT(p15 );

DigitalIn BPA(p17);
DigitalIn BPB(p18);
DigitalIn BPC(p19);
DigitalIn BPD(p20);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

void int_timer(void);
void int_capt(void);
void int_capt2(void);
void vide(void);
void tourne_roue(void);

int passage;


void lancer_action(void){

    FILE *fp = fopen("/local/act.csv", "r"); 
    if(!fp) { 
        error("Could not open file!\n\r");
    }
    
    //
    
    char ligne[500];
    char stock[500];
    char* morceau;
    bool passe = false;
    
    int a = 1;
    while( a == 1)
        a = (rand() % nombre_ligne_fichier(fp)) +1;
     
    printf("rand = %d\n\r",a);
    int b;
    
    
    //
    clear_buffer();
    /*-----------------------------------*/ 
    /* RETOURNE LE CONTENU DE LA LIGNE X */
    /*-----------------------------------*/ 
    retourne_ligne(a,ligne,fp);
    
    printf("LIGNE CHOISI: %s\n\r", ligne);
        
    /*--------------------------------*/ 
    /* AFFICHE L'ACTION A LECRAN      */
    /*--------------------------------*/ 
    morceau = retourne_element_ligne(1, ligne);
    strcpy(stock, morceau);
    printf("l'action est: %s \n\r", text_buffer);
    for (int i=0 ; i<strlen(stock)+1; i ++)
        text_buffer[(320+i)^1] = stock[i]; 
        
         
    a =0;
    while (text_buffer[a] != '\0'){
        a++;
        } 
    printf("a comptage : %d\n\r", a); 
    
    /*-----------------------------------*/ 
    /* AFFICHE LE TEMPS A LECRAN         */
    /*-----------------------------------*/ 
    strcpy(stock, "RESTER APPUYER SUR UN BOUTON POUR PASSER ->");
    for (int j=0 ; j<strlen(stock)+1; j++)
        text_buffer[(880+j)^1] = stock[j];
        
    morceau = retourne_element_ligne(2, ligne);
    b = atoi(morceau);
         
    while(b >= 0 ){
        wait(0.9);
        sprintf(stock, "%3d", b);
        printf("COMPTEUR: %s\n\r", stock);
        for (int i=0 ; i<strlen(stock)+1; i ++)
            text_buffer[((a/80+1)*80+i)^1] = stock[i];
        b--;
        if(! (BPA == 1 && BPB == 1 && BPC == 1 && BPD == 1) ){
            passe = true;
            clear_buffer();
            while(!(BPA == 1 && BPB == 1 && BPC == 1 && BPD == 1) ){     
            } 
            b=-1;    
        }
        
    }
    
    /*
    if (!passe){
        printf("dans le pas passe\n\r");
        clear_buffer(); 
        strcpy(stock, "APPUYER SUR UN BOUTON POUR CONTINUER ->            ");
        for (int j=0 ; j<strlen(stock)+1; j++)
            text_buffer[(880+j)^1] = stock[j];
        while(BPA == 1 && BPB == 1 && BPC == 1 && BPD == 1){  
        }
        while(! (BPA == 1 && BPB == 1 && BPC == 1 && BPD == 1) ){     
        }  
        clear_buffer();
        passe = false;  
    }
     */ 
    /*--------------------------------*/ 
    /* AFFICHE LA RAISON A LECRAN     */
    /*--------------------------------*/ 


    
    morceau = retourne_element_ligne(3, ligne);
    strcpy(stock, morceau);
    for (int j=0 ; j<strlen(stock); j++)
        text_buffer[(400+j)^1] = stock[j];
    
    wait(0.5);
    strcpy(stock, "LANCER LA ROUE POUR REJOUER");
    for (int j=0 ; j<strlen(stock)+1; j++)
        text_buffer[(1120+j)^1] = stock[j];

    tourne_roue();
    /*
    while(BPA == 1){  
    }
    
    while(BPA == 0){  
    }  
    */
    fclose(fp);
    printf("FIN\n\r");  
    
}

void lancer_question(void){

    FILE *fp = fopen("/local/form.csv", "r"); 
    if(!fp) { 
        error("Could not open file!\n\r");
    }
    
    //
    
    char ligne[500];
    char stock[500];
    char* morceau;
    int a = (rand() % nombre_ligne_fichier(fp)) +1;
    printf("rand = %d\n\r",a);
    int b;
    
    
    //
    clear_buffer();
    /*-----------------------------------*/ 
    /* RETOURNE LE CONTENU DE LA LIGNE X */
    /*-----------------------------------*/ 
    retourne_ligne(a,ligne,fp);
    
    /*
    for (int i=0 ; i<strlen(ligne)+1; i ++)
        text_buffer[(400+i)^1] = ligne[i]; //80 caractères par lignes
    
    printf("ligne est %s\n\r",ligne);
    wait(5);
    clear_buffer();
    */
        
    /*-----------------------------------*/ 
    /* AFFICHE LA QUESTION A LECRAN      */
    /*-----------------------------------*/ 
    morceau = retourne_element_ligne(1, ligne);
    strcpy(stock, morceau);
    for (int i=0 ; i<strlen(stock)+1; i ++)
        text_buffer[(400+i)^1] = stock[i]; 
    printf("la question est: %s \n\r", text_buffer);    
       
      
    a =0;
    while (text_buffer[a] != '\0'){
        a++;
        } 
    printf("a comptage : %d\n\r", a); 
    /*-----------------------------------*/ 
    /* AFFICHE LES REPONSES A LECRAN     */
    /*-----------------------------------*/ 

    for(int i = 1; i < 5; i++){
        morceau = retourne_element_ligne(i+1, ligne);
        printf("Reponse %d: %s \n\r",i, morceau);
        strcpy(stock, morceau);
        for (int j=0 ; j<strlen(stock)+1; j++)
            text_buffer[((a/80+1)*80+j+i*160)^1] = stock[j];
    }

     
    while(BPA == 1 && BPB == 1 && BPC == 1 && BPD == 1){ 
    }

    
    unsigned int ba, bb, bc, bd;
    
    ba = BPA;
    bb = BPB;
    bc = BPC;
    bd = BPD;

    while(! (BPA == 1 && BPB == 1 && BPC == 1 && BPD == 1) ){     
        }    


    printf("a: %d \n\r", ba);
    printf("a: %d \n\r", bb);
    printf("a: %d \n\r", bc);
    printf("a: %d \n\r", bd);
    if(!ba)
        b = 1;
    else if(!bb)
        b = 2;
    else if(!bc)
        b = 3;
    else if(!bd)
        b = 4;
        
    clear_buffer(); 

      
    /*----------------------------------------*/ 
    /* AFFICHE LA BONNE REPONSES A LECRAN     */
    /*----------------------------------------*/ 

    a = num_bonne_reponse(ligne);
    
    
    if(a == b){
        strcpy(stock, "BONNE REPONSE =)");
        for (int j=0 ; j<strlen(stock)+1; j++)
            text_buffer[(1+j)^1] = stock[j];
    }
    else{
        strcpy(stock, "MAUVAISE REPONSE =(");
        for (int j=0 ; j<strlen(stock)+1; j++)
            text_buffer[(1+j)^1] = stock[j];
    }
    morceau = retourne_element_ligne(a+1, ligne);
    strcpy(stock, morceau);
    for (int j=0 ; j<strlen(stock)+1; j++)
        text_buffer[(400+j)^1] = stock[j];
    
        
    strcpy(stock, " PARCE QUE ->");
    for (int j=0 ; j<strlen(stock)+1; j++)
            text_buffer[(560+j)^1] = stock[j];
            
            
    morceau = retourne_element_ligne(7, ligne);    
    strcpy(stock, morceau);
        for (int j=0 ; j<strlen(stock); j++)
            text_buffer[(640+j)^1] = stock[j];        
    
    wait(0.5);
    strcpy(stock, "LANCER LA ROUE POUR REJOUER");
    for (int j=0 ; j<strlen(stock)+1; j++)
        text_buffer[(1120+j)^1] = stock[j];
    
    
    tourne_roue();
    /*while(BPA == 1){  
    }
    
    while(BPA == 0){  
    }
      
        
    while(BPA == 1 && BPB == 1 && BPC == 1 && BPD == 1){ 
    }
    
    while(! (BPA == 1 && BPB == 1 && BPC == 1 && BPD == 1) ){     
    }     
    */
    fclose(fp);
    printf("FIN\n\r");  
    
}

void acceuil(void){
    
    clear_buffer();
    char stock[500];
    
    strcpy(stock, "BIENVENUE A ROU[E]COLO");
    for (int j=0 ; j<strlen(stock)+1; j++)
        text_buffer[(400+j)^1] = stock[j];
        
    strcpy(stock, "LANCER LA ROUE POUR JOUER");
    for (int j=0 ; j<strlen(stock)+1; j++)
        text_buffer[(1120+j)^1] = stock[j];

    tourne_roue();
    /*
    while(BPA == 1){  
    }
    
    while(BPA == 0){  
    }  
    */
    
    return;  
}

void vide(void){
    }
    
void int_timer(void){
    passage = 2;
    }

void int_capt(){
    passage = 1;
    }

void int_capt2(){
    timer1.attach(&int_timer, 3);
    }  
    
void tourne_roue(void){
    CAPT.rise(&int_capt);
    CAPT.fall(&int_capt);
    
    passage=0;
    while(passage == 0){
       printf("passage 0 \n\r");
    }
    
    timer1.attach(&int_timer, 3);
    CAPT.rise(&int_capt2);
    CAPT.fall(&int_capt2);
    
    while(passage == 1){
        printf("passage 1 \n\r");
    }
    printf("passage 2\n\r");
    timer1.detach();
    CAPT.rise(&vide);
    CAPT.fall(&vide);  
}  

int main() {
    LocalFileSystem local("local");
    

    font = font_lin;
    init_vga();
    
    
    acceuil();
    
    
    //
    while(1){
       
        if(CAPT.read() == 1)
            lancer_action(); 
        else
            lancer_question();
         
    }
}