#include "mbed.h"
#include "m3pi.h"


#define DO  16.3
#define DOd 17.3
#define RE  18.3
#define REd 19.4
#define MI 20.5
#define FA  21.8
#define FAd 23.1
#define SOL  24.5
#define SOLd 26.0
#define LA  27.5
#define LAd 29.1
#define SI  30.8

const char go[] PROGMEM = "L16 cdegreg4";


DigitalOut led1(LED1);
DigitalOut led2(LED2);
PwmOut speaker(p26);
m3pi m3pi;
float notes[12]= {DO, DOd, RE, REd, MI, FA, FAd, SOL, SOLd, LA, LAd, SI};

Serial pc(USBTX,USBRX);

LocalFileSystem local("local");  


void readBattery()
{
    char s[500];
    char* s2 = "Battery:%f V\n";
    sprintf(s, s2, m3pi.battery());
    for (int i=0; i<strlen(s); i++) {
        pc.putc(s[i]);
    }
    pc.printf("\r");
}

void readSensors()
{
    char s[500];
    char* s2 = "Sensors:(%u,%u,%u,%u,%u) \n";
    unsigned short val[5];
    m3pi.calibrated_sensors(val);
    sprintf(s, s2, val[0],val[1],val[2],val[3],val[4]);
    for (int i=0; i<strlen(s); i++) {
        pc.putc(s[i]);
    }
    pc.printf("\r");
}


//__enable_irq();
unsigned short flag = 0;
int word;
//InterruptIn USBINTERRUPT(USBRX);

void GetKeyboard()
{
    //pc.printf("Keyboard Interrupt \n");
    flag = 1;
    if(pc.readable())
        word = pc.getc();
    else pc.printf("no readable\n");
    return;
}
void writetofile()
{
    FILE *fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
    while(word!='x')
    {
        switch(word)
            {
                case 'z': fprintf(fp,"zz\n");break;
                case 'q': fprintf(fp,"qq\n");break;
                case 's': fprintf(fp,"ss\n");break;
                case 'd': fprintf(fp,"dd\n");break;
                case '0': fprintf(fp,"00\n");break;
                case '1': fprintf(fp,"11\n");break;
                case '2': fprintf(fp,"22\n");break;
                case '3': fprintf(fp,"33\n");break;
                case '4': fprintf(fp,"44\n");break;
                case '5': fprintf(fp,"55\n");break;
                case '6': fprintf(fp,"66\n");break;
                case '7': fprintf(fp,"77\n");break;
                case '8': fprintf(fp,"88\n");break;
                case '9': fprintf(fp,"99\n");break;
                case '-': fprintf(fp,"--\n");break;
                case '+': fprintf(fp,"++\n");break;
                
            }
            wait(0.5);
            
        
        }
    fclose(fp);
    }
    
void PlayNote (float frequency, float volume)
{
    speaker.period(1./frequency);
    speaker=volume;
}
    
void openfile()
{
    char chaine[2];
    int octave =2;float volume=0.3;
    FILE *fp = fopen("/local/out.txt", "r");
    if (fp!=NULL)
    {
        while (!feof(fp)) // On lit le fichier tant qu'on ne reçoit pas d'erreur (NULL)
        {
            fgets(chaine,2,fp);
            switch (chaine[0])
            {
                case 'z': 
                    m3pi.forward(0.5);
                    wait(0.5);
                    m3pi.stop();
                    break;
                case 's':
                    m3pi.backward(0.5);
                    wait(0.5);
                    m3pi.stop();
                    break;
                case 'q':
                    m3pi.left(0.5);
                    wait(0.5);
                    m3pi.stop();
                    break;
                case 'd':
                    m3pi.right(0.5);
                    wait(0.5);
                    m3pi.stop();
                    break;
                case '0': PlayNote(notes[0]*pow(2.,octave),volume);break;
                case '1': PlayNote(notes[1]*pow(2.,octave),volume);break;
                case '2': PlayNote(notes[2]*pow(2.,octave),volume);break;
                case '3': PlayNote(notes[3]*pow(2.,octave),volume);break;
                case '4': PlayNote(notes[4]*pow(2.,octave),volume);break;
                case '5': PlayNote(notes[5]*pow(2.,octave),volume);break;
                case '6': PlayNote(notes[6]*pow(2.,octave),volume);break;
                case '7': PlayNote(notes[7]*pow(2.,octave),volume);break;
                case '8': PlayNote(notes[8]*pow(2.,octave),volume);break;
                case '9': PlayNote(notes[9]*pow(2.,octave),volume);break;
                case '-': PlayNote(notes[10]*pow(2.,octave),volume);break;
                case '+': PlayNote(notes[11]*pow(2.,octave),volume);break;
                                
                }
        }
    }
    fclose(fp);
    }
 


int main()
{
    m3pi.cls();  
    pc.printf("Bonjour \n");
    //USBINTERRUPT.rise(&GetKeyboard);z
    pc.attach(&GetKeyboard, Serial::RxIrq);
    play_from_program_space(go);
    while(is_playing());

    //flag=0;
    while(1)
    {

        if(flag == 1)
        {
            pc.printf("in flag\n");
            //word = pc.getc();
            pc.printf("word = %c", word);
            switch(word)
            {
                case 'z':
                    m3pi.forward(0.5);
                    wait(0.5);
                    m3pi.stop();
                    break;
                case 'q':
                    m3pi.left(0.5);
                    wait(0.5);
                    m3pi.stop();
                    break;
                case 's':
                    m3pi.backward(0.5);
                    wait(0.5);
                    m3pi.stop();
                    break;
                case 'd':
                    m3pi.right(0.5);
                    wait(0.5);
                    m3pi.stop();
                    break;
                case 'b':
                    readBattery();
                    break;
                case 'c':
                    readSensors();
                    break;
                case 'p':
                    writetofile();
                    break;
                case 'r':
                    openfile();
            }
            flag=0;
        }
        else {}
    }
}
