#include "mbed.h"

#include "tca9548a.h"
#include "VL53L0X.h"

#define SDA_pin D14
#define SCL_pin D15

#define NB_CAPTEUR_TOF 8
#define NB 8

TCA9548A i2cMux(SDA_pin,SCL_pin);

Serial pc(SERIAL_TX, SERIAL_RX); //9600 bauds
Serial uart(D10,D2); //USB serial

int main()
{
    printf("hello\n");
    VL53L0X *ToF_Capteur[NB_CAPTEUR_TOF];
    int32_t ToF_Mesure[NB_CAPTEUR_TOF];
    
    // Initialisation des capteurs ToF

    for(int i=0 ; i<NB_CAPTEUR_TOF ; i++) {
        i2cMux.select(i);
        ToF_Capteur[i] = new VL53L0X(SDA_pin,SCL_pin);
        ToF_Capteur[i]->init();
        ToF_Capteur[i]->setTimeout(500);
        ToF_Capteur[i]->startContinuous();
    }
    
    char c;
    while(1) {
        uart.scanf("%c",&c);
        pc.printf("reception de 1\n");
        
        
            for(int i=0 ; i<NB_CAPTEUR_TOF ; i++) {
                i2cMux.select(i);
                //wait_ms(50);
                ToF_Mesure[i] = ToF_Capteur[i]->readRangeContinuousMillimeters();
                //wait_ms(50);
            }
            pc.printf("%i%i%i%i%i%i%i%i\n",ToF_Mesure[0],ToF_Mesure[1],ToF_Mesure[2],ToF_Mesure[3],ToF_Mesure[4],ToF_Mesure[5],ToF_Mesure[6],ToF_Mesure[7]);
            uart.printf("%i%i%i%i%i%i%i%i",ToF_Mesure[0],ToF_Mesure[1],ToF_Mesure[2],ToF_Mesure[3],ToF_Mesure[4],ToF_Mesure[5],ToF_Mesure[6],ToF_Mesure[7]);
        
        
    }
    
}

/*
int main()
{

    int mesure[NB];
    VL53L0X *sensor[NB];

    //i2cMux.reset();

    for(int i=0 ; i<NB ; i++){
        int err=1;
        printf("debut %i\n",i);
        i2cMux.select(i);
        wait_ms(100);
        sensor[i] = new VL53L0X(SDA_pin,SCL_pin);
        err=sensor[i]->init();
        if(err==false) printf("init error");
        sensor[i]->setTimeout(500);
        sensor[i]->startContinuous();
        wait_ms(100);
        printf("fin %i\n",i);
    }

    while(1){

        for(int i=0 ; i<NB ; i++){
            i2cMux.select(i);
            wait_ms(50);
            mesure[i] = sensor[i]->readRangeContinuousMillimeters();
            wait_ms(50);
        }
        for(int i=0 ; i<NB ; i++){
            pc.printf("Laser %i: %d\t", i, mesure[i]);
        }
        pc.printf("\n\n\n\r");
    }

}*/