#include "mbed.h"

/*
Nom du programme: Serrure electronique Polybot
Auteur: Thomas Hamain
Date: 22/11/2018

Cible: Nucleo STM32-F446RE
Servomoteur: Futaba S3305

Fonction: Ce programme ouvre et ferme la serrure du local Polybot grâce à un servomoteur actionné lorsque le bouton est appuyé.

TODO: Implémenté le contrôle via pavé numérique matriciel ou autre (NFC etc).
*/


Timeout timer;

DigitalOut my_led(LED1);
DigitalOut my_pwm(D10); //Servomoteur connecté au pin D10

DigitalIn my_button(USER_BUTTON);

int on_delay = 0;
int off_delay = 0;

/* Prototype des fonctions */

void toggleOn(void);
void toggleOff(void);

void pwm_io(int p_us, float dc);

void ouvrir_porte();
void fermer_porte();

/* Boucle principale */

int main() {
    int state = 0;
    
    while(1){
        my_led = state;
        if(state){
            ouvrir_porte();
        } else {
            fermer_porte();
        }
        if(my_button){
            state = !state;
            wait(0.5);   
        }
    }
}

void toggleOn(void) {
    my_pwm = 1;
    timer.attach_us(toggleOff, on_delay);
}

void toggleOff(void) {
    my_pwm = 0;
    timer.attach_us(toggleOn, off_delay);
}

// p_us = signal period in micro_seconds
// dc   = signal duty-cycle (0.0 to 1.0)
void pwm_io(int p_us, float dc) {
    timer.detach();
    if((p_us == 0) || (dc == 0)) {
        my_pwm = 0;
        return;
    }
    if(dc >= 1){
        my_pwm = 1;
        return;
    }
    on_delay = (int)(p_us * dc);
    off_delay = p_us - on_delay;
    toggleOn();
}

void ouvrir_porte(){
    pwm_io(20000, 0.10); //180° ouvert
}

void fermer_porte(){
    pwm_io(20000,0.05); //0° fermé
}