#include "mbed.h"
#include <RF24Network.h>
#include <RF24.h>
 
Serial pc(USBTX, USBRX);
InterruptIn button(D8);
AnalogIn LM35(A2);
void position_abs(double, double, double, double,double);
 
RF24 radio(SPI_MOSI, SPI_MISO, SPI_SCK, D9, SPI_CS );
Timer timer;
unsigned int temps;
int a=0;
float temperature;
float vitesse;
 
const int n = 3;
int addr[n] = {01,02,03};
double d[n];
double dist;
int indice=0;
 
void pressed()
{
    button.disable_irq();
    timer.stop();
    temps = timer.read_us();
    dist=(temps-370.0)*(vitesse/1000000.0);  //calcule la distance (eqution de calibration du système, considére la reponse et vitesse)
    if(dist<0.14){
        dist=dist+0.06;
        d[indice-1]=dist;
    }
    if(dist>0.14 && dist<0.26){
        dist=dist+0.05;
        d[indice-1]=dist;
    }
    if(dist>0.26 && dist<0.34){
        dist=dist+0.04;
        d[indice-1]=dist;
    }
    if(dist>0.34 && dist<0.51){
        dist=dist+0.03;
        d[indice-1]=dist;
    }
    else{
         d[indice-1]=dist;  
    }
    //printf("distance=%f\r\n",(temps-70.0)*(vitesse/1000000.0);
    //wait_ms(3);
    timer.reset();
    //a=1;
}
 
// Network uses that radio
RF24Network network(radio);
 
// Address of our node
const uint16_t this_node = 00;
 
// Address of the other node
const uint16_t other_node1 = 00;
const uint16_t other_node2 = 001;
 
// How often to send payload packet to the other unit
const unsigned long interval = 1000; //ms
 
// When did we last send?
unsigned long last_sent;
Timer t;
 
// How many have we sent already
unsigned long packets_sent;
Timer t_packet;
 
// Structure of our payload
struct payload_t 
{
    unsigned long ms;
    unsigned long counter;
};
 
void emmeteur(){
 
            pc.printf("Sending : %d...",indice+1);
            payload_t payload_tx;
            payload_tx.ms = t_packet.read_ms();
            payload_tx.counter = packets_sent++;
 
            RF24NetworkHeader header_tx(/*to node*/ addr[indice]);
            bool ok = network.write(header_tx,&payload_tx,sizeof(payload_tx));
            if (ok){
                timer.start();
                pc.printf("ok : %d\r\n",indice+1);
               // a=1;
                }
            else
                pc.printf("failed : %d.\r\n",indice+1);
     
     
}
 void emmeteur2(){
 
           pc.printf("Sending : 2...");
            payload_t payload_tx;
            payload_tx.ms = t_packet.read_ms();
            payload_tx.counter = packets_sent++;
 
            RF24NetworkHeader header_tx(/*to node*/ other_node2);
            bool ok = network.write(header_tx,&payload_tx,sizeof(payload_tx));
            if (ok){
                timer.start();
                pc.printf("ok : 2.\r\n");
               // a=1;
                }
            else
                pc.printf("failed : 2.\r\n");     
}
int main()
{
  //  double cpt=0;
    float d1,d2;
    pc.baud(115200);
    wait_ms(1000);
 
    pc.printf("mBed RF24Network node: Tx\r\n");
    radio.begin();
    network.begin(/*channel*/ 53, /*node address*/ this_node);
    wait_ms(2000);
    t.start();
    t_packet.start();
   // temperature = 25;
//    for (int i=0;i<10;i++) {
//        temperature += LM35.read();
//        wait_ms(10);
//    }  
  //  temperature = temperature*34;
    
    vitesse = 342.0;//331.5 + 0.595*temperature;
    
    button.rise(&pressed);
    while(1) 
    {
         
        // Pump the network regularly
        network.update();
        //if(a==0){
        /* If it's time to send a message, send it! */
        unsigned long now = t.read_ms();
        if ( now >= interval  ) 
        {
            if(indice > 2) {
                for(int j=0; j<n; j++)
                printf("distance %d = %f\r\n",j+1,d[j]);
                position_abs(610.0,600.0,d[0]*1000,d[1]*1000,d[2]*1000);
                indice = 0;
        }
            t.reset();
            
            button.enable_irq();
            emmeteur();
            button.enable_irq();
 
            indice++;
        }
    }
}
 
void position_abs(double L, double l, double d1, double d2, double d3)
{
        printf("Hellooooooo auj!! \r\n");
        
        double w = l; /* dim terrain */
        double u = sqrt(pow((double)  L,2)+pow((double) l/2,2)), v = u;
        double q = acos((w/2)/v), r = 18.44, t=q;
        
        /* triangle (B1,R,B3) */
        
        double k = acos((pow(d1,2)+pow(v,2)-pow(d3,2))/(2*d1*v));
        //printf("k = %lf \n\r",k);
        double alpha = acos((pow(d1,2)+pow(d3,2)-pow(v,2))/(2*d1*d3));
        //printf("alpha = %lf \n\r",alpha);
        double p = acos((pow(v,2)+pow(d3,2)-pow(d1,2))/(2*v*d3));
        //printf("p = %lf \n\r",p);
        
        /* triangle (B2,R,B3)*/
        
        double O = acos((pow(d3,2)+pow(u,2)-pow(d2,2))/(2*d3*u));
        //double O = acos((pow(d3,2)+pow(d2,2)-pow(u,2))/(2*d3*d2));
        //printf("O = %lf \n\r",O);
        double m = acos((pow(u,2)+pow(d2,2)-pow(d3,2))/(2*u*d2));
        //double m = acos((pow(d3,2)+pow(u,2)-pow(d2,2))/(2*u*d3));
        //printf("m = %lf \n\r",m);
        /* triangle (B1,R,B2) */
        
        double i = acos(((double) pow((double) w,2)+(double) pow((double) d1,2)-(double) pow((double) d2,2))/(double) (2*w*d1));
        //printf(" i= %lf \n\r",i);
        double j = acos(((double) pow((double) d2,2)+(double) pow((double) w,2)-(double) pow((double) d1,2))/(double) (2*w*d2));
        //printf(" j= %lf \n\r",j);
        
        /* triangle (B1,R,B3) */
        double x1 = w/2 + cos(3.14-(p+q))*d3;
        //printf(" x1= %lf \n\r",x1);
        double y1 = sin(3.14-(p+q))*d3;
        //printf(" y1= %lf \n\r",y1);
        
        /* triangle (B1,R,B2) */
        
        double x2 = cos(i) *d1;
        //printf(" x2= %lf \n\r",x2);
        double y2 = L - sin(i)*d1;
        //printf(" y2= %lf \n\r",y2);
        
        /* triangle (B2,R,B3)*/
        
        double x3 = w/2 + cos(O+t)*d3;
        //printf(" x3= %lf \n\r",x3);
        double y3 = sin(O+t)*d3;
        //printf(" y3= %lf \n\r",y3);
        
        double xt = (x1+x2+x3)/3;
        printf(" xt= %lf \r\n",xt);
        double yt = (y1+y2+y3)/3;
        printf(" yt= %lf \r\n",yt);
}
 