#include "mbed.h"
#include <RF24Network.h>
#include <RF24.h>
 
Serial pc(USBTX, USBRX);
InterruptIn button(D8);
AnalogIn LM35(A2);
    

RF24 radio(SPI_MOSI, SPI_MISO, SPI_SCK, D9, SPI_CS );
Timer timer;
unsigned int temps;
int a=0;
float temperature;
float vitesse;

const int n = 3;
int addr[n] = {01,02,03};
float d[n];
int indice=0;

void pressed()
{
    button.disable_irq();
    timer.stop();
    temps = timer.read_us();
    d[indice-1]=(temps-370.0)*(vitesse/1000000.0);
    //printf("distance=%f\r\n",(temps-70.0)*(vitesse/1000000.0);
    //wait_ms(3);
    timer.reset();
    //a=1;
}
 
// Network uses that radio
RF24Network network(radio);
 
// Address of our node
const uint16_t this_node = 00;
 
// Address of the other node
const uint16_t other_node1 = 00;
const uint16_t other_node2 = 001;
 
// How often to send payload packet to the other unit
const unsigned long interval = 1000; //ms
 
// When did we last send?
unsigned long last_sent;
Timer t;
 
// How many have we sent already
unsigned long packets_sent;
Timer t_packet;
 
// Structure of our payload
struct payload_t 
{
    unsigned long ms;
    unsigned long counter;
};
 
 
 void emmeteur(){

            pc.printf("Sending : %d...",indice+1);
            payload_t payload_tx;
            payload_tx.ms = t_packet.read_ms();
            payload_tx.counter = packets_sent++;
 
            RF24NetworkHeader header_tx(/*to node*/ addr[indice]);
            bool ok = network.write(header_tx,&payload_tx,sizeof(payload_tx));
            if (ok){
                timer.start();
                pc.printf("ok : %d\r\n",indice+1);
               // a=1;
                }
            else
                pc.printf("failed : %d.\r\n",indice+1);
     
     
}
 void emmeteur2(){

           pc.printf("Sending : 2...");
            payload_t payload_tx;
            payload_tx.ms = t_packet.read_ms();
            payload_tx.counter = packets_sent++;
 
            RF24NetworkHeader header_tx(/*to node*/ other_node2);
            bool ok = network.write(header_tx,&payload_tx,sizeof(payload_tx));
            if (ok){
                timer.start();
                pc.printf("ok : 2.\r\n");
               // a=1;
                }
            else
                pc.printf("failed : 2.\r\n");
     
     
}
 
 
 
 
int main()
{
  //  double cpt=0;
    float d1,d2;
    pc.baud(115200);
    wait_ms(1000);
 
    pc.printf("mBed RF24Network node: Tx\r\n");
    radio.begin();
    network.begin(/*channel*/ 90, /*node address*/ this_node);
    wait_ms(2000);
    t.start();
    t_packet.start();
   // temperature = 25;
//    for (int i=0;i<10;i++) {
//        temperature += LM35.read();
//        wait_ms(10);
//    }
    
    
    
    
  //  temperature = temperature*34;
    
    vitesse = 342.0;//331.5 + 0.595*temperature;
    
    button.rise(&pressed);
    while(1) 
    {
         
        // Pump the network regularly
        network.update();
        //if(a==0){
        /* If it's time to send a message, send it! */
        unsigned long now = t.read_ms();
        if ( now >= interval  ) 
        {
            if(indice > 2) {
                for(int j=0; j<n; j++)
                    printf("distance %d = %f\r\n",j+1,d[j]);
                indice = 0;
            }
            t.reset();
            
            button.enable_irq();
            emmeteur();
            button.enable_irq();

            indice++;
        }
       
       
        //}
           
            
            
        
       
 
 
    }
 
}