#include "mbed.h"
#include <RF24Network.h>
#include <RF24.h>
 
Serial pc(USBTX, USBRX);
InterruptIn button(D4);
 
PwmOut mypwm(D5);
 
RF24 radio(SPI_MOSI, SPI_MISO, SPI_SCK, D9, SPI_CS );

DigitalIn A(D8);
DigitalIn B(D7);
DigitalIn C(D6);


// Network uses that radio
RF24Network network(radio);
 
 
// Address of our node
uint16_t this_node;

// Address of the other node
const uint16_t other_node = 00;
 
// When did we last send?
unsigned long last_sent;
 
// How many have we sent already
unsigned long packets_sent;
 
// Structure of our payload
struct payload_t 
{
    unsigned long ms;
    unsigned long counter;
};
 
//interruption du NRF24
void pressed()
{
    mypwm.write(0.5);
}
 
int main()
{
    button.enable_irq();
    button.rise(&pressed);
    mypwm.period_us(40);
    mypwm.pulsewidth_us(20);
    mypwm.write(0.0);
    
if((!A.read()) && (!B.read()) && (C.read()) ) this_node = 01;
else if(!(A.read()) && (B.read()) && !(C.read()) ) this_node = 02;
else this_node = 03;

    pc.baud(115200);
    wait_ms(500);
 
    pc.printf("mBed RF24Network node\r\n");
    radio.begin();
    network.begin(/*channel*/ 90, /*node address*/ this_node);
    wait_ms(1000);
 
    while(1) 
    {
        // Pump the network regularly
        network.update();
        
        // Is there anything ready for us?
        while ( network.available() ) 
        {
            // If so, grab it and print it out
            RF24NetworkHeader header_rx;
            payload_t payload_rx;
            network.read(header_rx,&payload_rx,sizeof(payload_rx));
            pc.printf("Received packet # %d at %d ms\r\n",payload_rx.counter,payload_rx.ms);
            
            wait_us(1750);
            mypwm.write(0.0);
        }
 
    }
 
}   
   