/**
 * @author Thomas Hamain
 *
 * @section DESCRIPTION
 *  Librairie pour le double pont H L298 prennant simplement en paramètre une valeur de -1 à 1
 *
 */

#ifndef L298_H
#define L298_H

/**
 * Includes
 */
#include "mbed.h"


/**
 * Class L298 représente un module
 */
class L298
{
public:
    /**
     * Constructeur.
     * Initialise la STM32 pour être branchée au L298
     *
     * @param ENA mbed pin pour ENA.
     * @param ENB mbed pin pour ENB.
     * @param ENA mbed pin pour IN1.
     * @param ENB mbed pin pour IN2.
     * @param ENA mbed pin pour IN3.
     * @param ENB mbed pin pour IN4.
     * @param freq_pwm la fréquence de la PWM envoyée au pont H (tester avec 
     * valeur negative mais je pense que le compilateur insulte!)
     */
    L298(PinName ena, PinName enb, PinName in1, PinName in2, PinName in3, PinName in4, double freq_pwm);

    /**
    * Constructeur par default
    * Initialise par défaut:
    * - D6  : ENA (PWM du moteur A)
    * - D11 : ENB (PWM du moteur B)
    * - D7  : IN1
    * - D8  : IN2
    * - D9  : IN3
    * - D10 : IN4
    *
    * La fréquence de la PWM envoyée aux moteurs est de 1kHz.
    * 
    * Pour plus d'information sur les pins INx, se référer au fonctionnement du L298 (et completer la doc de la classe)
    */
    
    L298();
    
    /**
    * Contrôle du moteur A.
    * Envoie une PWM avec le rapport cyclique allant de -1 à 1. Le signe de la 
    * valeur passée en paramètre indique la direction. La valeur de zéro 
    * correspond à un arrêt du moteur. La fréquence de la PWM peut être connue 
    * ou modifiée grâce à respectivement getPeriodePwm et setPeriodePwm.
    *
    * @param rc rapport cyclique -1 à 1.
    */
    void A(double rc);
    
    /**
    * Contrôle du moteur A.
    * Envoie une PWM avec le rapport cyclique allant de -1 à 1. Le signe de la 
    * valeur passée en paramètre indique la direction. La valeur de 0 
    * correspond à un arrêt du moteur. (ajouter une fonction permettant de 
    * modifier la fréquence de la PWM.
    *
    * @param rc rapport cyclique -1 à 1.
    */    
    void B(double rc);
    
    


private:
    PwmOut _ena;
    PwmOut _enb;
    
    DigitalOut _in1;
    DigitalOut _in2;
    DigitalOut _in3;
    DigitalOut _in4;
    
    double _periode_pwm; //Periode de la PWM envoyé au pont H
    
};



#endif /* L298_H */