#include "VL53L0X.h"
#include "mbed.h"

DevI2C i2C(PB_9, PB_8);
DigitalOut Pin_Out(PB_9);
VL53L0X capteur(&i2C, &Pin_Out, PA_8, VL53L0X_DEFAULT_ADDRESS);
VL53L0X_Dev_t MyDevice;
VL53L0X_Dev_t *pMyDevice = &MyDevice;
int distance(uint32_t *p_data);

int main(){
    uint32_t status = 0;
    uint32_t *dist;
    
    printf("\n\r");
    printf("\n\r");
    //pMyDevice->comms_type = 1;
    //pMyDevice->comms_speed_khz = 400;

    capteur.init_sensor(VL53L0X_DEFAULT_ADDRESS);
    //capteur.disable_interrupt_measure_detection_irq();
    while(1){
        status = distance(dist);
        printf("Distance : %d mm\n\r", *dist);
        printf("Statut : %d \n\r", status);
        printf("\n");
        wait(0.2);
    }
    capteur.VL53L0X_off();
}

int distance(uint32_t *p_data){
    int status = 0;
    VL53L0X_RangingMeasurementData_t measurement_data;

    status = capteur.start_measurement(range_single_shot_polling, NULL);
    if (!status) {
        status = capteur.get_measurement(range_single_shot_polling, &measurement_data);
    }
    if (measurement_data.RangeStatus == 0) {
        *p_data = measurement_data.RangeMilliMeter;
    } else {
        *p_data = 0;
        status = VL53L0X_ERROR_RANGE_ERROR;
    }
    capteur.stop_measurement(range_single_shot_polling);
    return status;
}