/**
 * @author Thomas Hamain
 *
 * @section DESCRIPTION
 *  [EMPTY]
 *
 */

#ifndef ASSERVISSEMENT_H
#define ASSERVISSEMENT_H

# define M_PI           3.14159265358979323846

/**
 * Includes
 */
#include "mbed.h"
#include "QEI.h"
#include "L298.h"
#include "math.h"

/**
 * Class [EMPTY] on parle en mm
 */
class Asservissement
{
public:

    typedef enum AUTORISATION {

        OUI,
        NON

    }AUTORISATION;

    typedef enum PID {

        LINEIQUE,
        ANGULAIRE

    } PID;
    /**
     * Constructeur.
     * [EMPTY]
     *
     * @param [EMPTY]
     */
    Asservissement(L298 pontH, QEI encodA, QEI encodB, double freq_asserv);


    double calculPID(double erreur,PID type);


    void move(double dist, double or_deg);
    
    void move(AUTORISATION rep);


    void setPID(PID type, double P, double I, double D);


    void setDimensions(int dist_roues, int dimA, int dimB, int ticA, int ticB);


    void setDimensions(int dist_roues, int dim, int tic);


    void setCalculateur(double lim_vitesseA, double lim_vitesseB, double accA, double accB, double deccA, double deccB);


    void setCalculateur(double lim_vitesse, double acc, double decc);

    //[FONCTION] un truc qui defini les trajectoire
    // doit inclure une option permettant de choir l'acceleration + decceleration
    // et une vitesse limite
    // il devra avoir un espece d'interrupt timer et poser un flag pour que la
    // boucle dans le move() s'arrete si besoin faudra y penser

    //[FONCTION] un truc pour calibrer automatiquement
    //IDEE DE FONCTIONNEMENT, 2 boucles, boucle 1 change de coefficient, boucle 2
    //demande à l'utilisateur de combien il veut incrémenter le coefficient










    //Fonctions de set get
    //PID Lineique
    double getPl()
    {
        return _Pl;
    }
    void setPl(double n)
    {
        _Pl=n;
    }

    double getIl()
    {
        return _Il;
    }
    void setIl(double n)
    {
        _Il=n;
    }

    double getDl()
    {
        return _Dl;
    }
    void setDl(double n)
    {
        _Dl=n;
    }

    //PID Angulaire
    double getPa()
    {
        return _Pa;
    }
    void setPla(double n)
    {
        _Pa=n;
    }

    double getIa()
    {
        return _Ia;
    }
    void setIa(double n)
    {
        _Ia=n;
    }

    double getDa()
    {
        return _Da;
    }
    void setDa(double n)
    {
        _Da=n;
    }

    //echantillonnage
    double getfreq_correction()
    {
        return _freq_correction;
    }
    void setfreq_correction(double n)
    {
        _freq_correction=n;
    }

    //dimensions du système
    double getdist_roues()
    {
        return _dist_roues;
    }
    void setdist_roues(double n)
    {
        _dist_roues=n;
    }

    double getdimA()
    {
        return _dimA;
    }
    void setdimA(double n)
    {
        _dimA=n;
    }

    double getdimB()
    {
        return _dimB;
    }
    void setdimB(double n)
    {
        _dimB=n;
    }

    double getticA()
    {
        return _ticA;
    }
    void setticA(double n)
    {
        _ticA=n;
    }

    double getticB()
    {
        return _ticA;
    }
    void setticB(double n)
    {
        _ticA=n;
    }

    //valeurs pour le calculateur de trajectoires
    double getlim_vitesseA()
    {
        return _lim_vitesseA;
    }
    void setlim_vitesseA(double n)
    {
        _lim_vitesseA=n;
    }

    double getlim_vitesseB()
    {
        return _lim_vitesseB;
    }
    void setlim_vitesseB(double n)
    {
        _lim_vitesseB=n;
    }

    double get_accA()
    {
        return _accA;
    }
    void set_accA(double n)
    {
        _accA=n;
    }

    double get_accB()
    {
        return _accB;
    }
    void setP_accB(double n)
    {
        _accB=n;
    }

    double getdeccA()
    {
        return _deccA;
    }
    void setdeccA(double n)
    {
        _deccA=n;
    }

    double getdeccB()
    {
        return _deccB;
    }
    void setdeccB(double n)
    {
        _deccB=n;
    }


private:

    //variables importantes
    L298 _pontH;
    QEI _encodA;
    QEI _encodB;
    double _dist;
    double _or_deg;

    //coeffs pour PID lineique
    double _Pl; //0.01
    double _Il; //0.0001
    double _Dl;

    //coeffs pour PID angulaire
    double _Pa; //0.01
    double _Ia; //0.0001
    double _Da;

    //echantillonnage #BOZ
    double _freq_correction; //0.01

    //probablement ballec
    //double _err_statique;
    //double LIMITE_TEMPS 3/FREQ_CORRECTION (3sec)

    //dimensions du système
    int _dist_roues; //distance entre les roues 270
    int _dimA; //dimension roue a 70
    int _dimB; //dimension roue a 70
    int _ticA; //nombre de tic par tour encodeur a (il faudra faire des calculs lors de la déclaration parce que ca correspond pas vraiment par rapport a la datasheet) 1200
    int _ticB; //nombre de tic par tour encodeur b 1200
    double _resA; //mm/tic calculé par (double)DIMENSION_ROUE_A*3.14/(double)TIC_PAR_TOUR_A
    double _resB;

    //valeurs pour le calculateur de trajectoires (valeurs symétriques)
    //valeurs modifiées par calculateur de trajectoires
    double _lim_vitesseA; //limites de vitesse A et B
    double _lim_vitesseB;
    double _accA; //acceleration pour A et B (pas étudié)
    double _accB;
    double _deccA; //decceleration pour A et B (pas étudié)
    double _deccB;




};



#endif /* ASSERVISSEMENT_H */