/**
 * Includes
 */
#include "Asservissement.h"



Asservissement::Asservissement(L298 pontH, QEI encodA, QEI encodB, double freq_asserv=100):_pontH(pontH), _encodA(encodA), _encodB(encodB), _freq_correction(freq_asserv)
{
    _dist = 0;
    _or_deg = 0;
}

void Asservissement::move(AUTORISATION rep)
{
    //uniquement appelé par le créateur de trajectoire
    //c'est à ca que ça sert le "autorisation"
    if (rep == OUI)
    {
        
    
    double or_dist = _or_deg * _dist_roues * M_PI / 360;
    double a,b,err_dist,err_ori,pid_dist,pid_ori,pid_a,pid_b;
    
    //trouver une condition à laquelle sortir de la boucle
    //IDEE on incremente un compteur si les deux err sont en dessous d'une
    // limite #double _err_statique sinon il retombe à 0 et si pendant 
    //LIMITE_TEMPS = 3/FREQ_CORRECTION on atteind compteur = limite_temps 
    //alors on sort de la boucle (ca avait bien marché quand j'avais fait des 
    // test en mode yolo
    //pourrait etre interessant de voir si le createur de trajectoire peut
    // pas y faire quelques chose lui aussi
    
    while(1) 
    {
        a = _encodA.getPulses() * _resA;
        b = _encodB.getPulses() * _resB;
        
        err_dist = _dist - (a + b) /2;
        err_ori = or_dist - (a - b) /2;

        pid_dist = calculPID(err_dist,LINEIQUE);
        pid_ori = calculPID(err_ori,ANGULAIRE);

        pid_a = - pid_dist + pid_ori;
        pid_b = - pid_dist - pid_ori;
        
        if (pid_a>_lim_vitesseA)
            pid_a = _lim_vitesseA;
        else if (pid_a<-_lim_vitesseA)
            pid_a = -_lim_vitesseA;

        if (pid_b>_lim_vitesseB)
            pid_b=_lim_vitesseB;
        else if (pid_b<-_lim_vitesseB)
            pid_b = -_lim_vitesseB;


        _pontH.A(pid_a);
        _pontH.B(pid_b);
        wait(_freq_correction);
        
    }
    }
    
}

void Asservissement::move(double dist, double or_deg)
{
    
    double or_dist = or_deg * _dist_roues * M_PI / 360;
    double a,b,err_dist,err_ori,pid_dist,pid_ori,pid_a,pid_b;
    
    //trouver une condition à laquelle sortir de la boucle
    //IDEE on incremente un compteur si les deux err sont en dessous d'une
    // limite #double _err_statique sinon il retombe à 0 et si pendant 
    //LIMITE_TEMPS = 3/FREQ_CORRECTION on atteind compteur = limite_temps 
    //alors on sort de la boucle (ca avait bien marché quand j'avais fait des 
    // test en mode yolo
    //pourrait etre interessant de voir si le createur de trajectoire peut
    // pas y faire quelques chose lui aussi
    
    //peut être qu'il faut faire un truc en mode, le calculateur de trajectoire
    //defini en permanance une nouvelle trajectoire, vue que c'est dans la mm
    //class, on pourrait plutôt jouer sur le fait que move utilise des variables
    //privées _dist et _or_deg
    //c'est pour ca que j'ai fait une fonction move qui prend rien en parametre
    //elle sera appellée par le générateur de trajectoire
    while(1) 
    {
        a = _encodA.getPulses() * _resA;
        b = _encodB.getPulses() * _resB;
        
        err_dist = dist - (a + b) /2;
        err_ori = or_dist - (a - b) /2;

        pid_dist = calculPID(err_dist,LINEIQUE);
        pid_ori = calculPID(err_ori,ANGULAIRE);

        pid_a = - pid_dist + pid_ori;
        pid_b = - pid_dist - pid_ori;
        
        if (pid_a>_lim_vitesseA)
            pid_a = _lim_vitesseA;
        else if (pid_a<-_lim_vitesseA)
            pid_a = -_lim_vitesseA;

        if (pid_b>_lim_vitesseB)
            pid_b=_lim_vitesseB;
        else if (pid_b<-_lim_vitesseB)
            pid_b = -_lim_vitesseB;


        _pontH.A(pid_a);
        _pontH.B(pid_b);
        wait(_freq_correction);
        
    }
    /*

    float orientation_dist = orientation_deg * (float)DISTANCE_ENTRE_ROUES * 3.14 / 360;

    while(1)
    {
        pulse_a = (float)encodeur_a.getPulses() * res_a;
        pulse_b = (float)encodeur_b.getPulses()* res_b;

        err_dist = distance - (pulse_a + pulse_b) /2;
        err_ori = orientation_dist - (pulse_a - pulse_b) /2;

        printf("%f\t%f\t%f\t%f\n\r",err_dist,err_ori,pulse_a,pulse_b);

        pid_dist = PID(err_dist,LINEIQUE);
        pid_ori = PID(err_ori,ANGULAIRE);

        pid_a = - pid_dist + pid_ori;
        pid_b = - pid_dist - pid_ori;


        //printf("%f\n\r",pulse_a);

        n_commande_a = pid_a;
        n_commande_b = pid_b;


        if (n_commande_a>1)
            n_commande_a=LIMITE_VITESSE;
        else if (n_commande_a<-LIMITE_VITESSE)
            n_commande_a = -LIMITE_VITESSE;

        if (n_commande_b>LIMITE_VITESSE)
            n_commande_b=LIMITE_VITESSE;
        else if (n_commande_b<-LIMITE_VITESSE)
            n_commande_b = -LIMITE_VITESSE;


        //moteur_a(n_commande_a);
        //moteur_b(n_commande_b);
        wait(FREQ_CORRECTION);

    }


    */
}

//donne le coefficient à balancer dirrecteument
double Asservissement::calculPID(double erreur,PID type)
{
    static double errPrev = 0;
    static double errSum = 0;
    static double errDif = 0;

    double P,I,D;

    errSum += erreur;

    errDif = erreur - errPrev;
    errPrev = erreur;

    if (type == LINEIQUE) {
        P = erreur * _Pl;
        I = errSum * _Il;
        D = errDif * _Dl;
    } else if (type == ANGULAIRE) {
        P = erreur * _Pa;
        I = errSum * _Ia;
        D = errDif * _Da;
    }

    return P + I + D;
}

void Asservissement::setPID(PID type, double P, double I, double D)
{
    if (type == LINEIQUE) {
        _Pl = P;
        _Il = I;
        _Dl = D;
    } else if (type == ANGULAIRE) {
        _Pa = P;
        _Ia = I;
        _Da = D;
    }
}


void Asservissement::setDimensions(int dist_roues, int dimA, int dimB, int ticA, int ticB)
{
        _dist_roues = dist_roues;
        _dimA = dimA;
        _dimB = dimB;
        _ticA = ticA;
        _ticB = ticB;
        
        _resA = _dimA*3.14/_ticA;
        _resB = _dimB*3.14/_ticB;
}


void Asservissement::setDimensions(int dist_roues, int dim, int tic)
{
        _dist_roues = dist_roues;
        _dimA = dim;
        _dimB = dim;
        _ticA = tic;
        _ticB = tic;
        
        _resA = _dimA*3.14/_ticA;
        _resB = _resB;
}


void Asservissement::setCalculateur(double lim_vitesseA, double lim_vitesseB, double accA, double accB, double deccA, double deccB)
{
        _lim_vitesseA = lim_vitesseA;
        _lim_vitesseB = lim_vitesseB;
        _accA = accA;
        _accB = accB;
        _deccA = deccA;
        _deccB = deccB;
}


void Asservissement::setCalculateur(double lim_vitesse, double acc, double decc)
{
        _lim_vitesseA = lim_vitesse;
        _lim_vitesseB = lim_vitesse;
        _accA = acc;
        _accB = acc;
        _deccA = decc;
        _deccB = decc;
}

