/**************************************************************************/
/*!
    @file     Playgame.h
    @author   WTW

    @section v0.4
    adding AreIntersecting function using collision detection

*/
/**************************************************************************/
#ifndef PLAYGAME_H
#define PLAYGAME_H
#include "Pokitto.h"
#include <vector>
#include "bullet.h"
#include "aircraft.h"
#include "palette.h"
#define BULLET_AMOUNT_MAX_EASY 20
#define BULLET_TIME_SPACE_EASY 100
#define BULLET_AMOUNT_MAX_NORMAL 50
#define BULLET_TIME_SPACE_NORMAL 50
#define BULLET_AMOUNT_MAX_HARD 100
#define BULLET_TIME_SPACE_HARD 20
#define BULLET_AMOUNT_MAX_VHARD 200
#define BULLET_TIME_SPACE_VHARD 10
#define BULLET_AMOUNT_MAX_DEAD 300
#define BULLET_TIME_SPACE_DEAD 5

#define AIRCRAFT_X_OFFSET 7
#define AIRCRAFT_Y_OFFSET 7
#define BULLET_X_OFFSET 1
#define BULLET_Y_OFFSET 1

std::vector<bullet> vbullet;
aircraft air1;
int bullettimespace = 0;
int bullet_amount_max = BULLET_AMOUNT_MAX_NORMAL;
int bullet_time_space = BULLET_TIME_SPACE_NORMAL;
uint32_t oldTime,finalTime;
bool AreIntersecting(const aircraft & air, const bullet & bul);
void playgame();

bool AreIntersecting(const aircraft & air, const bullet & bul){ //using collision detection
    return
    !(
        (air.getTop() > bul.getBottom()) || (air.getLeft() > bul.getRight()) ||
        (air.getRight() < bul.getLeft()) || (air.getBottom() < bul.getTop())
    );
}

void playgame(){

    Pokitto::Display::load565Palette(playgame_pal);
    Pokitto::Display::invisiblecolor = PLAYGAME_INVISIBLE_COLOR;

    if (Pokitto::Core::update()) {
        //Pokitto::Display::print(0,0,"live");
        finalTime = Pokitto::Core::getTime()/1000 - oldTime/1000;
        //Pokitto::Display::print(25,0,finalTime);//show living time
        air1.move();
        air1.display();
        ++bullettimespace;

        if(bullettimespace == bullet_time_space){ //control bulltet object max amount
            if(vbullet.size() <= bullet_amount_max){
                bullet *bl = new bullet(air1.getx()+AIRCRAFT_X_OFFSET, air1.gety()+AIRCRAFT_Y_OFFSET);
                vbullet.push_back(*bl);
                }
                bullettimespace = 0;
        }

        for(std::vector<bullet>::iterator bull = vbullet.begin();  bull != vbullet.end(); ++bull){
            bull->move();
            bull->renew(air1.getx()+AIRCRAFT_X_OFFSET, air1.gety()+AIRCRAFT_Y_OFFSET);
            bull->display();
            if( AreIntersecting(air1, *bull)
               ){
                    gameConditon = 2;
                    bullettimespace = 0;
                    air1.clear();
                    vbullet.clear();
                    break;
            }

        }
    }
}
#endif
