/**************************************************************************/
/*!
    @file     Bullet.h
    @author

    @section

*/
/**************************************************************************/
#ifndef BULLET_H
#define BULLET_H
#include "Pokitto.h"
#define BULLET_WIDTH 8
#define BULLET_HEIGHT 8


const uint8_t bullet_bmp[] =
{
4,4,
186,171,
169,154,
169,154,
186,171,
};

class bullet {
public:
    bullet(); //bullet() = default;(C++)
    bullet(int16_t aircraftXaxis, int16_t aircraftYaxis){
        axisIncri = 0;
        randAxis(xaxis, yaxis);
        oldxaxis = xaxis;
        oldyaxis = yaxis;
        gradientB = gradientCal(xaxis, yaxis, aircraftXaxis, aircraftYaxis);
        if(xaxis >= aircraftXaxis){
            leftsign = true;
        }else{
            leftsign = false;
        }

    }

    void renew(int16_t aircraftXaxis, int16_t aircraftYaxis){
        if(renewsign) {
            axisIncri = 0;
            randAxis(xaxis, yaxis);
            oldxaxis = xaxis;
            oldyaxis = yaxis;
            gradientB = gradientCal(xaxis, yaxis, aircraftXaxis, aircraftYaxis);
            if(xaxis >= aircraftXaxis){
                leftsign = true;
            }else{
                leftsign = false;
            }
            renewsign = false;
        }
    }

    void move() {
        if(leftsign){
            yaxis = BackAxis(--axisIncri, gradientB) + oldyaxis;
            xaxis = axisIncri + oldxaxis;
        }else{
            yaxis = BackAxis(++axisIncri, gradientB) + oldyaxis;
            xaxis = axisIncri + oldxaxis;
        }
         if(abs(oldxaxis - xaxis) > 110){
            renewsign = true;
         }

    }

    void display(){
        Pokitto::Display::drawBitmap(xaxis,yaxis,bullet_bmp);
    }

    int16_t getxaxix() const{
        return xaxis;
    }

    int16_t getyaxix() const{
        return yaxis;
    }

    int16_t getLeft() const{
        return xaxis;
    }

    int16_t getRight() const{
        return xaxis + BULLET_WIDTH;
    }

    int16_t getTop() const{
        return yaxis;
    }

    int16_t getBottom() const{
        return yaxis + BULLET_HEIGHT;
    }

private:
    int16_t xaxis, yaxis, oldxaxis, oldyaxis, axisInc, axisIncri;
    bool leftsign, renewsign;
    float gradientB;
    void randAxis(int16_t&, int16_t&);          // giving bullet a random axis outside screen.
    float gradientCal(int16_t, int16_t, int16_t, int16_t); // calculates gradient between bullet and aircraft.
    int16_t BackAxis(int16_t, float);           // calculates a axis in axiscenter by gradient.
};

void bullet::randAxis(int16_t &xaxis, int16_t &yaxis){
    xaxis = rand()%126 - 8;
    if((xaxis<=-4)||(xaxis>=113)){
        yaxis = rand()%96 -4;
    }else{
        if(rand()%2){
            yaxis = -4;
        }else{
            yaxis = 91;
            }
        }
}
float bullet::gradientCal(int16_t x1, int16_t y1, int16_t x2, int16_t y2){
    float i = (static_cast<float>(x1 - x2)) / (y1 - y2);
    // In order to avoid the fastest bullet appearing, because sometime the gradient can be a tiny number.
    if(i <= 0.3 && i >= 0){
        return 0.5;
    }else if (i >= -0.3 && i < 0){
        return -0.5;
    }else{
        return (static_cast<float>(x1 - x2)) / (y1 - y2);
    }
}

int16_t bullet::BackAxis(int16_t axis, float gradient){
    return axis / gradient;
}
#endif
