/**************************************************************************/
/*!
    @file     aircraft.h
    @author   WTW

    @section  v0.3

collision
*/
/**************************************************************************/

#ifndef AIRCRAFT_H
#define AIRCRAFT_H
#include "Pokitto.h"
#define AIRCRAFT_INIT_XAXIX 47
#define AIRCRAFT_INIT_YAXIX 35
#define AIRCRAFT_COLLISION_XAXIS_OFFSET 7
#define AIRCRAFT_COLLISION_YAXIS_OFFSET 7
#define AIRCRAFT_COLLISION_WIDTH 2
#define AIRCRAFT_COLLISION_HEIGHT 2
//Sprite sheet:3x3
extern const uint8_t aircraft_bmp [][114];

class aircraft {
public:

    aircraft():xaxis(AIRCRAFT_INIT_XAXIX),yaxis(AIRCRAFT_INIT_YAXIX),upsign(false), leftsign(false), rightsign(false), downsign(false){

        }
    void move();
    void display();
    void clear(){xaxis = AIRCRAFT_INIT_XAXIX;yaxis = AIRCRAFT_INIT_YAXIX;upsign = false;leftsign = false;rightsign = false;downsign = false;}
    int16_t getx() const{ return xaxis; }
    int16_t gety() const{ return yaxis; }
    int16_t getLeft() const{
        return xaxis + AIRCRAFT_COLLISION_XAXIS_OFFSET;
    }

    int16_t getRight() const{
        return xaxis + AIRCRAFT_COLLISION_XAXIS_OFFSET + AIRCRAFT_COLLISION_WIDTH;
    }

    int16_t getTop() const{
        return yaxis + AIRCRAFT_COLLISION_YAXIS_OFFSET;
    }

    int16_t getBottom() const{
        return yaxis + AIRCRAFT_COLLISION_YAXIS_OFFSET + AIRCRAFT_COLLISION_HEIGHT;
    }

private:
    int16_t xaxis;
    int16_t yaxis;
    bool upsign, leftsign, rightsign, downsign;
};



#endif


