#ifndef GAMEOBJECT_H
#define GAMEOBJECT_H
 

class GameObject {
    
public:
    float x; // paikka pelikentällä
    float y;
    float centerX; // paikka ruudulla
    float centerY; 
    float vx;
    float vy;
    float acceleration;
    float friction;
    float width;
    float height;
    float bounce;
    float mass;
    
    int color;
    int orig_color;
    bool visible;
    bool movable;
    bool active;
    
    void setColor(int);
    bool isMoving();
    
    virtual void draw();
    virtual void move();
    virtual void remove();
    
    void accelerateX(float);
    void accelerateY(float);
    
    void moveX(float);
    void moveY(float);
    
    void bounceX(float); 
    void bounceY(float);
    
    void bounceX();
    void bounceY();
    
    virtual bool checkCollision(GameObject&);
    virtual void doCollision(GameObject&);
    
    GameObject();
    
};

#endif