#include "Pokitto.h"
#include "GameObject.h"

Pokitto::Display gobj_d;
int flipper = 0;


GameObject::GameObject() {
    x = random(-20,20);
    y = random(-15,15);
    vx = 0;//random(-100,100)/100.0f;
    vy = 0;//random(-100,100)/100.0f;
    width = 5;
    height = 5; 
    if (flipper) color = 7; //random(3,12);
    else color = 4;
    flipper = 1 - flipper;
    if (color == 5) color = 2;
    orig_color = color;
    bounce = 0.9f;
    acceleration = 0.15f;
    friction = 0.98f; 
    mass = 1.0f;   
    centerX = 55+x;
    centerY = 44+y;
    movable=true; 
    visible=true;
    active=true;
}

void GameObject::draw() {
    if (!visible) return;
    gobj_d.setColor(color);
    gobj_d.fillRect(55-width/2+x,44-height/2+y,width,height);  
    centerX = 55+x;
    centerY = 44+y;  
}

void GameObject::move() {
    if (!active) return;
    if (!movable) return;
    x += vx;
    y += vy;
    centerX = 55+x;
    centerY = 44+y;   
    vx *= friction;
    vy *= friction;
    if (abs(vx*10) < 1 && abs(vy*10) <1) vx = vy = 0; // practically stopped
}
 
bool GameObject::isMoving() {
    if (vx == 0 && vy == 0) return false;
    return true;    
} 

void GameObject::remove() {
    active=false;
    visible=false;
    vx = 0;
    vy = 0;
}
 
void GameObject::moveX(float n) {
    x += n;  
    centerX = 55+x;  
}
     
void GameObject::moveY(float n) {
    y += n;    
    centerY = 44+y;
}    

void GameObject::accelerateX(float a) {
    vx += a*acceleration; 
}

void GameObject::accelerateY(float a) {
    vy += a*acceleration; 
}

void GameObject::bounceY() {
    vy = -vy * bounce; 
}

void GameObject::bounceX() {
    vx = -vx * bounce; 
}

void GameObject::bounceY(float bouncefactor) {
    vy = -vy * (bounce*bouncefactor); 
}

void GameObject::bounceX(float bouncefactor) {
    vx = -vx * (bounce*bouncefactor); 
}

bool GameObject::checkCollision(GameObject& other) {
    if (active == false || other.active == false) return false;
    other.color = 2;
    if ((x + width/2 >= other.x - other.width/2) && (x - width/2 < other.x + other.width/2) && (y + height/2 >= other.y - other.height/2) && (y - height/2 < other.y + other.height/2)) return true; 
    other.color = other.orig_color;
    return false;
}

void GameObject::doCollision(GameObject& other) { 
    if (active == false || other.active == false) return;
    if (!other.movable) {
        //movable vs. immovable collision
        if (x - width/2 < other.x - other.width/2 || x + width/2 > other.x + other.width/2) {
            // collision in vertical wall
            bounceX();  
        } else {
            // collision in horizontal wall
            bounceY();  
    }
    } else {
        // movable vs. movable
        //vx = ((mass-other.mass)/sum_mass)*vx + ((other.mass*2)/sum_mass)*other.vx;
        //other.vx = ((mass*2)/sum_mass)*vx + ((other.mass-mass)/sum_mass)*other.vx;  
        //vy = ((mass-other.mass)/sum_mass)*vy + ((other.mass*2)/sum_mass)*other.vy;
        //other.vy = ((mass*2)/sum_mass)*vy + ((other.mass-mass)/sum_mass)*other.vy; 
        float tvx, tvy;
        tvx = vx; tvy = vy;
        vx = other.vx*bounce; vy = other.vy*bounce;
        other.vx = tvx*bounce; other.vy = tvy*bounce;
    }
    // move the object out of each other to avoid more collisions
    int i=0;
    while (checkCollision(other) && ++i < 10) {move(); if (other.movable) other.move();}
}

void GameObject::setColor(int c) {
    color = c;
    orig_color = c;    
}