/* This file was automatically parsed from an Arduino sourcefile  */
/* by PokittoParser v0.1 Copyright 2016 Jonne Valola              */
/* USE AT YOUR OWN RISK - NO GUARANTEES GIVEN OF 100% CORRECTNESS */

#include <stdint.h>
#include "PokittoCore.h"

const char lev[] PROGMEM = {
  "                                                                "/////////////////////////////////
  "                                               BBBB            F"
  "   BM?B        CC                          B    BB             G"
  "              C  C                      B      ?BB    M??     GG"
  "          gGGG    GGG      g g      B           BB           GGG"
  "GGGGGGGGGGGGGG    GGGGGGGGGGGGGGG         GGGGGGGGGGGGGGGGGGGGGG"

  "  GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG"/////////////////////////////////
  "   CCC              g         GCCCCCCCCCCCCCCCCCCCCCCC          "
  "                  B??B        GBBGGGGGGGGGGGGGGGGGGGGG     CCC  "
  "   ?M?    BBBBBBB?B  B                                          "
  "            g     B                              BB    g g     F"
  "GGGGGGGG  GGGGGGGGGGGGGGGGGG  GGG   GG   GG   GGGGGGGGGGGGGGGGGG"

  "               GGGGGGGGGGG         GGGGGGGGGGGGGGGGGGGGG    GGGG"/////////////////////////////////
  "  GGGGGGGG  G  CCCCCC GG        GGGGGGGGGGGGGGGGGGGGGGGG    GGGG"
  "GGG         G              GGGGGGGGGGG               GGG    GGGG"
  "GGG  GGGGGGGGGGGGGGGGGGGGGGGG   GGGGGG   GGGGGGGGGGG GGG        "
  "GGG                                g     GGGGGGGGGGGFGGG        "
  "GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG"

  "                            BB                                  "/////////////////////////////////
  "                         BBCCC                                  "
  "    CC CC CC CC CC CC BBCCCCCC CC CC CC CC CC CC CC CC CC       "
  "                        CCCCCC     GG                          F"
  "GGGG  g  g  g  g  g  g  g  g  g  g Gg  g  G  g  g  g  g  gGGGGGG"
  "GGGGSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSGGGGGG"

  "      S                                                    GGG  "/////////////////////////////////
  "      B   M               S      S                         GFG  "
  "BBBBBBB                  BBB    BBB                        GBG  "
  "CCCCCCC            BB                  S                        "
  "         GGG             BBB          BBB    G g g g g gG       "
  "GGGGGGGGGGGGGGGGG                            GGGGGGGGGGGGGGGGG  "

  "                                                                "/////////////////////////////////
  "                                               IIII            F"
  "   IM?I        CC                          I    II             I"
  "              C  C                      I      ?II    M??     II"
  "          gIII    III      g g      I           II           III"
  "IIIIIIIIIIIIII    IIIIIIIIIIIIIII         IIIIIIIIIIIIIIIIIIIIII"



  "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"/////////////////////////////////
  "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"
  "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"
  "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"
  "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC"
  "GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG"
};




#include "PokittoCore.h"
/* Auto-generated function declarations */
void loadLevel(int);
void nextLevel();
void drawLevel();
void removeEnt(int);
void clearEnts();
void addEnt(int, int,const byte *);
void updateEnt();
boolean Collide(float, float, const byte*);
void setup();
void loop();
void Menu();
void start();
void startGame();
void inputCode();
void controls();
void lose();
void win();
void startTimer();
void updateDisplay();
void startPlayer();
void updatePlayer();
void drawPlayer();
void getBig();
void getSmall();
void die();
boolean playerCollide();
void checkCode(char*);
Pokitto::Core gb;


#define MENULENGTH 4
const char strPlay[] PROGMEM = "Play Game";
const char strMainMenu[] PROGMEM = "Main Menu";
const char strCode[] PROGMEM = "Input a code";
const char strControls[] PROGMEM = "Controls";
const char* const menu[MENULENGTH] PROGMEM = {
  strPlay, strMainMenu, strControls, strCode,
};


typedef struct {
  int invincible;
  float x;
  float vx;
  float y;
  float vy;
  byte h;
  boolean flip;
  boolean big;
  boolean crouch;
} Char;

typedef struct{
  float x;
  float y;
  float vx;
  float vy;
  boolean flip;
  const byte *bitmap;
} Entity;



extern const byte font3x5[];
extern const byte font5x7[];
extern const byte Title[] PROGMEM;
extern const char lev[] PROGMEM;
extern const byte Ground[] PROGMEM;
extern const byte Spikes[] PROGMEM;
extern const byte Brick[] PROGMEM;
extern const byte MysteryBlockC[] PROGMEM;
extern const byte MysteryBlockM[] PROGMEM;
extern const byte Coin[] PROGMEM;
extern const byte Empty[] PROGMEM;
extern const byte PlayerS[] PROGMEM;
extern const byte PlayerS1[] PROGMEM;
extern const byte PlayerT[] PROGMEM;
extern const byte PlayerT1[] PROGMEM;
extern const byte PlayerT2[] PROGMEM;
extern const byte PlayerT3[] PROGMEM;
extern const byte PlayerT4[] PROGMEM;
extern const byte PlayerT5[] PROGMEM;
extern const byte PlayerT6[] PROGMEM;
extern const byte PlayerC[] PROGMEM;
extern const byte Mushroom[] PROGMEM;
extern const byte Goomba[] PROGMEM;
extern const byte Flag[] PROGMEM;
Char player;


int cameraPos;
int frames;
int score;
int curLev;
int numLevs = 6;
int lives = 5;
byte time_b;
boolean running;
boolean disp = true;
char code[12] = "";

const byte *_block;
char curLevel[384] = "";


int main() {
    setup();
    while (gb.isRunning()) {
        loop();
    }
}

void loadLevel(int curLev){
  for(int i = 0; i<384; i++){//Loops through the level
    curLevel[i] = (char)pgm_read_byte(lev + 384 * (curLev - 1) + i);
  }


}

void nextLevel(){
  if(curLev == numLevs){
    win();
  }
  else{
    gb.popup(("Next Level!"), 20);
    if(curLev == 6){
      gb.popup(("Remember lvl 1?"), 20);
    }
    curLev ++;
    loadLevel(curLev);
    player.y = player.x = 0;
    time_b = 130;
    cameraPos = 0;
  }
}

void drawLevel(){
  for(int i = 0; i<6; i++){
    for(int j = 0; j<64; j++){
      if((j*8 - cameraPos >= -8 && j*8 - cameraPos <= LCDWIDTH +8)){
        _block = NULL;
        switch(curLevel[(i)*64+j]){
          case 'G' :
            _block = Ground;
            break;
          case 'B' :
            _block = Brick;
            break;
          case '?' :
            _block = MysteryBlockC;
            break;
          case 'M' :
            _block = MysteryBlockM;
            break;
          case 'C' :
            _block = Coin;
            break;
          case 'S' :
            _block = Spikes;
            break;
          case 'E' :
            _block = Empty;
            break;
          case 'F' :
            _block = Flag;
            break;
          case 'g' :
            curLevel[(i)*64+j] = 'Q';
            addEnt(j*8, LCDHEIGHT - (8 * (6-i)), Goomba);
            break;
          default:
            break;
        }

        if(_block != NULL) {
          if((_block == Coin || _block == Spikes) && gb.frameCount%20 >= 10){
            gb.display.drawBitmap(j*8 - cameraPos, LCDHEIGHT - (8 * (6-i)), _block, NOROT, FLIPH);
          }
          else{
            gb.display.drawBitmap(j*8 - cameraPos, LCDHEIGHT - (8 * (6-i)), _block);
          }
        }
      }
      else if(curLevel[(i)*64+j] == 'Q'){
        curLevel[(i)*64+j] = 'g';
      }

    }
  }
}

#define numEnt  10
Entity entities[10];
boolean collide;



void removeEnt(int i){
  entities[i].bitmap = PlayerC;
  entities[i].x = 0;
  entities[i].vx = 0;
  entities[i].y = 0;
  entities[i].vy = 0;
}

void clearEnts(){
  for(int i = 0; i<numEnt; i++){
    entities[i].x = entities[i].y = entities[i].vx = entities[i].vy = 0;
    entities[i].bitmap = PlayerC;
  }
}

void addEnt(int x, int y,const byte *b){
  for(int i = 0; i<numEnt; i++){
    if(entities[i].bitmap == PlayerC){
      entities[i].bitmap = b;
      entities[i].x = x;
      entities[i].y = y;
      entities[i].vy = 0;
      if(b == Mushroom){
        entities[i].vx = 1;
      }
      else{
        entities[i].vx = -1;
      }

      break;
    }
  }
}

void updateEnt(){
  for(int i = 0; i< numEnt; i++){
    if(entities[i].bitmap != PlayerC){

      entities[i].x += entities[i].vx;
      if(Collide(entities[i].x, entities[i].y, entities[i].bitmap)){
        entities[i].x -= entities[i].vx;
        entities[i].vx *= -1;
      }

      entities[i].vy += .4;
      if(entities[i].vy >2){
        entities[i].vy = 2;
      }

      entities[i].y += entities[i].vy;
      if(Collide(entities[i].x, entities[i].y, entities[i].bitmap)){
        entities[i].y -= entities[i].vy;
        entities[i].vy /= 2;
      }

      if(entities[i].y > LCDHEIGHT || entities[i].x - cameraPos <= -8 || entities[i].x - cameraPos > LCDWIDTH + 8){
        removeEnt(i);
      }

      if(entities[i].bitmap == Goomba && gb.frameCount%10 >= 5){
        gb.display.drawBitmap(entities[i].x - cameraPos, entities[i].y, entities[i].bitmap, NOROT, FLIPH);
      }

      else{
        gb.display.drawBitmap(entities[i].x - cameraPos, entities[i].y, entities[i].bitmap, NOROT, NOFLIP);
      }

    }
  }
}

boolean Collide(float x, float y, const byte* bMap){
  collide = false;
 for(int i = 0; i<6; i++){
    for(int j = 0; j<64; j++){
      _block = NULL;
      switch(curLevel[(i)*64+j]){
        case 'G' :
          _block = Ground;
          break;
        case 'B' :
          _block = Brick;
          break;
        case '?' :
          _block = MysteryBlockC;
          break;
        case 'M' :
          _block = MysteryBlockM;
          break;
        case 'S' :
        case 'I' :
        case 'E' :
          _block = Empty;
          break;
        default:
          break;
      }

      if(!(_block == NULL)){
        if(gb.collideBitmapBitmap(x, y, bMap, j*8, LCDHEIGHT - (8*(6-i)), _block)){
          collide = true;
        }
      }
    }
  }
  return collide;
}


void setup(){
  // initialize the Gamebuino object

  gb.begin();
  gb.display.palette[0]=COLOR_WHITE;
  gb.display.palette[1]=COLOR_BLACK;
  gb.display.setFont(font5x7);
  gb.battery.show = false;
  start();
}


void loop(){
  if(gb.update()){
    gb.battery.show = false;
    if(running){
      updatePlayer();
      updateEnt();
      drawPlayer();
      drawLevel();
      updateDisplay();
    }

  }
}

void Menu(){
  running = false;
  gb.display.setFont(font5x7);
  switch(gb.menu(menu, MENULENGTH)){
    case -1: //Nothing
      start();
      break;
    case 0: //Play game
      startGame();
      break;
    case 1: //Main menu
      start();
      break;
    case 2: //Display controls
      controls();
      break;
    case 3: //Code input screen
      inputCode();
      break;
    default:
      break;
  }
}

void start(){
  // show the start menu
  gb.titleScreen(("By: ajsb113"), Title);
  Menu();

}
void startGame(){
  cameraPos = 0;
  score = 0;
  lives = 5;
  running = true;
  curLev = 1;
  clearEnts();
  startTimer();
  startPlayer();
  loadLevel(curLev);

}

void inputCode(){
  while(!gb.buttons.pressed(BTN_A)){
    if(gb.update()){
      gb.display.cursorX = 0;
      gb.display.cursorY = 5;
      gb.display.textWrap = true;
      gb.display.println("Press \25 to    enter a code  or \27 to return to menu");
      gb.display.textWrap = false;
    }
  }
  gb.keyboard(code, 12);
  Menu();
}

void controls(){
  while(!gb.buttons.pressed(BTN_A)){
    if(gb.update()){
      gb.display.cursorX = 0;
      gb.display.cursorY = 0;
      gb.display.setFont(font3x5);
      gb.display.textWrap = true;
      gb.display.println("Use \33 & \32 to move.");
      gb.display.cursorY += 1;
      gb.display.println("Press \30 to toggle HUD size.");
      gb.display.cursorY += 1;
      gb.display.println("Press \25 to   jump.");
      gb.display.cursorY += 1;
      gb.display.println("Hold \26 to crouch");
      gb.display.cursorY += 1;
      gb.display.println("Press \27 to return to menu.");
    }
  }
  Menu();
}

void lose(){//temporary
  running = false;
  while(!gb.buttons.pressed(BTN_A)){
    if(gb.update()){
      gb.display.setFont(font5x7);
      gb.display.cursorY = 5;
      gb.display.cursorX = 15;

      gb.display.println("You lose \1");
      gb.display.print("Score:");
      gb.display.println(score);
      gb.display.println("Press \25 to \n continue");
    }
  }
 Menu();
}

void win(){
  running = false;
  while(!gb.buttons.pressed(BTN_A)){
    if(gb.update()){
      gb.display.setFont(font5x7);
      gb.display.cursorY = 5;
      gb.display.cursorX = 20;

      gb.display.println("You win!!\2");
      gb.display.print("Score:");
      gb.display.println(score);
      gb.display.println("Press \25 to \n continue");
    }
  }
 Menu();
}

void startTimer(){
  time_b = 130;
  frames = gb.frameCount;
}

void updateDisplay(){
  if((gb.frameCount - frames)>=20){
    frames = gb.frameCount;
    time_b --;
  }
  if(disp){
    gb.display.fillRect(0,0,LCDWIDTH,7);
    gb.display.setColor(WHITE,BLACK);
    gb.display.setFont(font3x5);
    gb.display.cursorY = 1;
    gb.display.cursorX = 1;
    gb.display.print("\35:");
    gb.display.print((int)time_b);
    gb.display.print("  \44:");
    gb.display.print((int)score);
    gb.display.print("  \03:");
    gb.display.print((int)lives);
    gb.display.setColor(BLACK,WHITE);
  }
  else{
    gb.display.fillRect(0,0,LCDWIDTH,5);
    gb.display.setColor(WHITE,BLACK);
    gb.display.setFont(font3x3);
    gb.display.cursorY = 1;
    gb.display.cursorX = 1;
    gb.display.print("\35:");
    gb.display.print((int)time_b);
    gb.display.print("  \44:");
    gb.display.print((int)score);
    gb.display.print("  \03:");
    gb.display.print((int)lives);
    gb.display.setColor(BLACK,WHITE);
  }
  gb.display.setFont(font3x5);
}

boolean canJump = false;
boolean walking = false;
boolean bounce = false;
const byte *character;

void startPlayer(){
  player.x = 0;
  player.y = 0;
  player.vx = 0;
  player.vy = 0;
  player.h = 4;
  player.invincible = 40;
  player.flip = false;
  player.big = false;
  player.crouch = false;
}


void updatePlayer(){
  walking = false;
  if(time_b == 0){//time_b out
    die();
  }
  if(player.invincible > 0){//Invincibility frames
    player.invincible--;
  }

  if(gb.buttons.pressed(BTN_C)){//Main menu
    Menu();
  }
  if(gb.buttons.pressed(BTN_UP)){//Toggle display
    disp = !disp;
  }

  if(gb.buttons.timeHeld(BTN_B)){//Smart crouching
    if(player.big && !player.crouch){
      player.y += 8;
    }
    player.crouch = true;
  }

  else{
    if(player.big && player.crouch){//Checks if player can stand without colliding.
      player.y -= 8;
      if(playerCollide()){
        player.y += 8;
      }
      else{
        player.crouch = false;
      }
    }
  }



  player.vx *= 0.75;//So player.vx slows
  if(gb.buttons.repeat(BTN_RIGHT, 1)){//Move right
    player.vx += .4;
    player.flip = false;
    walking = true;
  }

  if(gb.buttons.repeat(BTN_LEFT,1)){//Move left
    player.vx -= .4;
    player.flip = true;
    walking = true;
  }

  if(player.big){
    if(player.crouch){
      character = PlayerC;
      player.h = 8;
    }
    else if(walking){//Walking animation
      player.h = 16;
      if(gb.frameCount % 12 >= 0 && gb.frameCount % 12 < 2){character = PlayerT1;}
      else if(gb.frameCount % 12 >= 2 && gb.frameCount % 12 < 4) { character = PlayerT2; }
      else if(gb.frameCount % 12 >= 4 && gb.frameCount % 12 < 6) { character = PlayerT3; }
      else if(gb.frameCount % 12 >= 6 && gb.frameCount % 12 < 8) { character = PlayerT4; }
      else if(gb.frameCount % 12 >= 8 && gb.frameCount % 12 < 10) { character = PlayerT5; }
      else if(gb.frameCount % 12 >= 10 && gb.frameCount % 12 < 12) { character = PlayerT6; }
    }
    else{
      character = PlayerT;
      player.h = 16;
    }
  }

  else{
    if(gb.frameCount % 6 >= 0 && gb.frameCount % 6 < 3 && walking){
      character = PlayerS1;
      player.h = 8;
    }
    else{
      character = PlayerS;
      player.h = 8;
    }
  }

  checkCode(code);

  if(player.vx > 2){
    player.vx = 2;
  }

  player.x += player.vx;
  if(playerCollide()){//Collision on x-axis
    player.x -= player.vx;
    player.vx = 0;
  }

  if(player.vy > 1){//Falling
    canJump = false;
  }
  if(canJump && (gb.buttons.timeHeld(BTN_A) > 0 && gb.buttons.timeHeld(BTN_A) < 5)){//Jump
    player.vy -= 1.3;
    if (gb.buttons.timeHeld(BTN_A) < 2){
      gb.sound.playOK();
    }
  }
  player.vy += 0.4;
  if(player.vy >5){
    player.vy = 2;
  }



  if(gb.buttons.released(BTN_A)){//Prevents player from jumping multiple times midair
    canJump = false;
  }

  player.y += player.vy;
  if(playerCollide()){//collision on y-axis
    if(player.vy > 0){
      canJump = true;
      for(int i = 0; i < player.vy; i++){
        player.y -= 1;
        if(!playerCollide()){
          // We found the last open spot before the _block
          player.vy = 0; // Stop moving
          break; //Quit the loop
        }
      }
    }
    else{
      player.y -= player.vy;
      player.vy /= 2;
    }
  }

  if(player.y > LCDHEIGHT){//fall to death
    die();
  }

  if(player.x + 4 - cameraPos > (int)(LCDWIDTH/2)  && cameraPos < (64*8)-(LCDWIDTH)){//Player is mid screen but screen isn't leaving the end of the level.
    cameraPos = player.x - LCDWIDTH/2 + 4;
  }

  if(player.x + 4 - cameraPos < (int)(LCDWIDTH/2) && cameraPos > 0){//Player is mid screen but screen isn't showing "before" the level
    cameraPos = player.x - LCDWIDTH/2 + 4;
  }
}

void drawPlayer(){
  if(player.invincible % 2 != 1){
    if(!player.flip){
      gb.display.drawBitmap(player.x - cameraPos, player.y, character, NOROT, NOFLIP);
    }
    else{
      gb.display.drawBitmap(player.x - cameraPos, player.y, character, NOROT, FLIPH);
    }
  }
}

void getBig(){
  if(!player.big){
    player.big = true;
    player.crouch = true;
  }
}

void getSmall(){
  if(player.invincible <= 0){
    player.invincible = 40;
    if(player.big){
      if(!player.crouch){
        player.y += 8;
      }
      player.big = false;
    }
    else{
      die();
    }
  }
}

void die(){
  if(lives == 0){
    lose();
  }
  else{
    lives --;
    time_b = 130;
    gb.popup(("You died. \1"), 20);
    clearEnts();
    startPlayer();
    cameraPos = 0;
    loadLevel(curLev);
  }
}

boolean playerCollide(){
  collide = false;
  for(int k = 0; k<numEnt; k++){
    if(gb.collideBitmapBitmap(entities[k].x, entities[k].y, entities[k].bitmap, player.x, player.y, character)){
      if(entities[k].bitmap == Mushroom){
        getBig();
        score += 100;
        removeEnt(k);
      }

      if(entities[k].bitmap == Goomba){
        if(player.vy > 0 && player.y + player.h - 4 < entities[k].y){//Ugly code checking for players feet being above goomba
          removeEnt(k);
          bounce = true;
        }
        else{
          getSmall();
          if(player.invincible <= 0){
            entities[k].vx *= -1;
          }
        }
      }
    }

    if(entities[k].bitmap != PlayerC && player.invincible <= 0){
      collide = gb.collideBitmapBitmap(player.x, player.y, character, entities[k].x, entities[k].y, entities[k].bitmap);
    }
  }

  for(int i = 0; i<6; i++){
    for(int j = 0; j<64; j++){
      _block = NULL;
      switch(curLevel[(i)*64+j]){
        case 'G' :
          _block = Ground;
          break;
        case 'B' :
          _block = Brick;
          break;
        case '?' :
          _block = MysteryBlockC;
          break;
        case 'M' :
          _block = MysteryBlockM;
          break;
        case 'I' ://Invisible
        case 'E' :
          _block = Empty;
          break;
        case 'C' :
          _block = Coin;
          break;
        case 'F' :
          _block = Flag;
          break;
        case 'S' :
          _block = Spikes;
          break;
        default:
          break;
      }

      if(_block != NULL){
        if(gb.collideBitmapBitmap(player.x, player.y, character, j*8, LCDHEIGHT - (8*(6-i)), _block)){
          if(_block == Flag){
            nextLevel();
          }

          if(player.vy < 0 && player.y > LCDHEIGHT - (8*(5-i)) - 1 && (player.x < (j+1)*8 && player.x + 8 > j*8)){//Checks if under _block
            if(_block == Brick && player.big){
              curLevel[i*64+j] = NULL;
            }
            if(_block == MysteryBlockC){
              curLevel[(i-1)*64+j] = 'C';
              curLevel[i*64+j] = 'E';
            }
            if(_block == MysteryBlockM){
              curLevel[i*64+j] = 'E';
              addEnt(j*8, LCDHEIGHT - (8 * (7-i)), Mushroom);
            }
          }

          if(_block == Spikes){
            getSmall();
            collide = true;
          }

          if(_block == Coin){
            score += 100;
            curLevel[i*64+j] = NULL;
            gb.sound.playOK();
            collide = false;
          }

          else{
            collide = true;
          }

        }
      }
    }
  }
  if(bounce){
    player.vy = -4;
    bounce = false;
  }
  return collide;
}



const byte PlayerT[] PROGMEM = {8,16,B01111110,B11111111,B11100011,B11000000,B11001010,B10001010,B00000000,B00000000,B11111111,B11011011,B11011011,B11111111,B01111110,B01100110,B01100110,B01100110,};
const byte PlayerT1[] PROGMEM = {8,16,B01111110,B11111111,B11100011,B11000000,B11001010,B10001010,B00000000,B00000000,B11111111,B11011011,B11011011,B11111111,B01111110,B01100011,B01100011,B01100000,};
const byte PlayerT2[] PROGMEM = {8,16,B01111110,B11111111,B11100011,B11000000,B11001010,B10001010,B00000000,B00000000,B11111111,B11011011,B11011011,B11111111,B01111110,B01100011,B01100011,B01100011,};
const byte PlayerT3[] PROGMEM = {8,16,B01111110,B11111111,B11100011,B11000000,B11001010,B10001010,B00000000,B00000000,B11111111,B11011011,B11011011,B11111111,B01111110,B01100110,B11000110,B11000110,};
const byte PlayerT4[] PROGMEM = {8,16,B01111110,B11111111,B11100011,B11000000,B11001010,B10001010,B00000000,B00000000,B11111111,B11011011,B11011011,B11111111,B01111110,B11000110,B11000110,B00000110,};
const byte PlayerT5[] PROGMEM = {8,16,B01111110,B11111111,B11100011,B11000000,B11001010,B10001010,B00000000,B00000000,B11111111,B11011011,B11011011,B11111111,B01111110,B00110110,B00110110,B00000110,};
const byte PlayerT6[] PROGMEM = {8,16,B01111110,B11111111,B11100011,B11000000,B11001010,B10001010,B00000000,B00000000,B11111111,B11011011,B11011011,B11111111,B01111110,B01100110,B01100110,B01100000,};
const byte PlayerS[] PROGMEM = {8,8,B01111110,B01100001,B01101010,B01000000,B11111111,B11011011,B01111110,B01100110,};
const byte PlayerS1[] PROGMEM = {8,8,B01111110,B01100001,B01101010,B01000000,B11111111,B11011011,B01111110,B00111100,};
const byte PlayerC[] PROGMEM = {8,8,B01111110,B11000011,B00100100,B10100101,B10000001,B11111111,B01111110,B01100110,};
const byte Ground[] PROGMEM = {8,8,B11111111,B10001001,B10001001,B10001111,B11001001,B10110001,B10010001,B11111111,};
const byte Brick[] PROGMEM = {8,8,B11111111,B00010001,B11111111,B01000100,B11111111,B00010001,B11111111,B01000100,};
const byte Spikes[] PROGMEM = {8,8,B00100010,B00100010,B01010101,B01010101,B10001000,B10101010,B10101010,B11111111,};
const byte MysteryBlockC[] PROGMEM = {8,8,B11111111,B10011001,B10100101,B10000101,B10001001,B10000001,B10001001,B11111111,};
const byte MysteryBlockM[] PROGMEM = {8,8,B11111111,B10011001,B10100101,B10000101,B10001001,B10000001,B10001001,B11111111,};
const byte Coin[] PROGMEM = {8,8,B00011000,B00100100,B01010010,B01010010,B01001010,B01001010,B00100100,B00011000,};
const byte Empty[] PROGMEM = {8,8,B11111111,B10000001,B10000001,B10000001,B10000001,B10000001,B10000001,B11111111,};
const byte Flag[] PROGMEM = {8,8,B00111000,B00110110,B00101011,B00110110,B00111000,B00100000,B00100000,B01110000,};
const byte Mushroom[] PROGMEM = {8,8,B00111100,B01011010,B10100101,B11011011,B10000001,B01011010,B01000010,B00111100,};
const byte Goomba[] PROGMEM = {8,8,B00111100,B01000010,B10100101,B10100101,B01111110,B01000010,B10111111,B11100011,};

const byte Title[] PROGMEM = {64,30,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000001,B11000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00001110,B00111000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00010100,B00010100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00100100,B00010010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00101101,B11011010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B01111010,B00101111,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B01000100,B00010001,B00011000,B11000000,B00000000,B00000000,B00000000,B00000000,
B01000100,B00010001,B00011000,B11000000,B00000000,B00000000,B00000000,B00000000,
B10000010,B00100000,B10011000,B11000000,B00000000,B00000010,B00000000,B00000000,
B10000001,B11000000,B10010101,B01000000,B00000000,B00000010,B00000000,B00000000,
B10001111,B11110000,B10010101,B01000110,B00101001,B00001000,B01011000,B11110000,
B11111000,B00011111,B10010101,B01000001,B00110101,B00001010,B01100101,B00001000,
B00100010,B00100010,B00010010,B01000001,B00110101,B00001010,B01100101,B00001000,
B00100010,B00100010,B00010000,B01000111,B00100001,B00001010,B01000101,B00001000,
B00100010,B00100010,B00010000,B01001001,B00100001,B00001010,B01000101,B00001000,
B00011000,B00001100,B00010000,B01001001,B00100001,B00001010,B01000101,B00001000,
B00001000,B00001000,B00010000,B01000111,B10100000,B11111010,B01000100,B11110000,
B00000111,B11110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,
B00000100,B00010000,B01000001,B00000100,B00010000,B01000001,B00000100,B00010000,
B00000100,B00010000,B01000001,B00000100,B00010000,B01000001,B00000100,B00010000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,
B00100000,B10000010,B00001000,B00100000,B10000010,B00001000,B00100000,B10000010,
B00100000,B10000010,B00001000,B00100000,B10000010,B00001000,B00100000,B10000010,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,
B00000100,B00010000,B01000001,B00000100,B00010000,B01000001,B00000100,B00010000,
B00000100,B00010000,B01000001,B00000100,B00010000,B01000001,B00000100,B00010000,
B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,B11111111,
};

/*
SPOILERS AHEAD!!!!! ONLY SCROLL PAST THIS IF YOU WANT THE CODES SPOILED!!!



























*/

void checkCode(char* code){
  if(strstr(code, "\30\30\31\31\33\32\33\32\26\25\27")){
    lives = 113;
  }
  if(strstr(code, "\50\42\55\42\51\57\57\40\174\137\174")){
    character = Brick;
    player.h = 8;
  }
  if(strstr(code, "\141\152\163\142\61\61\63")){
    score += 10;
  }
  if(strstr(code, "\101\40\143\157\144\145")){
    numLevs = 7;
  }
  if(strstr(code, "\134\50\136\137\136\51\57")){
    player.invincible = 2;
  }
}


