/* mbed Microcontroller Library
 *******************************************************************************
 * Copyright (c) 2018, Point Labs, LLC.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of STMicroelectronics nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************
 */

#ifndef GENEVA_PINS_H
#define GENEVA_PINS_H

#ifdef __cplusplus
extern "C" {
#endif

#define TX    PA_9
#define RX    PA_10

#define A7    PA_0
#define A6    PA_4
#define A5    PA_7
#define A4    PA_6
#define A3    PA_5
#define A2    PC_2
#define A1    PC_3
#define A0    PA_3

#define B5    PC_1
#define B4    PC_0
#define B3    PB_1
#define B2    PB_0
#define B1    PC_6
#define B0    PC_8

#define D7    PA_13
#define D6    PA_14
#define D5    PA_15
#define D4    PB_3
#define D3    PB_4
#define D2    PB_5
#define D1    PB_6
#define D0    PB_7

#define C5    PB_8
#define C4    PB_9
#define C3    PC_10
#define C2    PC_11
#define C1    PC_12
#define C0    PD_2


// UARTS
#define S1_TX	PA_9
#define S1_RX	PA_10
#define S1_CTS	PB_4
#define S1_RTS	PB_3	

#define S4_TX	PC_10_ALT0
#define S4_RX	PC_11_ALT0
#define S4_CTS	PB_7
#define S4_RTS	PA_15

#define S5_TX	PC_12
#define S5_RX	PD_2

#define LP_TX	PC_1
#define LP_RX	PC_0

// LEDs
#define	LED_RED		PB_15
#define	LED_GREEN	PC_7
#define LED_BLUE	PB_12

// SPI
#define SPI_MOSI    PA_7
#define SPI_MISO    PA_6
#define SPI_SCK     PA_5
#define SPI_CS      PA_2

// User Button
#define USER_BUTTON PA_1

// Cellular interface
//#define MDM_PIN_POLARITY    (1)
//#define MODEM_ON_BOARD		(1)
//#define MBED_CONF_UBLOX_CELL_BAUD_RATE (115200)

// Modem pins
//#define MDMTXD          PC_4  // Transmit Data
//#define MDMRXD          PC_5  // Receive Data
//#define MDMCTS          PB_13 // Clear to Send
//#define MDMDSR          NC    // Data Set Ready
//#define MDMDTR          PB_15 // Data Terminal Ready
//#define MDMRI           NC    // Ring Indicator
//#define MDMRTS          PB_14 // Request to Send
//#define MDMPWRON        PB_2
//#define MDMRST          PA_8
//#define MDMVCC			PB_12

// Charger
#define nCHG_TMR_EN	PB_10
#define CHG_SEL		PB_11

// Some nice functions
#define rLED 4
#define gLED 2
#define bLED 1

#define BL_MAGIC_NUMBER         (0xA87B1234)
#define BL_MAGIC_LOCATION       ((unsigned long *) 0x20001000)

#ifdef __cplusplus
}
#endif

#endif

