//
//  SkyShepherd Firmware
//
//  Copyright © 2018 GPSip, Inc. All rights reserved.
//

#pragma once
#ifndef BOARD_H
#define BOARD_H

// ---- Includes ---------------------------------------------------------------
//#include "PinNames.h"
#include "Geneva.h"
// ---- Defines ----------------------------------------------------------------

#define DEBUG_UART_TX   STDIO_UART_TX   // defined by mbed_app.json
#define DEBUG_UART_RX   STDIO_UART_RX   // defined by mbed_app.json


#define nvm_mosi	A5			//  SPI Data Out
#define nvm_miso 	A4			//  SPI Data IN
#define nvm_sclk 	A3			//  SPI Clock output
#define nvm_cs 		A2			//  CS output

#define UBLOX_M8N_GPS
#define GPS_EN		A1			//  GPS power enable. 1 = GPS on, 0 = GPS off
#define GPS_tx		TX			//  gps tx
#define GPS_rx		RX			//	gps rx

#define BLE_DTR		B5			//  Module pin function controlled by AT commands, see reference
#define BLE_DSR 	B4			//  led by AT commands Module pin function contro, see reference
#define BLE_TX		S4_TX			//  bluetooth TX
#define BLE_RX		S4_RX			//  bluetooth RX
#define BLE_RTS		C1			//  HW flow control. Not required to support
#define BLE_CTS		C0			//  HW flow control. Not required to support
#define nRESET		D2			//  Bluetooth Reset: Low = Reset, High = Normal mode

#define TONE_PWM	B2			//  PWM output for the alert signal. High = buzzer on
#define STIM_PWM	B1			//  PWM output for the STIM signal.  Active High = PWM on
#define VIBE_PWM	B1			//  PWM output for the vibrator motor. High = motor on.


#endif // BOARD_H

