#include "mbed.h"
#include "Geneva.h"
#include "RH_RF95.h"
#include "SPI.h"

/******************** Comms *********************/
#include "USBSerial.h"
USBSerial USB; // This allows us to have a non-blocking USB serial thingy
FileHandle* mbed::mbed_override_console(int)
{   
    return &USB;
}
DigitalIn userBtn(USER_BUTTON);

// Change to match RX's freq!
#define RF95_FREQ 915.0

// Singleton instance of the radio driver
RH_RF95 radio(RADIO_CS, RADIO_INT);
DigitalInOut radio_cs(RADIO_CS, PIN_OUTPUT, OpenDrainPullUp, 1);
DigitalOut radio_rst(RADIO_RST, 1);
DigitalOut greenLed(LED_GREEN, 1);
DigitalOut blueLed(LED_BLUE, 1);
DigitalOut redLed(LED_RED, 1);

#define wait_ms(X) (wait_us(X*1000))

void doLED(uint8_t mask){
    redLed = ((mask & 4)>>2)^1;
    greenLed = ((mask & 2)>>1)^1;
    blueLed = ((mask & 1))^1; 
}

static void press_power_button(int time_ms)
{
}

bool initModem(void)
{
    bool success = true;
    printf("Starting LoRa radio...\n");
    radio_rst = 0;
    delay(10);
    radio_rst = 1;
    delay(10);
    if(!radio.init()){
        printf("init failed, ");
        success = false;
    }
    
      // Defaults after init are 434.0MHz, modulation GFSK_Rb250Fd250, +13dbM
    if (success && !radio.setFrequency(RF95_FREQ)) {
        printf("setFrequency failed, ");
        success = false;
    }
        
    // The default transmitter power is 13dBm, using PA_BOOST.
    // If you are using RFM95/96/97/98 modules which uses the PA_BOOST transmitter pin, then 
    // you can set transmitter powers from 5 to 23 dBm:       
    if(success){
        radio.setTxPower(18);
    }
    else
        printf("LoRa driver not functional\n");
        
    return success;
}     

void pdwnModem(void)
{
    radio_rst = 0;
}

static Thread radioThread( osPriorityNormal, OS_STACK_SIZE / 2, NULL, "radio_thread" );
void writeRadio(){
    uint8_t inbuf[RH_RF95_MAX_MESSAGE_LEN];
    uint8_t size = 0;
    uint8_t len = 0;
    while(1)
    {
        // store up chars in buffer
        if(USB.readable()){
            size = USB.available();
            if(USB.receive(inbuf+len,size)){
                USB.send(inbuf+len, size);
                len += size;
            }
        }
            
        // Send data if newline is found
        if(inbuf[len - 1] == '\n'){
            len -= 2; // strip off the newline stuff
//            inbuf[len++] = 0; // make sure we terminate the string
            radio.send(inbuf,len);
            radio.waitPacketSent();
            len = 0;    
        }
    }
}

static Thread pcThread( osPriorityNormal, OS_STACK_SIZE / 2, NULL, "pc_thread" );
void writePC(){
    uint8_t rxBuf[RH_RF95_MAX_MESSAGE_LEN];
    uint8_t size;
    printf("starting PC thread\n");
    while(1)
    {
        if(radio.available()){
            size = sizeof(rxBuf);
            if(radio.recv(rxBuf,&size))
                rxBuf[size] = 0; // make sure to null terminate the string
                printf("Got: %s", rxBuf);
                if(rxBuf[size-1]!= '\n')
                    USB.putc('\n'); // put a new line in just in case
                printf("RSSI: %d\n",radio.lastRssi());
        }
    }
}
void trigger()
{
    blueLed = !blueLed;
}

void setup(void)
{
    userBtn.mode(PullUp);
    USB.connect();
    wait_ms(1000);
    printf("Lora Modem\n------------\n");
    printf("* mbed-os: %d.%d.%d\n\n", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);    
    
    wait_ms(10);
    initModem();
    radioThread.start(writeRadio);
    pcThread.start(writePC);
}

int main(void)
{
    setup();

    while(1){
        ThisThread::sleep_for(100);
    }
        
}


