# Getting started with the Geneva platform example

This guide reviews the steps required to get Blinky working on an mbed OS platform.

Please install [mbed CLI](https://github.com/ARMmbed/mbed-cli#installing-mbed-cli).

## Import the example application

From the command-line, import the example:

```
mbed import mbed-os-example-blinky
cd mbed-os-example-blinky
```

### Now compile

Invoke `mbed compile`, and specify the name of your platform and your favorite toolchain (`GCC_ARM`, `ARM`, `IAR`). For example, for the ARM Compiler 5:

```
mbed compile -m Geneva_R210 -t ARM
```

Your PC may take a few minutes to compile your code. 
```

### Program your board

1. Connect your Geneva module to the computer over USB.
2. Use the Geneva loader to load teh new binary to the module

The LED on your module turns on and off.
You should be able to open a terminal program and be able to talk to the modem.

## Troubleshooting

If you have problems, you can review the [documentation](https://os.mbed.com/docs/latest/tutorials/debugging.html) for suggestions on what could be wrong and how to fix it.
