// RHHardwareSPI.h
// Author: Mike McCauley (mikem@airspayce.com)
// Copyright (C) 2011 Mike McCauley
// Contributed by Joanna Rutkowska
// $Id: RHHardwareSPI.cpp,v 1.12 2015/07/01 00:46:05 mikem Exp $

#include <RHHardwareSPI.h>

// Declare a single default instance of the hardware SPI interface class
RHHardwareSPI hardware_spi;


// grab config from mbed_app.json
SPI _SPI(RADIO_MOSI, RADIO_MISO, RADIO_SCLK);

#define REVERSE_BITS(byte) (((reverse_lookup[(byte & 0x0F)]) << 4) + reverse_lookup[((byte & 0xF0) >> 4)])
    
static const uint8_t reverse_lookup[] = { 0, 8,  4, 12, 2, 10, 6, 14,1, 9, 5, 13,3, 11, 7, 15 };


// Arduino Due has default SPI pins on central SPI headers, and not on 10, 11, 12, 13
// as per otherArduinos
// http://21stdigitalhome.blogspot.com.au/2013/02/arduino-due-hardware-SPI.html
#if defined (__arm__) && !defined(CORE_TEENSY)
 // Arduino Due in 1.5.5 has no definitions for SPI dividers
 // SPI clock divider is based on MCK of 84MHz  
 #define SPI_CLOCK_DIV16 (VARIANT_MCK/84000000) // 1MHz
 #define SPI_CLOCK_DIV8  (VARIANT_MCK/42000000) // 2MHz
 #define SPI_CLOCK_DIV4  (VARIANT_MCK/21000000) // 4MHz
 #define SPI_CLOCK_DIV2  (VARIANT_MCK/10500000) // 8MHz
 #define SPI_CLOCK_DIV1  (VARIANT_MCK/5250000)  // 16MHz

RHHardwareSPI::RHHardwareSPI(Frequency frequency, BitOrder bitOrder, DataMode dataMode)
    :
    RHGenericSPI(frequency, bitOrder, dataMode)
{
}

uint8_t RHHardwareSPI::transfer(uint8_t data) 
{
    if (_bitOrder == BitOrderLSBFirst)
    	data = REVERSE_BITS(data);
	
	return _SPI.write(data);
}

void RHHardwareSPI::attachInterrupt() 
{
// figure out how to do an interrupt thingy here
}

void RHHardwareSPI::detachInterrupt() 
{
// figure out how to do an interrupt thingy here too
}
    
void RHHardwareSPI::begin() 
{

	uint8_t dataMode;
	if (_dataMode == DataMode0)
		dataMode = 0;
	else if (_dataMode == DataMode1)
		dataMode = 1;
	else if (_dataMode == DataMode2)
		dataMode = 2;
	else if (_dataMode == DataMode3)
		dataMode = 3;
//	printf("mode %d\n", dataMode);
	_SPI.format(8, dataMode);
	
	int frequency;
    switch (_frequency)
    {
		case Frequency1MHz:
		default:
		    frequency = 1000000;
		    break;
	
		case Frequency2MHz:
		    frequency = 2000000;
		    break;
	
		case Frequency4MHz:
		    frequency = 4000000;
		    break;
	
		case Frequency8MHz:
		    frequency = 8000000;
		    break;
	
		case Frequency16MHz:
		    frequency = 16000000;
		    break;
    }
//    printf("@%dHz\n",frequency);
	_SPI.frequency(frequency);

}

void RHHardwareSPI::end() 
{
}

#endif

