/* mbed Microcontroller Library
 * Copyright (c) 20 Point Labs, LLC.
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "ANNA-B112.h"
#include "platform/mbed_thread.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS    500


DigitalOut led(LED_B);
UARTSerial radio(TX_PIN, RX_PIN, 115200);

static Thread echoThread( osPriorityNormal, OS_STACK_SIZE / 2, NULL, "echo_thread" );
void echoTask()
{
    while(true){
        uint8_t inbuf[64];
        int size;
        if(radio.readable()){
            size = radio.read(inbuf,sizeof(inbuf));  
            radio.write(inbuf,size);
        }
    }
}

static Thread blinkThread( osPriorityNormal, OS_STACK_SIZE / 2, NULL, "pc_thread" );
void blinkTask()
{
    while (true) {
        led = !led;
        thread_sleep_for(BLINKING_RATE_MS);
    }  
}

int main()
{
    // Initialise the digital pin state
    led = 1;
    
    // Start the threads
    echoThread.start(echoTask);
    blinkThread.start(blinkTask);

    while (true) {
        thread_sleep_for(1000); // Just get out of the way
    }
}
