/* ================================================================================

     Project      :   ADMW1001_REGISTERS
     File         :   ADMW1001_REGISTERS_typedefs.h
     Description  :   C Register Structures

     Date         :   Jun 19, 2019

     Copyright (c) 2019 Analog Devices, Inc.  All Rights Reserved.
     This software is proprietary and confidential to Analog Devices, Inc. and
     its licensors.

     This file was auto-generated. Do not make local changes to this file.

   ================================================================================ */

#ifndef _ADMW1001_REGISTERS_TYPEDEFS_H
#define _ADMW1001_REGISTERS_TYPEDEFS_H

/* pickup integer types */
#if defined(_LANGUAGE_C) || (defined(__GNUC__) && !defined(__ASSEMBLER__))
#include <stdint.h>
#endif /* _LANGUAGE_C */

#if defined ( __CC_ARM   )
#pragma push
#pragma anon_unions
#endif

/** @defgroup Interface_Config_A Interface Configuration A (Interface_Config_A) Register
 *  Interface Configuration A (Interface_Config_A) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_SPI_Interface_Config_A_Addr_Ascension
 *! \brief  Determines Sequential Addressing Behavior (Addr_Ascension) Enumerations
 *  ========================================================================= */
typedef enum
{
  SPI_INTERFACE_CONFIG_A_DESCEND = 0,  /**< Address accessed is decremented by one for each data byte when streaming */
  SPI_INTERFACE_CONFIG_A_ASCEND  = 1   /**< Address accessed is incremented by one for each data byte when streaming */
} ADMW_SPI_Interface_Config_A_Addr_Ascension;


/* ==========================================================================
 *! \struct ADMW_SPI_Interface_Config_A_Struct
 *! \brief  Interface Configuration A Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Interface_Config_A_t {
  union {
    struct {
      uint8_t SW_ResetX  :  1;  /**< Second  of Two of SW_RESET Bits. */
      uint8_t reserved1  :  3;
      uint8_t SDO_Enable :  1;  /**< SDO Pin Enable */
      uint8_t Addr_Ascension :  1;  /**< Determines Sequential Addressing Behavior */
      uint8_t reserved6      :  1;
      uint8_t SW_Reset       :  1;  /**< First of Two of SW_RESET Bits. */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Interface_Config_A_t;

/*@}*/

/** @defgroup Interface_Config_B Interface Configuration B (Interface_Config_B) Register
 *  Interface Configuration B (Interface_Config_B) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_SPI_Interface_Config_B_Single_Inst
 *! \brief  Select Streaming or Single Instruction Mode (Single_Inst) Enumerations
 *  ========================================================================= */
typedef enum
{
  SPI_INTERFACE_CONFIG_B_STREAMING_MODE          = 0,  /**< Streaming mode is enabled          */
  SPI_INTERFACE_CONFIG_B_SINGLE_INSTRUCTION_MODE = 1   /**< Single Instruction mode is enabled */
} ADMW_SPI_Interface_Config_B_Single_Inst;


/* ==========================================================================
 *! \struct ADMW_SPI_Interface_Config_B_Struct
 *! \brief  Interface Configuration B Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Interface_Config_B_t {
  union {
    struct {
      uint8_t reserved0   :  7;
      uint8_t Single_Inst :  1;  /**< Select Streaming or Single Instruction Mode */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Interface_Config_B_t;

/*@}*/

/** @defgroup Device_Config Device Configuration (Device_Config) Register
 *  Device Configuration (Device_Config) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_SPI_Device_Config_Operating_Modes
 *! \brief  Power Modes (Operating_Modes) Enumerations
 *  ========================================================================= */
typedef enum
{
  SPI_DEVICE_CONFIG_NORMAL = 0,  /**< Normal Operating Mode */
  SPI_DEVICE_CONFIG_SLEEP  = 3   /**< Low Power Mode        */
} ADMW_SPI_Device_Config_Operating_Modes;


/* ==========================================================================
 *! \struct ADMW_SPI_Device_Config_Struct
 *! \brief  Device Configuration Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Device_Config_t {
  union {
    struct {
      uint8_t Operating_Modes :  2;  /**< Power Modes */
      uint8_t reserved2       :  6;
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Device_Config_t;

/*@}*/

/** @defgroup Chip_Type Chip Type (Chip_Type) Register
 *  Chip Type (Chip_Type) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_SPI_Chip_Type_Struct
 *! \brief  Chip Type Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Chip_Type_t {
  union {
    struct {
      uint8_t Chip_Type  :  4;  /**< Precision ADC */
      uint8_t reserved4  :  4;
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Chip_Type_t;

/*@}*/

/** @defgroup Product_ID_L Product ID Low (Product_ID_L) Register
 *  Product ID Low (Product_ID_L) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_SPI_Product_ID_L_Struct
 *! \brief  Product ID Low Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Product_ID_L_t {
  union {
    struct {
      uint8_t Product_ID :  8;  /**< Product_ID[7:0] This is Device Chip Type/Family */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Product_ID_L_t;

/*@}*/

/** @defgroup Product_ID_H Product ID High (Product_ID_H) Register
 *  Product ID High (Product_ID_H) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_SPI_Product_ID_H_Struct
 *! \brief  Product ID High Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Product_ID_H_t {
  union {
    struct {
      uint8_t Product_ID :  8;  /**< Product_ID[15:8] This is Device Chip Type/Family */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Product_ID_H_t;

/*@}*/

/** @defgroup Chip_Grade Chip Grade (Chip_Grade) Register
 *  Chip Grade (Chip_Grade) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_SPI_Chip_Grade_Struct
 *! \brief  Chip Grade Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Chip_Grade_t {
  union {
    struct {
      uint8_t Device_Revision :  4;  /**< This is the Device Hardware Revision */
      uint8_t Grade           :  4;  /**< This is the Device Performance Grade */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Chip_Grade_t;

/*@}*/

/** @defgroup Scratch_Pad Scratch Pad (Scratch_Pad) Register
 *  Scratch Pad (Scratch_Pad) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_SPI_Scratch_Pad_Struct
 *! \brief  Scratch Pad Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Scratch_Pad_t {
  union {
    struct {
      uint8_t Scratch_Value :  8;  /**< Software Scratchpad */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Scratch_Pad_t;

/*@}*/

/** @defgroup SPI_Revision SPI Revision (SPI_Revision) Register
 *  SPI Revision (SPI_Revision) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_SPI_SPI_Revision_Version
 *! \brief  SPI Version (Version) Enumerations
 *  ========================================================================= */
typedef enum
{
  SPI_SPI_REVISION_REV1_0 = 2   /**< Revision 1.0 */
} ADMW_SPI_SPI_Revision_Version;


/*  =========================================================================
 *! \enum   ADMW_SPI_SPI_Revision_SPI_Type
 *! \brief  Always Reads as 0x2 (SPI_Type) Enumerations
 *  ========================================================================= */
typedef enum
{
  SPI_SPI_REVISION_ADI_SPI = 0,  /**<  */
  SPI_SPI_REVISION_LPT_SPI = 2   /**<  */
} ADMW_SPI_SPI_Revision_SPI_Type;


/* ==========================================================================
 *! \struct ADMW_SPI_SPI_Revision_Struct
 *! \brief  SPI Revision Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_SPI_Revision_t {
  union {
    struct {
      uint8_t Version    :  6;  /**< SPI Version */
      uint8_t SPI_Type   :  2;  /**< Always Reads as 0x2 */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_SPI_Revision_t;

/*@}*/

/** @defgroup Vendor_L Vendor ID Low (Vendor_L) Register
 *  Vendor ID Low (Vendor_L) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_SPI_Vendor_L_Struct
 *! \brief  Vendor ID Low Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Vendor_L_t {
  union {
    struct {
      uint8_t VID        :  8;  /**< VID[7:0] Analog Devices Vendor ID */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Vendor_L_t;

/*@}*/

/** @defgroup Vendor_H Vendor ID High (Vendor_H) Register
 *  Vendor ID High (Vendor_H) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_SPI_Vendor_H_Struct
 *! \brief  Vendor ID High Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Vendor_H_t {
  union {
    struct {
      uint8_t VID        :  8;  /**< VID[15:8] Analog Devices Vendor ID */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Vendor_H_t;

/*@}*/

/** @defgroup Stream_Mode Stream Mode (Stream_Mode) Register
 *  Stream Mode (Stream_Mode) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_SPI_Stream_Mode_Struct
 *! \brief  Stream Mode Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Stream_Mode_t {
  union {
    struct {
      uint8_t Loop_Count :  8;  /**< Sets the Data Byte Count Before Looping to Start Address */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Stream_Mode_t;

/*@}*/

/** @defgroup Transfer_Config Transfer Config (Transfer_Config) Register
 *  Transfer Config (Transfer_Config) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_SPI_Transfer_Config_Stream_Mode
 *! \brief  When Streaming, Controls Master-Slave Transfer (Stream_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  SPI_TRANSFER_CONFIG_UPDATE_ON_WRITE        = 0,  /**< Transfers after each byte/mulit-byte register */
  SPI_TRANSFER_CONFIG_UPDATE_ON_ADDRESS_LOOP = 1   /**< Transfers when address loops                  */
} ADMW_SPI_Transfer_Config_Stream_Mode;


/* ==========================================================================
 *! \struct ADMW_SPI_Transfer_Config_Struct
 *! \brief  Transfer Config Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Transfer_Config_t {
  union {
    struct {
      uint8_t reserved0   :  1;
      uint8_t Stream_Mode :  1;  /**< When Streaming, Controls Master-Slave Transfer */
      uint8_t reserved2   :  6;
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Transfer_Config_t;

/*@}*/

/** @defgroup Interface_Config_C Interface Configuration C (Interface_Config_C) Register
 *  Interface Configuration C (Interface_Config_C) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_SPI_Interface_Config_C_Strict_Register_Access
 *! \brief  Multi-byte Registers Must Be Read/Written in Full (Strict_Register_Access) Enumerations
 *  ========================================================================= */
typedef enum
{
  SPI_INTERFACE_CONFIG_C_NORMAL_ACCESS = 0,  /**< Normal mode, no access restrictions                              */
  SPI_INTERFACE_CONFIG_C_STRICT_ACCESS = 1   /**< Strict mode, multi-byte registers require all bytes read/written */
} ADMW_SPI_Interface_Config_C_Strict_Register_Access;


/*  =========================================================================
 *! \enum   ADMW_SPI_Interface_Config_C_CRC_Enable
 *! \brief  CRC Enable (CRC_Enable) Enumerations
 *  ========================================================================= */
typedef enum
{
  SPI_INTERFACE_CONFIG_C_DISABLED = 0,  /**< CRC Disabled */
  SPI_INTERFACE_CONFIG_C_ENABLED  = 1   /**< CRC Enabled  */
} ADMW_SPI_Interface_Config_C_CRC_Enable;


/* ==========================================================================
 *! \struct ADMW_SPI_Interface_Config_C_Struct
 *! \brief  Interface Configuration C Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Interface_Config_C_t {
  union {
    struct {
      uint8_t CRC_EnableB :  2;  /**< Inverted CRC Enable */
      uint8_t reserved2   :  2;
      uint8_t Send_Status :  1;  /**< Enables Sending of Status in 4-wire Mode */
      uint8_t Strict_Register_Access :  1;  /**< Multi-byte Registers Must Be Read/Written in Full */
      uint8_t CRC_Enable             :  2;  /**< CRC Enable */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Interface_Config_C_t;

/*@}*/

/** @defgroup Interface_Status_A Interface Status A (Interface_Status_A) Register
 *  Interface Status A (Interface_Status_A) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_SPI_Interface_Status_A_Struct
 *! \brief  Interface Status A Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_SPI_Interface_Status_A_t {
  union {
    struct {
      uint8_t Address_Invalid_Error :  1;  /**< Attempt to Read/Write Non-existent Register Address */
      uint8_t Register_Partial_Access_Error :  1;  /**< Set When Fewer Than Expected Number of Bytes Read/Written */
      uint8_t Wr_To_Rd_Only_Reg_Error       :  1;  /**< Write to Read-Only Register Attempted */
      uint8_t CRC_Error                     :  1;  /**< Invalid/No CRC Received */
      uint8_t Clock_Count_Error             :  1;  /**< Incorrect Number of Clocks Detected in a Transaction */
      uint8_t reserved5                     :  2;
      uint8_t Not_Ready_Error               :  1;  /**< Device Not Ready for Transaction */
    };
    uint8_t VALUE8;
  };
} ADMW_SPI_Interface_Status_A_t;

/*@}*/

/** @defgroup Command Special Command (Command) Register
 *  Special Command (Command) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Command_Special_Command
 *! \brief  Special Command (Special_Command) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_COMMAND_NOP              = 0,   /**< No Command                                       */
  CORE_COMMAND_CONVERT          = 1,   /**< Start ADC Conversions                            */
  CORE_COMMAND_CONVERT_WITH_RAW = 2,   /**< Start Conversions with Added RAW ADC Data        */
  CORE_COMMAND_LATCH_CONFIG     = 7,   /**< Latch Configuration.                             */
  CORE_COMMAND_LOAD_LUT         = 8,   /**< Load LUT from FLASH                              */
  CORE_COMMAND_SAVE_LUT         = 9,   /**< Save LUT to FLASH                                */
  CORE_COMMAND_POWER_DOWN       = 20,  /**< Enter Low Power State                            */
  CORE_COMMAND_LOAD_CONFIG_1    = 24,  /**< Load Registers with Configuration#1 from FLASH   */
  CORE_COMMAND_SAVE_CONFIG_1    = 25   /**< Store Current Registers to FLASH Configuration#1 */
} ADMW_CORE_Command_Special_Command;


/* ==========================================================================
 *! \struct ADMW_CORE_Command_Struct
 *! \brief  Special Command Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Command_t {
  union {
    struct {
      uint8_t Special_Command :  8;  /**< Special Command */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Command_t;

/*@}*/

/** @defgroup Mode Operating Mode and DRDY Control (Mode) Register
 *  Operating Mode and DRDY Control (Mode) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Mode_Conversion_Mode
 *! \brief  Conversion Mode (Conversion_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_MODE_SINGLECYCLE = 0,  /**< Single Cycle          */
  CORE_MODE_CONTINUOUS  = 2   /**< Continuous Conversion */
} ADMW_CORE_Mode_Conversion_Mode;


/*  =========================================================================
 *! \enum   ADMW_CORE_Mode_Drdy_Mode
 *! \brief  Indicates Behavior of DRDY with Respect to FIFO State (Drdy_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_MODE_DRDY_PER_CONVERSION = 0,  /**< Data Ready Per Conversion */
  CORE_MODE_DRDY_PER_CYCLE      = 1   /**< Data Ready Per Cycle      */
} ADMW_CORE_Mode_Drdy_Mode;


/* ==========================================================================
 *! \struct ADMW_CORE_Mode_Struct
 *! \brief  Operating Mode and DRDY Control Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Mode_t {
  union {
    struct {
      uint8_t Conversion_Mode :  2;  /**< Conversion Mode */
      uint8_t Drdy_Mode       :  2;  /**< Indicates Behavior of DRDY with Respect to FIFO State */
      uint8_t reserved4       :  4;
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Mode_t;

/*@}*/

/** @defgroup Power_Config General Configuration (Power_Config) Register
 *  General Configuration (Power_Config) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Power_Config_Power_Mode_MCU
 *! \brief  MCU Power Mode (Power_Mode_MCU) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_POWER_CONFIG_ACTIVE_MODE = 0,  /**< Part is fully powered up and either cycling through a sequence or awaiting a configuration                                               */
  CORE_POWER_CONFIG_HIBERNATION = 1   /**< module has entede hibernation mode. All analog circuitry is disabled. All peripherals disabled apart from the Wake-up pin functionality. */
} ADMW_CORE_Power_Config_Power_Mode_MCU;


/* ==========================================================================
 *! \struct ADMW_CORE_Power_Config_Struct
 *! \brief  General Configuration Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Power_Config_t {
  union {
    struct {
      uint8_t Power_Mode_MCU :  1;  /**< MCU Power Mode */
      uint8_t reserved1      :  7;
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Power_Config_t;

/*@}*/

/** @defgroup Cycle_Control Measurement Cycle (Cycle_Control) Register
 *  Measurement Cycle (Cycle_Control) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Cycle_Control_Cycle_Type
 *! \brief  Type of Measurement Cycle (Cycle_Type) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_CYCLE_CONTROL_SWITCH = 0,  /**< Switch Channels After Every Conversion                        */
  CORE_CYCLE_CONTROL_FULL   = 1   /**< Perform Full Number Of Conversions On A Channel Consecutively */
} ADMW_CORE_Cycle_Control_Cycle_Type;


/*  =========================================================================
 *! \enum   ADMW_CORE_Cycle_Control_Vbias
 *! \brief  Voltage Bias Global Enable (Vbias) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_CYCLE_CONTROL_VBIAS_DISABLE = 0,  /**< Vbias Disabled                                  */
  CORE_CYCLE_CONTROL_VBIAS_ENABLE  = 1   /**< Enable Vbias Output For the Duration of a Cycle */
} ADMW_CORE_Cycle_Control_Vbias;


/*  =========================================================================
 *! \enum   ADMW_CORE_Cycle_Control_Cycle_Time_Units
 *! \brief  Units for Cycle Time (Cycle_Time_Units) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_CYCLE_CONTROL_MILLISECONDS = 0,  /**< Milli-Seconds */
  CORE_CYCLE_CONTROL_SECONDS      = 1   /**< Seconds       */
} ADMW_CORE_Cycle_Control_Cycle_Time_Units;


/* ==========================================================================
 *! \struct ADMW_CORE_Cycle_Control_Struct
 *! \brief  Measurement Cycle Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Cycle_Control_t {
  union {
    struct {
      uint16_t Cycle_Time : 12;  /**< Duration of a Full Measurement Cycle */
      uint16_t Cycle_Type :  1;  /**< Type of Measurement Cycle */
      uint16_t Vbias      :  1;  /**< Voltage Bias Global Enable */
      uint16_t Cycle_Time_Units :  2;  /**< Units for Cycle Time */
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Cycle_Control_t;

/*@}*/

/** @defgroup Status General Status (Status) Register
 *  General Status (Status) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Status_Struct
 *! \brief  General Status Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Status_t {
  union {
    struct {
      uint8_t reserved0    :  1;
      uint8_t Alert_Active :  1;  /**< Indicates One or More Sensors Alerts are Active */
      uint8_t Error        :  1;  /**< Indicates an Error */
      uint8_t Drdy         :  1;  /**< Indicates a New Sensor Result is Available to Be Read */
      uint8_t Cmd_Running  :  1;  /**< Indicates a Special Command is Active */
      uint8_t FIFO_Error   :  1;  /**< Indicates Error with FIFO */
      uint8_t reserved6    :  2;
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Status_t;

/*@}*/

/** @defgroup Diagnostics_Status Diagnostics Status (Diagnostics_Status) Register
 *  Diagnostics Status (Diagnostics_Status) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Diagnostics_Status_Struct
 *! \brief  Diagnostics Status Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Diagnostics_Status_t {
  union {
    struct {
      uint16_t Diag_Checksum_Error :  1;  /**< Indicates Error on Internal Checksum Calculations */
      uint16_t reserved1           :  7;
      uint16_t Diag_Ainm_UV_Error  :  1;  /**< Indicates Under-Voltage Error on Negative Analog Input */
      uint16_t Diag_Ainm_OV_Error  :  1;  /**< Indicates Over-Voltage Error on Negative Analog Input */
      uint16_t Diag_Ainp_UV_Error  :  1;  /**< Indicates Under-Voltage Error on Positive Analog Input */
      uint16_t Diag_Ainp_OV_Error  :  1;  /**< Indicates Over-Voltage Error on Positive Analog Input */
      uint16_t Diag_Conversion_Error :  1;  /**< Indicates Error During Internal ADC Conversions */
      uint16_t Diag_Calibration_Error :  1;  /**< Indicates Error During Internal Device Calibrations */
      uint16_t reserved14             :  2;
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Diagnostics_Status_t;

/*@}*/

/** @defgroup Channel_Alert_Status Alert Status Summary (Channel_Alert_Status) Register
 *  Alert Status Summary (Channel_Alert_Status) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Channel_Alert_Status_Struct
 *! \brief  Alert Status Summary Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Channel_Alert_Status_t {
  union {
    struct {
      uint16_t Alert_Ch0  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch1  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch2  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch3  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch4  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch5  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch6  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch7  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch8  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch9  :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch10 :  1;  /**< Indicates Channel Alert is Active */
      uint16_t Alert_Ch11 :  1;  /**< Indicates Channel Alert is Active */
      uint16_t reserved12 :  4;
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Channel_Alert_Status_t;

/*@}*/

/** @defgroup Alert_Status_2 Additional Alert Status Information (Alert_Status_2) Register
 *  Additional Alert Status Information (Alert_Status_2) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Alert_Status_2_Struct
 *! \brief  Additional Alert Status Information Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Alert_Status_2_t {
  union {
    struct {
      uint16_t reserved0  :  1;
      uint16_t LUT_Error  :  1;  /**< Indicates Error with One or More Look-Up-Tables */
      uint16_t Configuration_Error :  1;  /**< Indicates Error with Programmed Configuration */
      uint16_t reserved3           : 13;
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Alert_Status_2_t;

/*@}*/

/** @defgroup Alert_Detail_Ch Detailed Error Information (Alert_Detail_Ch) Register
 *  Detailed Error Information (Alert_Detail_Ch) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Alert_Detail_Ch_Struct
 *! \brief  Detailed Error Information Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Alert_Detail_Ch_t {
  union {
    struct {
      uint16_t Time_Out   :  1;  /**< Indicates Time-Out Error from Digital Sensor */
      uint16_t Under_Range :  1;  /**< Indicates Channel Under-Range */
      uint16_t Over_Range  :  1;  /**< Indicates Channel Over-Range */
      uint16_t Low_Limit   :  1;  /**< Indicates Sensor Result is Less Than Low Limit */
      uint16_t High_Limit  :  1;  /**< Indicates Sensor Result is Greater Than High Limit */
      uint16_t Sensor_Open :  1;  /**< Indicates Sensor Input is Open Circuit */
      uint16_t Ref_Detect  :  1;  /**< Indicates Whether ADC Reference is Valid */
      uint16_t Calibration_Invalid :  1;  /**< Indicates Problem During Calibration of Channel */
      uint16_t Config_Err          :  1;  /**< Indicates Configuration Error on Channel */
      uint16_t LUT_Error_Ch        :  1;  /**< Indicates Error with Channel Look-Up-Table */
      uint16_t Under_Voltage       :  1;  /**< Indicates Channel Under-Voltage */
      uint16_t Over_Voltage        :  1;  /**< Indicates Channel Over-Voltage */
      uint16_t Correction_UnderRange :  1;  /**< Indicates Result Less Than LUT/Equation Range */
      uint16_t Correction_OverRange  :  1;  /**< Indicates Result Larger Than LUT/Equation Range */
      uint16_t Sensor_Not_Ready      :  1;  /**< Indicates Digital Sensor Not Ready When Read */
      uint16_t Comp_Not_Ready        :  1;  /**< Indicates Compensation Channel Not Ready When Required */
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Alert_Detail_Ch_t;

/*@}*/

/** @defgroup Error_Code Code Indicating Source of Error (Error_Code) Register
 *  Code Indicating Source of Error (Error_Code) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Error_Code_Struct
 *! \brief  Code Indicating Source of Error Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Error_Code_t {
  union {
    struct {
      uint16_t Error_Code : 16;  /**< Code Indicating Type of Error */
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Error_Code_t;

/*@}*/

/** @defgroup Alert_Code Code Indicating Source of Alert (Alert_Code) Register
 *  Code Indicating Source of Alert (Alert_Code) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Alert_Code_Struct
 *! \brief  Code Indicating Source of Alert Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Alert_Code_t {
  union {
    struct {
      uint16_t Alert_Code : 16;  /**< Code Indicating Type of Alert */
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Alert_Code_t;

/*@}*/

/** @defgroup External_Reference_Resistor External Reference Information (External_Reference_Resistor) Register
 *  External Reference Information (External_Reference_Resistor) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_External_Reference_Resistor_Struct
 *! \brief  External Reference Information Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_External_Reference_Resistor_t {
  union {
    struct {
      float Ext_Refin1_Value;  /**< Refin1 Value */
    };
    float VALUE32;
  };
} ADMW_CORE_External_Reference_Resistor_t;

/*@}*/

/** @defgroup External_Voltage_Reference External Reference Information (External_Voltage_Reference) Register
 *  External Reference Information (External_Voltage_Reference) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_External_Voltage_Reference_Struct
 *! \brief  External Reference Information Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_External_Voltage_Reference_t {
  union {
    struct {
      float Ext_Refin2_Value;  /**< Refin2 Value */
    };
    float VALUE32;
  };
} ADMW_CORE_External_Voltage_Reference_t;

/*@}*/

/** @defgroup Diagnostics_Control Diagnostic Control (Diagnostics_Control) Register
 *  Diagnostic Control (Diagnostics_Control) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Diagnostics_Control_Diag_OSD_Freq
 *! \brief  Diagnostics Open Sensor Detect Frequency (Diag_OSD_Freq) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_DIAGNOSTICS_CONTROL_OCD_OFF             = 0,  /**< No Open-Circuit Detection During Measurement                          */
  CORE_DIAGNOSTICS_CONTROL_OCD_PER_1_CYCLE     = 1,  /**< Open-Circuit Detection Performed Once Per Measurement Cycle           */
  CORE_DIAGNOSTICS_CONTROL_OCD_PER_100_CYCLES  = 2,  /**< Open-Circuit Detection Performed Once Per Hundred Measurement Cycles  */
  CORE_DIAGNOSTICS_CONTROL_OCD_PER_1000_CYCLES = 3   /**< Open-Circuit Detection Performed Once Per Thousand Measurement Cycles */
} ADMW_CORE_Diagnostics_Control_Diag_OSD_Freq;


/* ==========================================================================
 *! \struct ADMW_CORE_Diagnostics_Control_Struct
 *! \brief  Diagnostic Control Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Diagnostics_Control_t {
  union {
    struct {
      uint16_t Diag_Global_En :  1;  /**< Diagnostics Global Enable */
      uint16_t Diag_Meas_En   :  1;  /**< Diagnostics Measure Enable */
      uint16_t Diag_OSD_Freq  :  2;  /**< Diagnostics Open Sensor Detect Frequency */
      uint16_t reserved4      : 12;
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Diagnostics_Control_t;

/*@}*/

/** @defgroup Data_FIFO FIFO Buffer of Sensor Results (Data_FIFO) Register
 *  FIFO Buffer of Sensor Results (Data_FIFO) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Data_FIFO_Struct
 *! \brief  FIFO Buffer of Sensor Results Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Data_FIFO_t {
  union {
    struct {
      uint8_t Data_Fifo  :  8;  /**< Fifo Buffer of Sensor Results */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Data_FIFO_t;

/*@}*/

/** @defgroup Debug_Code Additional Information on Source of Alert or Errors (Debug_Code) Register
 *  Additional Information on Source of Alert or Errors (Debug_Code) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Debug_Code_Struct
 *! \brief  Additional Information on Source of Alert or Errors Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Debug_Code_t {
  union {
    struct {
      uint32_t Debug_Code : 32;  /**< Additional Information on Source of Alert or Errors */
    };
    uint32_t VALUE32;
  };
} ADMW_CORE_Debug_Code_t;

/*@}*/

/** @defgroup Advanced_Sensor_Access Enables Access to Advanced Sensor Configuration (Advanced_Sensor_Access) Register
 *  Enables Access to Advanced Sensor Configuration (Advanced_Sensor_Access) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Advanced_Sensor_Access_Struct
 *! \brief  Enables Access to Advanced Sensor Configuration Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Advanced_Sensor_Access_t {
  union {
    struct {
      uint16_t Advanced_Sensor_Access : 16;  /**< Write Specific Key Value to Access Advanced Sensors */
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Advanced_Sensor_Access_t;

/*@}*/

/** @defgroup LUT_Select Read/Write Strobe (LUT_Select) Register
 *  Read/Write Strobe (LUT_Select) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_LUT_Select_LUT_RW
 *! \brief  Read or Write LUT Data (LUT_RW) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_LUT_SELECT_LUT_READ  = 0,  /**< Read Addressed LUT Data  */
  CORE_LUT_SELECT_LUT_WRITE = 1   /**< Write Addressed LUT Data */
} ADMW_CORE_LUT_Select_LUT_RW;


/* ==========================================================================
 *! \struct ADMW_CORE_LUT_Select_Struct
 *! \brief  Read/Write Strobe Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_LUT_Select_t {
  union {
    struct {
      uint8_t reserved0  :  7;
      uint8_t LUT_RW     :  1;  /**< Read or Write LUT Data */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_LUT_Select_t;

/*@}*/

/** @defgroup LUT_Offset Offset into Selected LUT (LUT_Offset) Register
 *  Offset into Selected LUT (LUT_Offset) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_LUT_Offset_Struct
 *! \brief  Offset into Selected LUT Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_LUT_Offset_t {
  union {
    struct {
      uint16_t LUT_Offset : 14;  /**< Offset into Look-Up-Table */
      uint16_t reserved14 :  2;
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_LUT_Offset_t;

/*@}*/

/** @defgroup LUT_Data Data to Read/Write from Addressed LUT Entry (LUT_Data) Register
 *  Data to Read/Write from Addressed LUT Entry (LUT_Data) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_LUT_Data_Struct
 *! \brief  Data to Read/Write from Addressed LUT Entry Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_LUT_Data_t {
  union {
    struct {
      uint8_t LUT_Data   :  8;  /**< Data Byte to Write to / Read from Look-Up-Table */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_LUT_Data_t;

/*@}*/

/** @defgroup Revision Hardware, Firmware Revision (Revision) Register
 *  Hardware, Firmware Revision (Revision) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Revision_Struct
 *! \brief  Hardware, Firmware Revision Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Revision_t {
  union {
    struct {
      uint32_t Rev_Patch  : 16;  /**< Patch Revision Information */
      uint32_t Rev_Minor  :  8;  /**< Minor Revision Information */
      uint32_t Rev_Major  :  8;  /**< Major Revision Information */
    };
    uint32_t VALUE32;
  };
} ADMW_CORE_Revision_t;

/*@}*/

/** @defgroup Channel_Count Number of Channel Occurrences per Measurement Cycle (Channel_Count) Register
 *  Number of Channel Occurrences per Measurement Cycle (Channel_Count) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Channel_Count_Struct
 *! \brief  Number of Channel Occurrences per Measurement Cycle Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Channel_Count_t {
  union {
    struct {
      uint8_t Channel_Count :  7;  /**< How Many Times Channel Should Appear in One Cycle */
      uint8_t Channel_Enable :  1;  /**< Enable Channel in Measurement Cycle */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Channel_Count_t;

/*@}*/

/** @defgroup Channel_Options Position of Channel Within Sequence and Enable for FFT (Channel_Options) Register
 *  Position of Channel Within Sequence and Enable for FFT (Channel_Options) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Channel_Options_Struct
 *! \brief  Position of Channel Within Sequence and Enable for FFT Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Channel_Options_t {
  union {
    struct {
      uint8_t Channel_Priority :  4;  /**< Indicates Priority or Position of This Channel in Sequence */
      uint8_t reserved4        :  4;
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Channel_Options_t;

/*@}*/

/** @defgroup Sensor_Type Sensor Select (Sensor_Type) Register
 *  Sensor Select (Sensor_Type) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Sensor_Type_Sensor_Type
 *! \brief  Sensor Type (Sensor_Type) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_SENSOR_TYPE_THERMOCOUPLE_T      = 0,     /**< Thermocouple T-Type Sensor Defined Level 1        */
  CORE_SENSOR_TYPE_THERMOCOUPLE_J      = 1,     /**< Thermocouple J-Type Sensor Defined Level 1        */
  CORE_SENSOR_TYPE_THERMOCOUPLE_K      = 2,     /**< Thermocouple K-Type Sensor Defined Level 1        */
  CORE_SENSOR_TYPE_RTD_2W_PT100        = 32,    /**< RTD 2 Wire PT100 Sensor Defined Level 1           */
  CORE_SENSOR_TYPE_RTD_2W_PT1000       = 33,    /**< RTD 2 Wire PT1000 Sensor Defined Level 1          */
  CORE_SENSOR_TYPE_RTD_3W_PT100        = 64,    /**< RTD 3 Wire PT100 Sensor Defined Level 1           */
  CORE_SENSOR_TYPE_RTD_3W_PT1000       = 65,    /**< RTD 3 Wire PT1000 Sensor Defined Level 1          */
  CORE_SENSOR_TYPE_RTD_4W_PT100        = 96,    /**< RTD 4 Wire PT100 Sensor Defined Level 1           */
  CORE_SENSOR_TYPE_RTD_4W_PT1000       = 97,    /**< RTD 4 Wire PT1000 Sensor Defined Level 1          */
  CORE_SENSOR_TYPE_THERMISTOR_A_10K    = 128,   /**< Thermistor Type A 10kOhm Sensor Defined Level 1   */
  CORE_SENSOR_TYPE_THERMISTOR_B_10K    = 129,   /**< Thermistor Type B 10kOhm Sensor Defined Level 1   */
  CORE_SENSOR_TYPE_BRIDGE_4W_2         = 169,   /**< Bridge 4 Wire Sensor 2 Defined Level 2            */
  CORE_SENSOR_TYPE_BRIDGE_6W_1         = 200,   /**< Bridge 6 Wire Sensor 1 Defined Level 2            */
  CORE_SENSOR_TYPE_BRIDGE_6W_2         = 201,   /**< Bridge 6 Wire Sensor 2 Defined Level 2            */
  CORE_SENSOR_TYPE_DIODE_2C_TYPEA      = 224,   /**< Diode 2 Current Type A Sensor Defined Level 1     */
  CORE_SENSOR_TYPE_DIODE_3C_TYPEA      = 225,   /**< Diode 3 Current Type A Sensor Defined Level 1     */
  CORE_SENSOR_TYPE_DIODE_2C_1          = 232,   /**< Diode 2 Current Sensor 1 Defined Level 2          */
  CORE_SENSOR_TYPE_DIODE_3C_1          = 233,   /**< Diode 3 Current Sensor 1 Defined Level 2          */
  CORE_SENSOR_TYPE_VOLTAGE             = 512,   /**< Voltage Input                                     */
  CORE_SENSOR_TYPE_VOLTAGE_PRESSURE_A  = 544,   /**< Voltage Output Pressure Sensor A Defined Level 1  */
  CORE_SENSOR_TYPE_VOLTAGE_PRESSURE_B  = 545,   /**< Voltage Output Pressure Sensor B Defined Level 1  */
  CORE_SENSOR_TYPE_CURRENT             = 768,   /**< Current Input                                     */
  CORE_SENSOR_TYPE_I2C_PRESSURE_A      = 2048,  /**< I2C Pressure Sensor A Defined Level 1             */
  CORE_SENSOR_TYPE_I2C_PRESSURE_B      = 2049,  /**< I2C Pressure Sensor B Defined Level 1             */
  CORE_SENSOR_TYPE_I2C_HUMIDITY_A      = 2112,  /**< I2C Humidity Sensor A Defined Level 1             */
  CORE_SENSOR_TYPE_I2C_HUMIDITY_B      = 2113,  /**< I2C Humidity Sensor B Defined Level 1             */
  CORE_SENSOR_TYPE_SPI_ACCELEROMETER_A = 3200,  /**< SPI Accelerometer Sensor A 3-Axis Defined Level 1 */
  CORE_SENSOR_TYPE_SPI_ACCELEROMETER_B = 3201,  /**< SPI Accelerometer Sensor B 3-Axis Defined Level 1 */
  CORE_SENSOR_TYPE_CO2_A_DEF           = 3584   /**< CO2 Sensor A Defined Level 1                      */
} ADMW_CORE_Sensor_Type_Sensor_Type;


/* ==========================================================================
 *! \struct ADMW_CORE_Sensor_Type_Struct
 *! \brief  Sensor Select Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Sensor_Type_t {
  union {
    struct {
      uint16_t Sensor_Type : 12;  /**< Sensor Type */
      uint16_t reserved12  :  4;
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Sensor_Type_t;

/*@}*/

/** @defgroup Sensor_Details Sensor Details (Sensor_Details) Register
 *  Sensor Details (Sensor_Details) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Sensor_Details_Measurement_Units
 *! \brief  Units of Sensor Measurement (Measurement_Units) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_SENSOR_DETAILS_UNITS_UNSPECIFIED = 0,  /**< Not Specified */
  CORE_SENSOR_DETAILS_UNITS_RESERVED    = 1,  /**< Reserved      */
  CORE_SENSOR_DETAILS_UNITS_DEGC        = 2,  /**< Degrees C     */
  CORE_SENSOR_DETAILS_UNITS_DEGF        = 3   /**< Degrees F     */
} ADMW_CORE_Sensor_Details_Measurement_Units;


/*  =========================================================================
 *! \enum   ADMW_CORE_Sensor_Details_LUT_Select
 *! \brief  Lookup Table Select (LUT_Select) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_SENSOR_DETAILS_LUT_DEFAULT  = 0,  /**< Default Lookup Table for Selected Sensor Type        */
  CORE_SENSOR_DETAILS_LUT_UNITY    = 1,  /**< Unity Lookup Table. 1:1 Mapping From Input to Output */
  CORE_SENSOR_DETAILS_LUT_CUSTOM   = 2,  /**< User Defined Custom Lookup Table.                    */
  CORE_SENSOR_DETAILS_LUT_RESERVED = 3   /**< Reserved                                             */
} ADMW_CORE_Sensor_Details_LUT_Select;


/*  =========================================================================
 *! \enum   ADMW_CORE_Sensor_Details_Reference_Select
 *! \brief  Reference Selection (Reference_Select) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_SENSOR_DETAILS_REF_VINT      = 0,  /**< Internal voltage reference (1.2V)                                  */
  CORE_SENSOR_DETAILS_REF_VEXT1     = 1,  /**< External Voltage reference applied to VERF+ and VREF-              */
  CORE_SENSOR_DETAILS_REF_VRESERVED = 2,  /**< ExReserved for future use.                                         */
  CORE_SENSOR_DETAILS_REF_AVDD      = 3,  /**< AVDD Supply Used as Excitation and Internally applied as Reference */
  CORE_SENSOR_DETAILS_REF_NUM             /**< Number of reference options. */  
} ADMW_CORE_Sensor_Details_Reference_Select;


/*  =========================================================================
 *! \enum   ADMW_CORE_Sensor_Details_PGA_Gain
 *! \brief  PGA Gain (PGA_Gain) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_SENSOR_DETAILS_PGA_GAIN_1   = 0,  /**< Gain of 1   */
  CORE_SENSOR_DETAILS_PGA_GAIN_2   = 1,  /**< Gain of 2   */
  CORE_SENSOR_DETAILS_PGA_GAIN_4   = 2,  /**< Gain of 4   */
  CORE_SENSOR_DETAILS_PGA_GAIN_8   = 3,  /**< Gain of 8   */
  CORE_SENSOR_DETAILS_PGA_GAIN_16  = 4,  /**< Gain of 16  */
  CORE_SENSOR_DETAILS_PGA_GAIN_32  = 5,  /**< Gain of 32  */
  CORE_SENSOR_DETAILS_PGA_GAIN_64  = 6,  /**< Gain of 64  */
  CORE_SENSOR_DETAILS_PGA_GAIN_128 = 7   /**< Gain of 128 */
} ADMW_CORE_Sensor_Details_PGA_Gain;


/*  =========================================================================
 *! \enum   ADMW_CORE_Sensor_Details_RTD_Curve
 *! \brief  Select RTD Curve for Linearisation (RTD_Curve) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_SENSOR_DETAILS_EUROPEAN_CURVE = 0,  /**< European Curve */
  CORE_SENSOR_DETAILS_AMERICAN_CURVE = 1,  /**< American Curve */
  CORE_SENSOR_DETAILS_JAPANESE_CURVE = 2,  /**< Japanese Curve */
  CORE_SENSOR_DETAILS_ITS90_CURVE    = 3   /**< ITS-90 Curve   */
} ADMW_CORE_Sensor_Details_RTD_Curve;


/* ==========================================================================
 *! \struct ADMW_CORE_Sensor_Details_Struct
 *! \brief  Sensor Details Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Sensor_Details_t {
  union {
    struct {
      uint32_t Measurement_Units :  4;  /**< Units of Sensor Measurement */
      uint32_t Compensation_Channel :  4;  /**< Indicates Which Channel is Used to Compensate Sensor Result */
      uint32_t reserved8            :  7;
      uint32_t LUT_Select           :  2;  /**< Lookup Table Select */
      uint32_t Do_Not_Publish       :  1;  /**< Do Not Publish Channel Result */
      uint32_t reserved18           :  2;
      uint32_t Reference_Select     :  4;  /**< Reference Selection */
      uint32_t PGA_Gain             :  3;  /**< PGA Gain */
      uint32_t RTD_Curve            :  2;  /**< Select RTD Curve for Linearisation */
      uint32_t reserved29           :  2;
      uint32_t Compensation_Disable :  1;  /**< Indicates Compensation Data Should Not Be Used */
    };
    uint32_t VALUE32;
  };
} ADMW_CORE_Sensor_Details_t;

/*@}*/

/** @defgroup Channel_Excitation Excitation Current (Channel_Excitation) Register
 *  Excitation Current (Channel_Excitation) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Channel_Excitation_IOUT_Excitation_Current
 *! \brief  Current Source Value (IOUT_Excitation_Current) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_CHANNEL_EXCITATION_EXTERNAL    = 0,  /**< External Current Sourced */
  CORE_CHANNEL_EXCITATION_RESERVED    = 1,  /**< Reserved                 */
  CORE_CHANNEL_EXCITATION_IEXC_10UA   = 2,  /**< 10 \mu;A                 */
  CORE_CHANNEL_EXCITATION_RESERVED2   = 3,  /**< Reserved                 */
  CORE_CHANNEL_EXCITATION_IEXC_50UA   = 4,  /**< 50 \mu;A                 */
  CORE_CHANNEL_EXCITATION_IEXC_100UA  = 5,  /**< 100 \mu;A                */
  CORE_CHANNEL_EXCITATION_IEXC_250UA  = 6,  /**< 250 \mu;A                */
  CORE_CHANNEL_EXCITATION_IEXC_500UA  = 7,  /**< 500 \mu;A                */
  CORE_CHANNEL_EXCITATION_IEXC_1000UA = 8   /**< 1000 \mu;A               */
} ADMW_CORE_Channel_Excitation_IOUT_Excitation_Current;


/*  =========================================================================
 *! \enum   ADMW_CORE_Channel_Excitation_IOUT_Diode_Ratio
 *! \brief  Modify Current Ratios Used for Diode Sensor (IOUT_Diode_Ratio) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_CHANNEL_EXCITATION_DIODE_2PT_10UA_100UA        = 0,  /**< 2 Current measurement 10uA 100uA       */
  CORE_CHANNEL_EXCITATION_DIODE_2PT_20UA_160UA        = 1,  /**< 2 Current measurement 20uA 160uA       */
  CORE_CHANNEL_EXCITATION_DIODE_2PT_50UA_300UA        = 2,  /**< 2 Current measurement 50uA 300uA       */
  CORE_CHANNEL_EXCITATION_DIODE_2PT_100UA_600UA       = 3,  /**< 2 Current measurement 100uA 600uA      */
  CORE_CHANNEL_EXCITATION_DIODE_3PT_10UA_50UA_100UA   = 4,  /**< 3 current measuremet 10uA 50uA 100uA   */
  CORE_CHANNEL_EXCITATION_DIODE_3PT_20UA_100UA_160UA  = 5,  /**< 3 current measuremet 20uA 100uA 160uA  */
  CORE_CHANNEL_EXCITATION_DIODE_3PT_50UA_150UA_300UA  = 6,  /**< 3 current measuremet 50uA 150uA 300uA  */
  CORE_CHANNEL_EXCITATION_DIODE_3PT_100UA_300UA_600UA = 7   /**< 3 current measuremet 100uA 300uA 600uA */
} ADMW_CORE_Channel_Excitation_IOUT_Diode_Ratio;


/* ==========================================================================
 *! \struct ADMW_CORE_Channel_Excitation_Struct
 *! \brief  Excitation Current Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Channel_Excitation_t {
  union {
    struct {
      uint16_t IOUT_Excitation_Current :  4;  /**< Current Source Value */
      uint16_t reserved4               :  2;
      uint16_t IOUT_Diode_Ratio        :  3;  /**< Modify Current Ratios Used for Diode Sensor */
      uint16_t reserved9               :  7;
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Channel_Excitation_t;

/*@}*/

/** @defgroup Settling_Time Settling Time (Settling_Time) Register
 *  Settling Time (Settling_Time) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Settling_Time_Settling_Time_Units
 *! \brief  Units for Settling Time (Settling_Time_Units) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_SETTLING_TIME_MICROSECONDS = 0,  /**< Micro-Seconds */
  CORE_SETTLING_TIME_MILLISECONDS = 1,  /**< Milli-Seconds */
  CORE_SETTLING_TIME_SECONDS      = 2   /**< Seconds       */
} ADMW_CORE_Settling_Time_Settling_Time_Units;


/* ==========================================================================
 *! \struct ADMW_CORE_Settling_Time_Struct
 *! \brief  Settling Time Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Settling_Time_t {
  union {
    struct {
      uint16_t Settling_Time : 14;  /**< Settling Time to Allow When Switching to Channel */
      uint16_t Settling_Time_Units :  2;  /**< Units for Settling Time */
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Settling_Time_t;

/*@}*/

/** @defgroup Measurement_Setup ADC Digital Filter Selection (Measurement_Setup) Register
 *  ADC Digital Filter Selection (Measurement_Setup) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Measurement_Setup_Custom_Calibration
 *! \brief  Enables Custom Calibration for Selected Sensor (Custom_Calibration) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_MEASUREMENT_SETUP_INTERNAL_CALIBRATION = 0,  /**<  */
  CORE_MEASUREMENT_SETUP_CUSTOM_CALIBRATION   = 1   /**<  */
} ADMW_CORE_Measurement_Setup_Custom_Calibration;


/*  =========================================================================
 *! \enum   ADMW_CORE_Measurement_Setup_NOTCH_EN_2
 *! \brief  Enable Notch 2 Filter Mode (NOTCH_EN_2) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_MEASUREMENT_SETUP_NOTCH_DIS = 0,  /**< Disable Notch Filter                                                                                                     */
  CORE_MEASUREMENT_SETUP_NOTCH_EN  = 1   /**< Enable Notch 2 Filter option. Places a addtional notch at 1.2X ODR. Can be used for 50 and 60Hz rejection simultaneously */
} ADMW_CORE_Measurement_Setup_NOTCH_EN_2;


/*  =========================================================================
 *! \enum   ADMW_CORE_Measurement_Setup_PST_MEAS_EXC_CTRL
 *! \brief  Disabled Current Sources After Measurement Has Been Complete (PST_MEAS_EXC_CTRL) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_MEASUREMENT_SETUP_POWERCYCLE = 0,  /**<  */
  CORE_MEASUREMENT_SETUP_ALWAYSON   = 1   /**<  */
} ADMW_CORE_Measurement_Setup_PST_MEAS_EXC_CTRL;


/*  =========================================================================
 *! \enum   ADMW_CORE_Measurement_Setup_Chop_Mode
 *! \brief  Enabled and Disable Chop Mode (Chop_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_MEASUREMENT_SETUP_DISABLE_CHOP = 0,  /**< Chop Mode Disabled */
  CORE_MEASUREMENT_SETUP_HW_CHOP      = 1,  /**< Chop Mode Enabled  */
  CORE_MEASUREMENT_SETUP_ENABLE_CHOP  = 2,  /**< Chop Mode Enabled  */
  CORE_MEASUREMENT_SETUP_HW_SW_CHOP   = 3   /**< Chop Mode Enabled  */
} ADMW_CORE_Measurement_Setup_Chop_Mode;


/*  =========================================================================
 *! \enum   ADMW_CORE_Measurement_Setup_ADC_Filter_Type
 *! \brief  ADC Digital Filter Type (ADC_Filter_Type) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_MEASUREMENT_SETUP_ENABLE_SINC4 = 0,  /**< Enabled SINC4 Filter */
  CORE_MEASUREMENT_SETUP_ENABLE_SINC3 = 1   /**< Enabled SINC3 Filter */
} ADMW_CORE_Measurement_Setup_ADC_Filter_Type;


/*  =========================================================================
 *! \enum   ADMW_CORE_Measurement_Setup_GND_SW
 *! \brief  GND_SW (GND_SW) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_MEASUREMENT_SETUP_GND_SW_OPEN   = 0,  /**< GND_SW Open. The GND SW is not enabled for the sensor measurement                                             */
  CORE_MEASUREMENT_SETUP_GND_SW_CLOSED = 1   /**< GND_SW Closed. The GND SW is enabled for the sensor measurement, bit wiil Remain Closed After the Measurement */
} ADMW_CORE_Measurement_Setup_GND_SW;


/*  =========================================================================
 *! \enum   ADMW_CORE_Measurement_Setup_Buffer_Bypass
 *! \brief  Disable Buffers (Buffer_Bypass) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_MEASUREMENT_SETUP_BUFFERS_ENABLED  = 0,  /**<  */
  CORE_MEASUREMENT_SETUP_BUFFERS_DISABLED = 1   /**<  */
} ADMW_CORE_Measurement_Setup_Buffer_Bypass;


/* ==========================================================================
 *! \struct ADMW_CORE_Measurement_Setup_Struct
 *! \brief  ADC Digital Filter Selection Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Measurement_Setup_t {
  union {
    struct {
      uint32_t ADC_SF     :  7;  /**< ADC Digital Filter Select */
      uint32_t Custom_Calibration :  1;  /**< Enables Custom Calibration for Selected Sensor */
      uint32_t NOTCH_EN_2         :  1;  /**< Enable Notch 2 Filter Mode */
      uint32_t PST_MEAS_EXC_CTRL  :  1;  /**< Disabled Current Sources After Measurement Has Been Complete */
      uint32_t Chop_Mode          :  2;  /**< Enabled and Disable Chop Mode */
      uint32_t ADC_Filter_Type    :  1;  /**< ADC Digital Filter Type */
      uint32_t GND_SW             :  2;  /**< GND_SW */
      uint32_t Buffer_Bypass      :  1;  /**< Disable Buffers */
      uint32_t reserved16         : 16;
    };
    uint32_t VALUE32;
  };
} ADMW_CORE_Measurement_Setup_t;

/*@}*/

/** @defgroup High_Threshold_Limit High Threshold (High_Threshold_Limit) Register
 *  High Threshold (High_Threshold_Limit) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_High_Threshold_Limit_Struct
 *! \brief  High Threshold Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_High_Threshold_Limit_t {
  union {
    struct {
      float High_Threshold;  /**< Upper Limit for Sensor Alert Comparison */
    };
    float VALUE32;
  };
} ADMW_CORE_High_Threshold_Limit_t;

/*@}*/

/** @defgroup Low_Threshold_Limit Low Threshold (Low_Threshold_Limit) Register
 *  Low Threshold (Low_Threshold_Limit) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Low_Threshold_Limit_Struct
 *! \brief  Low Threshold Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Low_Threshold_Limit_t {
  union {
    struct {
      float Low_Threshold;  /**< Lower Limit for Sensor Alert Comparison */
    };
    float VALUE32;
  };
} ADMW_CORE_Low_Threshold_Limit_t;

/*@}*/

/** @defgroup Sensor_Offset Sensor Offset Adjustment (Sensor_Offset) Register
 *  Sensor Offset Adjustment (Sensor_Offset) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Sensor_Offset_Struct
 *! \brief  Sensor Offset Adjustment Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Sensor_Offset_t {
  union {
    struct {
      float Sensor_Offset;  /**< Sensor Offset Adjustment */
    };
    float VALUE32;
  };
} ADMW_CORE_Sensor_Offset_t;

/*@}*/

/** @defgroup Sensor_Gain Sensor Gain Adjustment (Sensor_Gain) Register
 *  Sensor Gain Adjustment (Sensor_Gain) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Sensor_Gain_Struct
 *! \brief  Sensor Gain Adjustment Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Sensor_Gain_t {
  union {
    struct {
      float Sensor_Gain;  /**< Sensor Gain Adjustment */
    };
    float VALUE32;
  };
} ADMW_CORE_Sensor_Gain_t;

/*@}*/

/** @defgroup Alert_Code_Ch Per-Channel Detailed Alert-Code Information (Alert_Code_Ch) Register
 *  Per-Channel Detailed Alert-Code Information (Alert_Code_Ch) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Alert_Code_Ch_Struct
 *! \brief  Per-Channel Detailed Alert-Code Information Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Alert_Code_Ch_t {
  union {
    struct {
      uint16_t Alert_Code_Ch : 16;  /**< Per-Channel Code Indicating Type of Alert */
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Alert_Code_Ch_t;

/*@}*/

/** @defgroup Channel_Skip Indicates If Channel Will Skip Some Measurement Cycles (Channel_Skip) Register
 *  Indicates If Channel Will Skip Some Measurement Cycles (Channel_Skip) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Channel_Skip_Struct
 *! \brief  Indicates If Channel Will Skip Some Measurement Cycles Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Channel_Skip_t {
  union {
    struct {
      uint16_t Channel_Skip :  8;  /**< Indicates If Channel Will Skip Some Measurement Cycles */
      uint16_t reserved8    :  8;
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Channel_Skip_t;

/*@}*/

/** @defgroup Sensor_Parameter Sensor Parameter Adjustment (Sensor_Parameter) Register
 *  Sensor Parameter Adjustment (Sensor_Parameter) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Sensor_Parameter_Struct
 *! \brief  Sensor Parameter Adjustment Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Sensor_Parameter_t {
  union {
    struct {
      float Sensor_Parameter;  /**< Sensor Parameter Adjustment */
    };
    float VALUE32;
  };
} ADMW_CORE_Sensor_Parameter_t;

/*@}*/

/** @defgroup Calibration_Parameter Calibration Parameter Value (Calibration_Parameter) Register
 *  Calibration Parameter Value (Calibration_Parameter) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Calibration_Parameter_Struct
 *! \brief  Calibration Parameter Value Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Calibration_Parameter_t {
  union {
    struct {
      uint32_t Calibration_Parameter : 24;  /**< Calibration Parameter Value */
      uint32_t Calibration_Parameter_Enable :  1;  /**< Enables Use of Calibration_Parameter */
      uint32_t reserved25                   :  7;
    };
    uint32_t VALUE32;
  };
} ADMW_CORE_Calibration_Parameter_t;

/*@}*/

/** @defgroup Digital_Sensor_Config Digital Sensor Data Coding (Digital_Sensor_Config) Register
 *  Digital Sensor Data Coding (Digital_Sensor_Config) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Digital_Sensor_Config_Digital_Sensor_Coding
 *! \brief  Data Encoding of Sensor Result (Digital_Sensor_Coding) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_DIGITAL_SENSOR_CONFIG_CODING_NONE          = 0,  /**< None/Invalid    */
  CORE_DIGITAL_SENSOR_CONFIG_CODING_UNIPOLAR      = 1,  /**< Unipolar        */
  CORE_DIGITAL_SENSOR_CONFIG_CODING_TWOS_COMPL    = 2,  /**< Twos Complement */
  CORE_DIGITAL_SENSOR_CONFIG_CODING_OFFSET_BINARY = 3   /**< Offset Binary   */
} ADMW_CORE_Digital_Sensor_Config_Digital_Sensor_Coding;


/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Config_Struct
 *! \brief  Digital Sensor Data Coding Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Config_t {
  union {
    struct {
      uint16_t Digital_Sensor_Coding :  2;  /**< Data Encoding of Sensor Result */
      uint16_t Digital_Sensor_Little_Endian :  1;  /**< Data Endianness of Sensor Result */
      uint16_t Digital_Sensor_Left_Aligned  :  1;  /**< Data Alignment Within the Data Frame */
      uint16_t Digital_Sensor_Bit_Offset    :  4;  /**< Data Bit Offset, Relative to Alignment */
      uint16_t Digital_Sensor_Read_Bytes    :  3;  /**< Number of Bytes to Read from the Sensor */
      uint16_t Digital_Sensor_Data_Bits     :  5;  /**< Number of Relevant Data Bits */
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Digital_Sensor_Config_t;

/*@}*/

/** @defgroup Digital_Sensor_Address Sensor Address (Digital_Sensor_Address) Register
 *  Sensor Address (Digital_Sensor_Address) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Address_Struct
 *! \brief  Sensor Address Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Address_t {
  union {
    struct {
      uint8_t Digital_Sensor_Address :  8;  /**< I2C Address or Write Address Command for SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Address_t;

/*@}*/

/** @defgroup Digital_Sensor_Num_Cmds Number of Configuration, Read Commands for Digital Sensors (Digital_Sensor_Num_Cmds) Register
 *  Number of Configuration, Read Commands for Digital Sensors (Digital_Sensor_Num_Cmds) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Num_Cmds_Struct
 *! \brief  Number of Configuration, Read Commands for Digital Sensors Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Num_Cmds_t {
  union {
    struct {
      uint8_t Digital_Sensor_Num_Cfg_Cmds :  3;  /**< Number of Configuration Commands for Digital Sensor */
      uint8_t reserved3                    :  1;
      uint8_t Digital_Sensor_Num_Read_Cmds :  3;  /**< Number of Read Commands for Digital Sensor */
      uint8_t reserved7                    :  1;
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Num_Cmds_t;

/*@}*/

/** @defgroup Digital_Sensor_Comms Digital Sensor Communication Clock Configuration (Digital_Sensor_Comms) Register
 *  Digital Sensor Communication Clock Configuration (Digital_Sensor_Comms) Register.
 *  @{
 */

/*  =========================================================================
 *! \enum   ADMW_CORE_Digital_Sensor_Comms_Digital_Sensor_Comms_En
 *! \brief  Enable Digital Sensor Comms Register Parameters (Digital_Sensor_Comms_En) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_DIGITAL_SENSOR_COMMS_DIGITAL_COMMS_DEFAULT = 0,  /**< Default Parameters Used for Digital Sensor Communications       */
  CORE_DIGITAL_SENSOR_COMMS_DIGITAL_COMMS_USER    = 1   /**< User Supplied Parameters Used for Digital Sensor Communications */
} ADMW_CORE_Digital_Sensor_Comms_Digital_Sensor_Comms_En;


/*  =========================================================================
 *! \enum   ADMW_CORE_Digital_Sensor_Comms_SPI_Clock
 *! \brief  Controls Clock Frequency for SPI Sensors (SPI_Clock) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_DIGITAL_SENSOR_COMMS_SPI_8MHZ    = 0,   /**< 8MHz      */
  CORE_DIGITAL_SENSOR_COMMS_SPI_4MHZ    = 1,   /**< 4MHz      */
  CORE_DIGITAL_SENSOR_COMMS_SPI_2MHZ    = 2,   /**< 2MHz      */
  CORE_DIGITAL_SENSOR_COMMS_SPI_1MHZ    = 3,   /**< 1MHz      */
  CORE_DIGITAL_SENSOR_COMMS_SPI_500KHZ  = 4,   /**< 500kHz    */
  CORE_DIGITAL_SENSOR_COMMS_SPI_250KHZ  = 5,   /**< 250kHz    */
  CORE_DIGITAL_SENSOR_COMMS_SPI_125KHZ  = 6,   /**< 125kHz    */
  CORE_DIGITAL_SENSOR_COMMS_SPI_62P5KHZ = 7,   /**< 62.5kHz   */
  CORE_DIGITAL_SENSOR_COMMS_SPI_31P3KHZ = 8,   /**< 31.25kHz  */
  CORE_DIGITAL_SENSOR_COMMS_SPI_15P6KHZ = 9,   /**< 15.625kHz */
  CORE_DIGITAL_SENSOR_COMMS_SPI_7P8KHZ  = 10,  /**< 7.8kHz    */
  CORE_DIGITAL_SENSOR_COMMS_SPI_3P9KHZ  = 11,  /**< 3.9kHz    */
  CORE_DIGITAL_SENSOR_COMMS_SPI_1P9KHZ  = 12,  /**< 1.95kHz   */
  CORE_DIGITAL_SENSOR_COMMS_SPI_977HZ   = 13,  /**< 977Hz     */
  CORE_DIGITAL_SENSOR_COMMS_SPI_488HZ   = 14,  /**< 488Hz     */
  CORE_DIGITAL_SENSOR_COMMS_SPI_244HZ   = 15   /**< 244Hz     */
} ADMW_CORE_Digital_Sensor_Comms_SPI_Clock;


/*  =========================================================================
 *! \enum   ADMW_CORE_Digital_Sensor_Comms_I2C_Clock
 *! \brief  Controls SCLK Frequency for I2C Sensors (I2C_Clock) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_DIGITAL_SENSOR_COMMS_I2C_100K      = 0,  /**< 100kHz SCL */
  CORE_DIGITAL_SENSOR_COMMS_I2C_400K      = 1,  /**< 400kHz SCL */
  CORE_DIGITAL_SENSOR_COMMS_I2C_RESERVED1 = 2,  /**< Reserved   */
  CORE_DIGITAL_SENSOR_COMMS_I2C_RESERVED2 = 3   /**< Reserved   */
} ADMW_CORE_Digital_Sensor_Comms_I2C_Clock;


/*  =========================================================================
 *! \enum   ADMW_CORE_Digital_Sensor_Comms_SPI_Mode
 *! \brief  Configuration for Sensor SPI Protocol (SPI_Mode) Enumerations
 *  ========================================================================= */
typedef enum
{
  CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_0 = 0,  /**< Clock Polarity = 0 Clock Phase = 0 */
  CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_1 = 1,  /**< Clock Polarity = 0 Clock Phase = 1 */
  CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_2 = 2,  /**< Clock Polarity = 1 Clock Phase = 0 */
  CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_3 = 3   /**< Clock Polarity = 1 Clock Phase = 1 */
} ADMW_CORE_Digital_Sensor_Comms_SPI_Mode;


/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Comms_Struct
 *! \brief  Digital Sensor Communication Clock Configuration Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Comms_t {
  union {
    struct {
      uint16_t Digital_Sensor_Comms_En :  1;  /**< Enable Digital Sensor Comms Register Parameters */
      uint16_t SPI_Clock               :  4;  /**< Controls Clock Frequency for SPI Sensors */
      uint16_t I2C_Clock               :  2;  /**< Controls SCLK Frequency for I2C Sensors */
      uint16_t reserved7               :  3;
      uint16_t SPI_Mode                :  2;  /**< Configuration for Sensor SPI Protocol */
      uint16_t reserved12              :  4;
    };
    uint16_t VALUE16;
  };
} ADMW_CORE_Digital_Sensor_Comms_t;

/*@}*/

/** @defgroup Digital_Sensor_Command1 Sensor Configuration Command1 (Digital_Sensor_Command1) Register
 *  Sensor Configuration Command1 (Digital_Sensor_Command1) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Command1_Struct
 *! \brief  Sensor Configuration Command1 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Command1_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command1 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Command1_t;

/*@}*/

/** @defgroup Digital_Sensor_Command2 Sensor Configuration Command2 (Digital_Sensor_Command2) Register
 *  Sensor Configuration Command2 (Digital_Sensor_Command2) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Command2_Struct
 *! \brief  Sensor Configuration Command2 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Command2_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command2 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Command2_t;

/*@}*/

/** @defgroup Digital_Sensor_Command3 Sensor Configuration Command3 (Digital_Sensor_Command3) Register
 *  Sensor Configuration Command3 (Digital_Sensor_Command3) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Command3_Struct
 *! \brief  Sensor Configuration Command3 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Command3_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command3 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Command3_t;

/*@}*/

/** @defgroup Digital_Sensor_Command4 Sensor Configuration Command4 (Digital_Sensor_Command4) Register
 *  Sensor Configuration Command4 (Digital_Sensor_Command4) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Command4_Struct
 *! \brief  Sensor Configuration Command4 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Command4_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command4 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Command4_t;

/*@}*/

/** @defgroup Digital_Sensor_Command5 Sensor Configuration Command5 (Digital_Sensor_Command5) Register
 *  Sensor Configuration Command5 (Digital_Sensor_Command5) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Command5_Struct
 *! \brief  Sensor Configuration Command5 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Command5_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command5 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Command5_t;

/*@}*/

/** @defgroup Digital_Sensor_Command6 Sensor Configuration Command6 (Digital_Sensor_Command6) Register
 *  Sensor Configuration Command6 (Digital_Sensor_Command6) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Command6_Struct
 *! \brief  Sensor Configuration Command6 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Command6_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command6 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Command6_t;

/*@}*/

/** @defgroup Digital_Sensor_Command7 Sensor Configuration Command7 (Digital_Sensor_Command7) Register
 *  Sensor Configuration Command7 (Digital_Sensor_Command7) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Command7_Struct
 *! \brief  Sensor Configuration Command7 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Command7_t {
  union {
    struct {
      uint8_t Digital_Sensor_Command7 :  8;  /**< Configuration Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Command7_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd1 Sensor Read Command1 (Digital_Sensor_Read_Cmd1) Register
 *  Sensor Read Command1 (Digital_Sensor_Read_Cmd1) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Read_Cmd1_Struct
 *! \brief  Sensor Read Command1 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Read_Cmd1_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd1 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Read_Cmd1_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd2 Sensor Read Command2 (Digital_Sensor_Read_Cmd2) Register
 *  Sensor Read Command2 (Digital_Sensor_Read_Cmd2) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Read_Cmd2_Struct
 *! \brief  Sensor Read Command2 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Read_Cmd2_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd2 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Read_Cmd2_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd3 Sensor Read Command3 (Digital_Sensor_Read_Cmd3) Register
 *  Sensor Read Command3 (Digital_Sensor_Read_Cmd3) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Read_Cmd3_Struct
 *! \brief  Sensor Read Command3 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Read_Cmd3_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd3 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Read_Cmd3_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd4 Sensor Read Command4 (Digital_Sensor_Read_Cmd4) Register
 *  Sensor Read Command4 (Digital_Sensor_Read_Cmd4) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Read_Cmd4_Struct
 *! \brief  Sensor Read Command4 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Read_Cmd4_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd4 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Read_Cmd4_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd5 Sensor Read Command5 (Digital_Sensor_Read_Cmd5) Register
 *  Sensor Read Command5 (Digital_Sensor_Read_Cmd5) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Read_Cmd5_Struct
 *! \brief  Sensor Read Command5 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Read_Cmd5_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd5 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Read_Cmd5_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd6 Sensor Read Command6 (Digital_Sensor_Read_Cmd6) Register
 *  Sensor Read Command6 (Digital_Sensor_Read_Cmd6) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Read_Cmd6_Struct
 *! \brief  Sensor Read Command6 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Read_Cmd6_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd6 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Read_Cmd6_t;

/*@}*/

/** @defgroup Digital_Sensor_Read_Cmd7 Sensor Read Command7 (Digital_Sensor_Read_Cmd7) Register
 *  Sensor Read Command7 (Digital_Sensor_Read_Cmd7) Register.
 *  @{
 */

/* ==========================================================================
 *! \struct ADMW_CORE_Digital_Sensor_Read_Cmd7_Struct
 *! \brief  Sensor Read Command7 Register bit field structure
 * ========================================================================== */
typedef struct _ADMW_CORE_Digital_Sensor_Read_Cmd7_t {
  union {
    struct {
      uint8_t Digital_Sensor_Read_Cmd7 :  8;  /**< Per Conversion Command to Send to Digital I2C/SPI Sensor */
    };
    uint8_t VALUE8;
  };
} ADMW_CORE_Digital_Sensor_Read_Cmd7_t;

/*@}*/


#if defined (__CC_ARM)
#pragma pop
#endif 

#endif
