/* ================================================================================

     Project      :   ADMW1001_REGISTERS
     File         :   ADMW1001_REGISTERS.h
     Description  :   Register Definitions

     Date         :   Jun 19, 2019

     Copyright (c) 2019 Analog Devices, Inc.  All Rights Reserved.
     This software is proprietary and confidential to Analog Devices, Inc. and
     its licensors.

     This file was auto-generated. Do not make local changes to this file.

   ================================================================================ */

#ifndef _DEF_ADMW1001_REGISTERS_H
#define _DEF_ADMW1001_REGISTERS_H

#if defined(_LANGUAGE_C) || (defined(__GNUC__) && !defined(__ASSEMBLER__))
#include <stdint.h>
#endif /* _LANGUAGE_C */

#ifndef __ADI_GENERATED_DEF_HEADERS__
#define __ADI_GENERATED_DEF_HEADERS__    1
#endif

#define __ADI_HAS_CORE__           1
#define __ADI_HAS_SPI__            1
#define __ADI_HAS_ADMW_TEST__      1

/* ============================================================================================================================
        
   ============================================================================================================================ */

/* ============================================================================================================================
        SPI
   ============================================================================================================================ */
#define REG_SPI_INTERFACE_CONFIG_A_RESET     0x00000030            /*      Reset Value for Interface_Config_A  */
#define REG_SPI_INTERFACE_CONFIG_A           0x00000000            /*  SPI Interface Configuration A */
#define REG_SPI_INTERFACE_CONFIG_B_RESET     0x00000000            /*      Reset Value for Interface_Config_B  */
#define REG_SPI_INTERFACE_CONFIG_B           0x00000001            /*  SPI Interface Configuration B */
#define REG_SPI_DEVICE_CONFIG_RESET          0x00000000            /*      Reset Value for Device_Config  */
#define REG_SPI_DEVICE_CONFIG                0x00000002            /*  SPI Device Configuration */
#define REG_SPI_CHIP_TYPE_RESET              0x00000007            /*      Reset Value for Chip_Type  */
#define REG_SPI_CHIP_TYPE                    0x00000003            /*  SPI Chip Type */
#define REG_SPI_PRODUCT_ID_L_RESET           0x00000020            /*      Reset Value for Product_ID_L  */
#define REG_SPI_PRODUCT_ID_L                 0x00000004            /*  SPI Product ID Low */
#define REG_SPI_PRODUCT_ID_H_RESET           0x00000000            /*      Reset Value for Product_ID_H  */
#define REG_SPI_PRODUCT_ID_H                 0x00000005            /*  SPI Product ID High */
#define REG_SPI_CHIP_GRADE_RESET             0x00000000            /*      Reset Value for Chip_Grade  */
#define REG_SPI_CHIP_GRADE                   0x00000006            /*  SPI Chip Grade */
#define REG_SPI_SCRATCH_PAD_RESET            0x00000000            /*      Reset Value for Scratch_Pad  */
#define REG_SPI_SCRATCH_PAD                  0x0000000A            /*  SPI Scratch Pad */
#define REG_SPI_SPI_REVISION_RESET           0x00000082            /*      Reset Value for SPI_Revision  */
#define REG_SPI_SPI_REVISION                 0x0000000B            /*  SPI SPI Revision */
#define REG_SPI_VENDOR_L_RESET               0x00000056            /*      Reset Value for Vendor_L  */
#define REG_SPI_VENDOR_L                     0x0000000C            /*  SPI Vendor ID Low */
#define REG_SPI_VENDOR_H_RESET               0x00000004            /*      Reset Value for Vendor_H  */
#define REG_SPI_VENDOR_H                     0x0000000D            /*  SPI Vendor ID High */
#define REG_SPI_STREAM_MODE_RESET            0x00000000            /*      Reset Value for Stream_Mode  */
#define REG_SPI_STREAM_MODE                  0x0000000E            /*  SPI Stream Mode */
#define REG_SPI_TRANSFER_CONFIG_RESET        0x00000000            /*      Reset Value for Transfer_Config  */
#define REG_SPI_TRANSFER_CONFIG              0x0000000F            /*  SPI Transfer Config */
#define REG_SPI_INTERFACE_CONFIG_C_RESET     0x00000033            /*      Reset Value for Interface_Config_C  */
#define REG_SPI_INTERFACE_CONFIG_C           0x00000010            /*  SPI Interface Configuration C */
#define REG_SPI_INTERFACE_STATUS_A_RESET     0x00000000            /*      Reset Value for Interface_Status_A  */
#define REG_SPI_INTERFACE_STATUS_A           0x00000011            /*  SPI Interface Status A */

/* ============================================================================================================================
        SPI Register BitMasks, Positions & Enumerations 
   ============================================================================================================================ */
/* -------------------------------------------------------------------------------------------------------------------------
          SPI_INTERFACE_CONFIG_A               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_INTERFACE_CONFIG_A_SW_RESET  7            /*  First of Two of SW_RESET Bits. */
#define BITP_SPI_INTERFACE_CONFIG_A_ADDR_ASCENSION  5            /*  Determines Sequential Addressing Behavior */
#define BITP_SPI_INTERFACE_CONFIG_A_SDO_ENABLE  4            /*  SDO Pin Enable */
#define BITP_SPI_INTERFACE_CONFIG_A_SW_RESETX  0            /*  Second  of Two of SW_RESET Bits. */
#define BITM_SPI_INTERFACE_CONFIG_A_SW_RESET 0x00000080    /*  First of Two of SW_RESET Bits. */
#define BITM_SPI_INTERFACE_CONFIG_A_ADDR_ASCENSION 0x00000020    /*  Determines Sequential Addressing Behavior */
#define BITM_SPI_INTERFACE_CONFIG_A_SDO_ENABLE 0x00000010    /*  SDO Pin Enable */
#define BITM_SPI_INTERFACE_CONFIG_A_SW_RESETX 0x00000001    /*  Second  of Two of SW_RESET Bits. */
#define ENUM_SPI_INTERFACE_CONFIG_A_DESCEND  0x00000000            /*  Addr_Ascension: Address accessed is decremented by one for each data byte when streaming */
#define ENUM_SPI_INTERFACE_CONFIG_A_ASCEND   0x00000020            /*  Addr_Ascension: Address accessed is incremented by one for each data byte when streaming */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_INTERFACE_CONFIG_B               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_INTERFACE_CONFIG_B_SINGLE_INST  7            /*  Select Streaming or Single Instruction Mode */
#define BITM_SPI_INTERFACE_CONFIG_B_SINGLE_INST 0x00000080    /*  Select Streaming or Single Instruction Mode */
#define ENUM_SPI_INTERFACE_CONFIG_B_STREAMING_MODE 0x00000000            /*  Single_Inst: Streaming mode is enabled */
#define ENUM_SPI_INTERFACE_CONFIG_B_SINGLE_INSTRUCTION_MODE 0x00000080            /*  Single_Inst: Single Instruction mode is enabled */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_DEVICE_CONFIG                    Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_DEVICE_CONFIG_OPERATING_MODES  0            /*  Power Modes */
#define BITM_SPI_DEVICE_CONFIG_OPERATING_MODES 0x00000003    /*  Power Modes */
#define ENUM_SPI_DEVICE_CONFIG_NORMAL        0x00000000            /*  Operating_Modes: Normal Operating Mode */
#define ENUM_SPI_DEVICE_CONFIG_SLEEP         0x00000003            /*  Operating_Modes: Low Power Mode */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_CHIP_TYPE                        Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_CHIP_TYPE_CHIP_TYPE          0            /*  Precision ADC */
#define BITM_SPI_CHIP_TYPE_CHIP_TYPE         0x0000000F    /*  Precision ADC */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_PRODUCT_ID_L                     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_PRODUCT_ID_L_PRODUCT_ID      0            /*  This is Device Chip Type/Family */
#define BITM_SPI_PRODUCT_ID_L_PRODUCT_ID     0x000000FF    /*  This is Device Chip Type/Family */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_PRODUCT_ID_H                     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_PRODUCT_ID_H_PRODUCT_ID      0            /*  This is Device Chip Type/Family */
#define BITM_SPI_PRODUCT_ID_H_PRODUCT_ID     0x000000FF    /*  This is Device Chip Type/Family */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_CHIP_GRADE                       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_CHIP_GRADE_GRADE             4            /*  This is the Device Performance Grade */
#define BITP_SPI_CHIP_GRADE_DEVICE_REVISION   0            /*  This is the Device Hardware Revision */
#define BITM_SPI_CHIP_GRADE_GRADE            0x000000F0    /*  This is the Device Performance Grade */
#define BITM_SPI_CHIP_GRADE_DEVICE_REVISION  0x0000000F    /*  This is the Device Hardware Revision */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_SCRATCH_PAD                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_SCRATCH_PAD_SCRATCH_VALUE    0            /*  Software Scratchpad */
#define BITM_SPI_SCRATCH_PAD_SCRATCH_VALUE   0x000000FF    /*  Software Scratchpad */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_SPI_REVISION                     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_SPI_REVISION_SPI_TYPE        6            /*  Always Reads as 0x2 */
#define BITP_SPI_SPI_REVISION_VERSION         0            /*  SPI Version */
#define BITM_SPI_SPI_REVISION_SPI_TYPE       0x000000C0    /*  Always Reads as 0x2 */
#define BITM_SPI_SPI_REVISION_VERSION        0x0000003F    /*  SPI Version */
#define ENUM_SPI_SPI_REVISION_ADI_SPI        0x00000000
#define ENUM_SPI_SPI_REVISION_LPT_SPI        0x00000080
#define ENUM_SPI_SPI_REVISION_REV1_0         0x00000002            /*  Version: Revision 1.0 */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_VENDOR_L                         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_VENDOR_L_VID                 0            /*  Analog Devices Vendor ID */
#define BITM_SPI_VENDOR_L_VID                0x000000FF    /*  Analog Devices Vendor ID */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_VENDOR_H                         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_VENDOR_H_VID                 0            /*  Analog Devices Vendor ID */
#define BITM_SPI_VENDOR_H_VID                0x000000FF    /*  Analog Devices Vendor ID */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_STREAM_MODE                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_STREAM_MODE_LOOP_COUNT       0            /*  Sets the Data Byte Count Before Looping to Start Address */
#define BITM_SPI_STREAM_MODE_LOOP_COUNT      0x000000FF    /*  Sets the Data Byte Count Before Looping to Start Address */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_TRANSFER_CONFIG                  Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_TRANSFER_CONFIG_STREAM_MODE  1            /*  When Streaming, Controls Master-Slave Transfer */
#define BITM_SPI_TRANSFER_CONFIG_STREAM_MODE 0x00000002    /*  When Streaming, Controls Master-Slave Transfer */
#define ENUM_SPI_TRANSFER_CONFIG_UPDATE_ON_WRITE 0x00000000            /*  Stream_Mode: Transfers after each byte/mulit-byte register */
#define ENUM_SPI_TRANSFER_CONFIG_UPDATE_ON_ADDRESS_LOOP 0x00000002            /*  Stream_Mode: Transfers when address loops */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_INTERFACE_CONFIG_C               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_INTERFACE_CONFIG_C_CRC_ENABLE  6            /*  CRC Enable */
#define BITP_SPI_INTERFACE_CONFIG_C_STRICT_REGISTER_ACCESS  5            /*  Multi-byte Registers Must Be Read/Written in Full */
#define BITP_SPI_INTERFACE_CONFIG_C_SEND_STATUS  4            /*  Enables Sending of Status in 4-wire Mode */
#define BITP_SPI_INTERFACE_CONFIG_C_CRC_ENABLEB  0            /*  Inverted CRC Enable */
#define BITM_SPI_INTERFACE_CONFIG_C_CRC_ENABLE 0x000000C0    /*  CRC Enable */
#define BITM_SPI_INTERFACE_CONFIG_C_STRICT_REGISTER_ACCESS 0x00000020    /*  Multi-byte Registers Must Be Read/Written in Full */
#define BITM_SPI_INTERFACE_CONFIG_C_SEND_STATUS 0x00000010    /*  Enables Sending of Status in 4-wire Mode */
#define BITM_SPI_INTERFACE_CONFIG_C_CRC_ENABLEB 0x00000003    /*  Inverted CRC Enable */
#define ENUM_SPI_INTERFACE_CONFIG_C_DISABLED 0x00000000            /*  CRC_Enable: CRC Disabled */
#define ENUM_SPI_INTERFACE_CONFIG_C_ENABLED  0x00000040            /*  CRC_Enable: CRC Enabled */
#define ENUM_SPI_INTERFACE_CONFIG_C_NORMAL_ACCESS 0x00000000            /*  Strict_Register_Access: Normal mode, no access restrictions */
#define ENUM_SPI_INTERFACE_CONFIG_C_STRICT_ACCESS 0x00000020            /*  Strict_Register_Access: Strict mode, multi-byte registers require all bytes read/written */

/* -------------------------------------------------------------------------------------------------------------------------
          SPI_INTERFACE_STATUS_A               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_SPI_INTERFACE_STATUS_A_NOT_READY_ERROR  7            /*  Device Not Ready for Transaction */
#define BITP_SPI_INTERFACE_STATUS_A_CLOCK_COUNT_ERROR  4            /*  Incorrect Number of Clocks Detected in a Transaction */
#define BITP_SPI_INTERFACE_STATUS_A_CRC_ERROR  3            /*  Invalid/No CRC Received */
#define BITP_SPI_INTERFACE_STATUS_A_WR_TO_RD_ONLY_REG_ERROR  2            /*  Write to Read-Only Register Attempted */
#define BITP_SPI_INTERFACE_STATUS_A_REGISTER_PARTIAL_ACCESS_ERROR  1            /*  Set When Fewer Than Expected Number of Bytes Read/Written */
#define BITP_SPI_INTERFACE_STATUS_A_ADDRESS_INVALID_ERROR  0            /*  Attempt to Read/Write Non-existent Register Address */
#define BITM_SPI_INTERFACE_STATUS_A_NOT_READY_ERROR 0x00000080    /*  Device Not Ready for Transaction */
#define BITM_SPI_INTERFACE_STATUS_A_CLOCK_COUNT_ERROR 0x00000010    /*  Incorrect Number of Clocks Detected in a Transaction */
#define BITM_SPI_INTERFACE_STATUS_A_CRC_ERROR 0x00000008    /*  Invalid/No CRC Received */
#define BITM_SPI_INTERFACE_STATUS_A_WR_TO_RD_ONLY_REG_ERROR 0x00000004    /*  Write to Read-Only Register Attempted */
#define BITM_SPI_INTERFACE_STATUS_A_REGISTER_PARTIAL_ACCESS_ERROR 0x00000002    /*  Set When Fewer Than Expected Number of Bytes Read/Written */
#define BITM_SPI_INTERFACE_STATUS_A_ADDRESS_INVALID_ERROR 0x00000001    /*  Attempt to Read/Write Non-existent Register Address */


/* ============================================================================================================================
        ADISENSE1000 Core Registers
   ============================================================================================================================ */

/* ============================================================================================================================
        CORE
   ============================================================================================================================ */
#define REG_CORE_COMMAND_RESET               0x00000000            /*      Reset Value for Command  */
#define REG_CORE_COMMAND                     0x00000014            /*  CORE Special Command */
#define REG_CORE_MODE_RESET                  0x00000000            /*      Reset Value for Mode  */
#define REG_CORE_MODE                        0x00000016            /*  CORE Operating Mode and DRDY Control */
#define REG_CORE_POWER_CONFIG_RESET          0x00000000            /*      Reset Value for Power_Config  */
#define REG_CORE_POWER_CONFIG                0x00000017            /*  CORE General Configuration */
#define REG_CORE_CYCLE_CONTROL_RESET         0x00000000            /*      Reset Value for Cycle_Control  */
#define REG_CORE_CYCLE_CONTROL               0x00000018            /*  CORE Measurement Cycle */
#define REG_CORE_STATUS_RESET                0x00000000            /*      Reset Value for Status  */
#define REG_CORE_STATUS                      0x00000020            /*  CORE General Status */
#define REG_CORE_DIAGNOSTICS_STATUS_RESET    0x00000000            /*      Reset Value for Diagnostics_Status  */
#define REG_CORE_DIAGNOSTICS_STATUS          0x00000024            /*  CORE Diagnostics Status */
#define REG_CORE_CHANNEL_ALERT_STATUS_RESET  0x00000000            /*      Reset Value for Channel_Alert_Status  */
#define REG_CORE_CHANNEL_ALERT_STATUS        0x00000026            /*  CORE Alert Status Summary */
#define REG_CORE_ALERT_STATUS_2_RESET        0x00000000            /*      Reset Value for Alert_Status_2  */
#define REG_CORE_ALERT_STATUS_2              0x00000028            /*  CORE Additional Alert Status Information */
#define REG_CORE_ALERT_DETAIL_CHn_RESET      0x00000000            /*      Reset Value for Alert_Detail_Ch[n]  */
#define REG_CORE_ALERT_DETAIL_CH0_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH0  */
#define REG_CORE_ALERT_DETAIL_CH1_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH1  */
#define REG_CORE_ALERT_DETAIL_CH2_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH2  */
#define REG_CORE_ALERT_DETAIL_CH3_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH3  */
#define REG_CORE_ALERT_DETAIL_CH4_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH4  */
#define REG_CORE_ALERT_DETAIL_CH5_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH5  */
#define REG_CORE_ALERT_DETAIL_CH6_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH6  */
#define REG_CORE_ALERT_DETAIL_CH7_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH7  */
#define REG_CORE_ALERT_DETAIL_CH8_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH8  */
#define REG_CORE_ALERT_DETAIL_CH9_RESET      0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH9  */
#define REG_CORE_ALERT_DETAIL_CH10_RESET     0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH10  */
#define REG_CORE_ALERT_DETAIL_CH11_RESET     0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH11  */
#define REG_CORE_ALERT_DETAIL_CH12_RESET     0x00000000            /*      Reset Value for REG_CORE_ALERT_DETAIL_CH12  */
#define REG_CORE_ALERT_DETAIL_CH0            0x0000002A            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH1            0x0000002C            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH2            0x0000002E            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH3            0x00000030            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH4            0x00000032            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH5            0x00000034            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH6            0x00000036            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH7            0x00000038            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH8            0x0000003A            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH9            0x0000003C            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH10           0x0000003E            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH11           0x00000040            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CH12           0x00000042            /*  CORE Detailed Error Information */
#define REG_CORE_ALERT_DETAIL_CHn(i)         (REG_CORE_ALERT_DETAIL_CH0 + ((i) * 2))
#define REG_CORE_ALERT_DETAIL_CHn_COUNT      13
#define REG_CORE_ERROR_CODE_RESET            0x00000000            /*      Reset Value for Error_Code  */
#define REG_CORE_ERROR_CODE                  0x0000004C            /*  CORE Code Indicating Source of Error */
#define REG_CORE_ALERT_CODE_RESET            0x00000000            /*      Reset Value for Alert_Code  */
#define REG_CORE_ALERT_CODE                  0x0000004E            /*  CORE Code Indicating Source of Alert */
#define REG_CORE_EXTERNAL_REFERENCE_RESISTOR_RESET 0x00000000            /*      Reset Value for External_Reference_Resistor  */
#define REG_CORE_EXTERNAL_REFERENCE_RESISTOR 0x00000050            /*  CORE External Reference Information */
#define REG_CORE_EXTERNAL_VOLTAGE_REFERENCE_RESET 0x00000000            /*      Reset Value for External_Voltage_Reference  */
#define REG_CORE_EXTERNAL_VOLTAGE_REFERENCE  0x00000054            /*  CORE External Reference Information */
#define REG_CORE_DIAGNOSTICS_CONTROL_RESET   0x00000000            /*      Reset Value for Diagnostics_Control  */
#define REG_CORE_DIAGNOSTICS_CONTROL         0x0000005C            /*  CORE Diagnostic Control */
#define REG_CORE_DATA_FIFO_RESET             0x00000000            /*      Reset Value for Data_FIFO  */
#define REG_CORE_DATA_FIFO                   0x00000060            /*  CORE FIFO Buffer of Sensor Results */
#define REG_CORE_DEBUG_CODE_RESET            0x00000000            /*      Reset Value for Debug_Code  */
#define REG_CORE_DEBUG_CODE                  0x00000064            /*  CORE Additional Information on Source of Alert or Errors */
#define REG_CORE_ADVANCED_SENSOR_ACCESS_RESET 0x00000000            /*      Reset Value for Advanced_Sensor_Access  */
#define REG_CORE_ADVANCED_SENSOR_ACCESS      0x0000006E            /*  CORE Enables Access to Advanced Sensor Configuration */
#define REG_CORE_LUT_SELECT_RESET            0x00000000            /*      Reset Value for LUT_Select  */
#define REG_CORE_LUT_SELECT                  0x00000070            /*  CORE Read/Write Strobe */
#define REG_CORE_LUT_OFFSET_RESET            0x00000000            /*      Reset Value for LUT_Offset  */
#define REG_CORE_LUT_OFFSET                  0x00000072            /*  CORE Offset into Selected LUT */
#define REG_CORE_LUT_DATA_RESET              0x00000000            /*      Reset Value for LUT_Data  */
#define REG_CORE_LUT_DATA                    0x00000074            /*  CORE Data to Read/Write from Addressed LUT Entry */
#define REG_CORE_REVISION_RESET              0x00000000            /*      Reset Value for Revision  */
#define REG_CORE_REVISION                    0x0000008C            /*  CORE Hardware, Firmware Revision */
#define REG_CORE_CHANNEL_COUNTn_RESET        0x00000000            /*      Reset Value for Channel_Count[n]  */
#define REG_CORE_CHANNEL_COUNT0_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT0  */
#define REG_CORE_CHANNEL_COUNT1_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT1  */
#define REG_CORE_CHANNEL_COUNT2_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT2  */
#define REG_CORE_CHANNEL_COUNT3_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT3  */
#define REG_CORE_CHANNEL_COUNT4_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT4  */
#define REG_CORE_CHANNEL_COUNT5_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT5  */
#define REG_CORE_CHANNEL_COUNT6_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT6  */
#define REG_CORE_CHANNEL_COUNT7_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT7  */
#define REG_CORE_CHANNEL_COUNT8_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT8  */
#define REG_CORE_CHANNEL_COUNT9_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT9  */
#define REG_CORE_CHANNEL_COUNT10_RESET       0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT10  */
#define REG_CORE_CHANNEL_COUNT11_RESET       0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT11  */
#define REG_CORE_CHANNEL_COUNT12_RESET       0x00000000            /*      Reset Value for REG_CORE_CHANNEL_COUNT12  */
#define REG_CORE_CHANNEL_COUNT0              0x00000090            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT1              0x000000D0            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT2              0x00000110            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT3              0x00000150            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT4              0x00000190            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT5              0x000001D0            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT6              0x00000210            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT7              0x00000250            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT8              0x00000290            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT9              0x000002D0            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT10             0x00000310            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT11             0x00000350            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNT12             0x00000390            /*  CORE Number of Channel Occurrences per Measurement Cycle */
#define REG_CORE_CHANNEL_COUNTn(i)           (REG_CORE_CHANNEL_COUNT0 + ((i) * 64))
#define REG_CORE_CHANNEL_COUNTn_COUNT        13
#define REG_CORE_CHANNEL_OPTIONSn_RESET      0x00000000            /*      Reset Value for Channel_Options[n]  */
#define REG_CORE_CHANNEL_OPTIONS0_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS0  */
#define REG_CORE_CHANNEL_OPTIONS1_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS1  */
#define REG_CORE_CHANNEL_OPTIONS2_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS2  */
#define REG_CORE_CHANNEL_OPTIONS3_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS3  */
#define REG_CORE_CHANNEL_OPTIONS4_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS4  */
#define REG_CORE_CHANNEL_OPTIONS5_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS5  */
#define REG_CORE_CHANNEL_OPTIONS6_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS6  */
#define REG_CORE_CHANNEL_OPTIONS7_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS7  */
#define REG_CORE_CHANNEL_OPTIONS8_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS8  */
#define REG_CORE_CHANNEL_OPTIONS9_RESET      0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS9  */
#define REG_CORE_CHANNEL_OPTIONS10_RESET     0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS10  */
#define REG_CORE_CHANNEL_OPTIONS11_RESET     0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS11  */
#define REG_CORE_CHANNEL_OPTIONS12_RESET     0x00000000            /*      Reset Value for REG_CORE_CHANNEL_OPTIONS12  */
#define REG_CORE_CHANNEL_OPTIONS0            0x00000091            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS1            0x000000D1            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS2            0x00000111            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS3            0x00000151            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS4            0x00000191            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS5            0x000001D1            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS6            0x00000211            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS7            0x00000251            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS8            0x00000291            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS9            0x000002D1            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS10           0x00000311            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS11           0x00000351            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONS12           0x00000391            /*  CORE Position of Channel Within Sequence and Enable for FFT */
#define REG_CORE_CHANNEL_OPTIONSn(i)         (REG_CORE_CHANNEL_OPTIONS0 + ((i) * 64))
#define REG_CORE_CHANNEL_OPTIONSn_COUNT      13
#define REG_CORE_SENSOR_TYPEn_RESET          0x00000000            /*      Reset Value for Sensor_Type[n]  */
#define REG_CORE_SENSOR_TYPE0_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE0  */
#define REG_CORE_SENSOR_TYPE1_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE1  */
#define REG_CORE_SENSOR_TYPE2_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE2  */
#define REG_CORE_SENSOR_TYPE3_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE3  */
#define REG_CORE_SENSOR_TYPE4_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE4  */
#define REG_CORE_SENSOR_TYPE5_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE5  */
#define REG_CORE_SENSOR_TYPE6_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE6  */
#define REG_CORE_SENSOR_TYPE7_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE7  */
#define REG_CORE_SENSOR_TYPE8_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE8  */
#define REG_CORE_SENSOR_TYPE9_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE9  */
#define REG_CORE_SENSOR_TYPE10_RESET         0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE10  */
#define REG_CORE_SENSOR_TYPE11_RESET         0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE11  */
#define REG_CORE_SENSOR_TYPE12_RESET         0x00000000            /*      Reset Value for REG_CORE_SENSOR_TYPE12  */
#define REG_CORE_SENSOR_TYPE0                0x00000092            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE1                0x000000D2            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE2                0x00000112            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE3                0x00000152            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE4                0x00000192            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE5                0x000001D2            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE6                0x00000212            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE7                0x00000252            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE8                0x00000292            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE9                0x000002D2            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE10               0x00000312            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE11               0x00000352            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPE12               0x00000392            /*  CORE Sensor Select */
#define REG_CORE_SENSOR_TYPEn(i)             (REG_CORE_SENSOR_TYPE0 + ((i) * 64))
#define REG_CORE_SENSOR_TYPEn_COUNT          13
#define REG_CORE_SENSOR_DETAILSn_RESET       0x000000F0            /*      Reset Value for Sensor_Details[n]  */
#define REG_CORE_SENSOR_DETAILS0_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS0  */
#define REG_CORE_SENSOR_DETAILS1_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS1  */
#define REG_CORE_SENSOR_DETAILS2_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS2  */
#define REG_CORE_SENSOR_DETAILS3_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS3  */
#define REG_CORE_SENSOR_DETAILS4_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS4  */
#define REG_CORE_SENSOR_DETAILS5_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS5  */
#define REG_CORE_SENSOR_DETAILS6_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS6  */
#define REG_CORE_SENSOR_DETAILS7_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS7  */
#define REG_CORE_SENSOR_DETAILS8_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS8  */
#define REG_CORE_SENSOR_DETAILS9_RESET       0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS9  */
#define REG_CORE_SENSOR_DETAILS10_RESET      0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS10  */
#define REG_CORE_SENSOR_DETAILS11_RESET      0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS11  */
#define REG_CORE_SENSOR_DETAILS12_RESET      0x000000F0            /*      Reset Value for REG_CORE_SENSOR_DETAILS12  */
#define REG_CORE_SENSOR_DETAILS0             0x00000094            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS1             0x000000D4            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS2             0x00000114            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS3             0x00000154            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS4             0x00000194            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS5             0x000001D4            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS6             0x00000214            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS7             0x00000254            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS8             0x00000294            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS9             0x000002D4            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS10            0x00000314            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS11            0x00000354            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILS12            0x00000394            /*  CORE Sensor Details */
#define REG_CORE_SENSOR_DETAILSn(i)          (REG_CORE_SENSOR_DETAILS0 + ((i) * 64))
#define REG_CORE_SENSOR_DETAILSn_COUNT       13
#define REG_CORE_CHANNEL_EXCITATIONn_RESET   0x00000000            /*      Reset Value for Channel_Excitation[n]  */
#define REG_CORE_CHANNEL_EXCITATION0_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION0  */
#define REG_CORE_CHANNEL_EXCITATION1_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION1  */
#define REG_CORE_CHANNEL_EXCITATION2_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION2  */
#define REG_CORE_CHANNEL_EXCITATION3_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION3  */
#define REG_CORE_CHANNEL_EXCITATION4_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION4  */
#define REG_CORE_CHANNEL_EXCITATION5_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION5  */
#define REG_CORE_CHANNEL_EXCITATION6_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION6  */
#define REG_CORE_CHANNEL_EXCITATION7_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION7  */
#define REG_CORE_CHANNEL_EXCITATION8_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION8  */
#define REG_CORE_CHANNEL_EXCITATION9_RESET   0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION9  */
#define REG_CORE_CHANNEL_EXCITATION10_RESET  0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION10  */
#define REG_CORE_CHANNEL_EXCITATION11_RESET  0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION11  */
#define REG_CORE_CHANNEL_EXCITATION12_RESET  0x00000000            /*      Reset Value for REG_CORE_CHANNEL_EXCITATION12  */
#define REG_CORE_CHANNEL_EXCITATION0         0x00000098            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION1         0x000000D8            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION2         0x00000118            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION3         0x00000158            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION4         0x00000198            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION5         0x000001D8            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION6         0x00000218            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION7         0x00000258            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION8         0x00000298            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION9         0x000002D8            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION10        0x00000318            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION11        0x00000358            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATION12        0x00000398            /*  CORE Excitation Current */
#define REG_CORE_CHANNEL_EXCITATIONn(i)      (REG_CORE_CHANNEL_EXCITATION0 + ((i) * 64))
#define REG_CORE_CHANNEL_EXCITATIONn_COUNT   13
#define REG_CORE_SETTLING_TIMEn_RESET        0x00000000            /*      Reset Value for Settling_Time[n]  */
#define REG_CORE_SETTLING_TIME0_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME0  */
#define REG_CORE_SETTLING_TIME1_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME1  */
#define REG_CORE_SETTLING_TIME2_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME2  */
#define REG_CORE_SETTLING_TIME3_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME3  */
#define REG_CORE_SETTLING_TIME4_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME4  */
#define REG_CORE_SETTLING_TIME5_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME5  */
#define REG_CORE_SETTLING_TIME6_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME6  */
#define REG_CORE_SETTLING_TIME7_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME7  */
#define REG_CORE_SETTLING_TIME8_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME8  */
#define REG_CORE_SETTLING_TIME9_RESET        0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME9  */
#define REG_CORE_SETTLING_TIME10_RESET       0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME10  */
#define REG_CORE_SETTLING_TIME11_RESET       0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME11  */
#define REG_CORE_SETTLING_TIME12_RESET       0x00000000            /*      Reset Value for REG_CORE_SETTLING_TIME12  */
#define REG_CORE_SETTLING_TIME0              0x0000009A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME1              0x000000DA            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME2              0x0000011A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME3              0x0000015A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME4              0x0000019A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME5              0x000001DA            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME6              0x0000021A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME7              0x0000025A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME8              0x0000029A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME9              0x000002DA            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME10             0x0000031A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME11             0x0000035A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIME12             0x0000039A            /*  CORE Settling Time */
#define REG_CORE_SETTLING_TIMEn(i)           (REG_CORE_SETTLING_TIME0 + ((i) * 64))
#define REG_CORE_SETTLING_TIMEn_COUNT        13
#define REG_CORE_MEASUREMENT_SETUPn_RESET    0x00000000            /*      Reset Value for Measurement_Setup[n]  */
#define REG_CORE_MEASUREMENT_SETUP0_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP0  */
#define REG_CORE_MEASUREMENT_SETUP1_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP1  */
#define REG_CORE_MEASUREMENT_SETUP2_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP2  */
#define REG_CORE_MEASUREMENT_SETUP3_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP3  */
#define REG_CORE_MEASUREMENT_SETUP4_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP4  */
#define REG_CORE_MEASUREMENT_SETUP5_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP5  */
#define REG_CORE_MEASUREMENT_SETUP6_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP6  */
#define REG_CORE_MEASUREMENT_SETUP7_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP7  */
#define REG_CORE_MEASUREMENT_SETUP8_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP8  */
#define REG_CORE_MEASUREMENT_SETUP9_RESET    0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP9  */
#define REG_CORE_MEASUREMENT_SETUP10_RESET   0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP10  */
#define REG_CORE_MEASUREMENT_SETUP11_RESET   0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP11  */
#define REG_CORE_MEASUREMENT_SETUP12_RESET   0x00000000            /*      Reset Value for REG_CORE_MEASUREMENT_SETUP12  */
#define REG_CORE_MEASUREMENT_SETUP0          0x0000009C            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP1          0x000000DC            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP2          0x0000011C            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP3          0x0000015C            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP4          0x0000019C            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP5          0x000001DC            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP6          0x0000021C            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP7          0x0000025C            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP8          0x0000029C            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP9          0x000002DC            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP10         0x0000031C            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP11         0x0000035C            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUP12         0x0000039C            /*  CORE ADC Digital Filter Selection */
#define REG_CORE_MEASUREMENT_SETUPn(i)       (REG_CORE_MEASUREMENT_SETUP0 + ((i) * 64))
#define REG_CORE_MEASUREMENT_SETUPn_COUNT    13
#define REG_CORE_HIGH_THRESHOLD_LIMITn_RESET 0x00000000            /*      Reset Value for High_Threshold_Limit[n]  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT0_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT0  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT1_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT1  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT2_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT2  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT3_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT3  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT4_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT4  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT5_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT5  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT6_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT6  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT7_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT7  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT8_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT8  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT9_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT9  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT10_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT10  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT11_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT11  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT12_RESET 0x00000000            /*      Reset Value for REG_CORE_HIGH_THRESHOLD_LIMIT12  */
#define REG_CORE_HIGH_THRESHOLD_LIMIT0       0x000000A0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT1       0x000000E0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT2       0x00000120            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT3       0x00000160            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT4       0x000001A0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT5       0x000001E0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT6       0x00000220            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT7       0x00000260            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT8       0x000002A0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT9       0x000002E0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT10      0x00000320            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT11      0x00000360            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMIT12      0x000003A0            /*  CORE High Threshold */
#define REG_CORE_HIGH_THRESHOLD_LIMITn(i)    (REG_CORE_HIGH_THRESHOLD_LIMIT0 + ((i) * 64))
#define REG_CORE_HIGH_THRESHOLD_LIMITn_COUNT 13
#define REG_CORE_LOW_THRESHOLD_LIMITn_RESET  0x00000000            /*      Reset Value for Low_Threshold_Limit[n]  */
#define REG_CORE_LOW_THRESHOLD_LIMIT0_RESET  0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT0  */
#define REG_CORE_LOW_THRESHOLD_LIMIT1_RESET  0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT1  */
#define REG_CORE_LOW_THRESHOLD_LIMIT2_RESET  0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT2  */
#define REG_CORE_LOW_THRESHOLD_LIMIT3_RESET  0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT3  */
#define REG_CORE_LOW_THRESHOLD_LIMIT4_RESET  0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT4  */
#define REG_CORE_LOW_THRESHOLD_LIMIT5_RESET  0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT5  */
#define REG_CORE_LOW_THRESHOLD_LIMIT6_RESET  0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT6  */
#define REG_CORE_LOW_THRESHOLD_LIMIT7_RESET  0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT7  */
#define REG_CORE_LOW_THRESHOLD_LIMIT8_RESET  0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT8  */
#define REG_CORE_LOW_THRESHOLD_LIMIT9_RESET  0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT9  */
#define REG_CORE_LOW_THRESHOLD_LIMIT10_RESET 0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT10  */
#define REG_CORE_LOW_THRESHOLD_LIMIT11_RESET 0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT11  */
#define REG_CORE_LOW_THRESHOLD_LIMIT12_RESET 0x00000000            /*      Reset Value for REG_CORE_LOW_THRESHOLD_LIMIT12  */
#define REG_CORE_LOW_THRESHOLD_LIMIT0        0x000000A4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT1        0x000000E4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT2        0x00000124            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT3        0x00000164            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT4        0x000001A4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT5        0x000001E4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT6        0x00000224            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT7        0x00000264            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT8        0x000002A4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT9        0x000002E4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT10       0x00000324            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT11       0x00000364            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMIT12       0x000003A4            /*  CORE Low Threshold */
#define REG_CORE_LOW_THRESHOLD_LIMITn(i)     (REG_CORE_LOW_THRESHOLD_LIMIT0 + ((i) * 64))
#define REG_CORE_LOW_THRESHOLD_LIMITn_COUNT  13
#define REG_CORE_SENSOR_OFFSETn_RESET        0x00000000            /*      Reset Value for Sensor_Offset[n]  */
#define REG_CORE_SENSOR_OFFSET0_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET0  */
#define REG_CORE_SENSOR_OFFSET1_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET1  */
#define REG_CORE_SENSOR_OFFSET2_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET2  */
#define REG_CORE_SENSOR_OFFSET3_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET3  */
#define REG_CORE_SENSOR_OFFSET4_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET4  */
#define REG_CORE_SENSOR_OFFSET5_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET5  */
#define REG_CORE_SENSOR_OFFSET6_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET6  */
#define REG_CORE_SENSOR_OFFSET7_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET7  */
#define REG_CORE_SENSOR_OFFSET8_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET8  */
#define REG_CORE_SENSOR_OFFSET9_RESET        0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET9  */
#define REG_CORE_SENSOR_OFFSET10_RESET       0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET10  */
#define REG_CORE_SENSOR_OFFSET11_RESET       0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET11  */
#define REG_CORE_SENSOR_OFFSET12_RESET       0x00000000            /*      Reset Value for REG_CORE_SENSOR_OFFSET12  */
#define REG_CORE_SENSOR_OFFSET0              0x000000A8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET1              0x000000E8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET2              0x00000128            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET3              0x00000168            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET4              0x000001A8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET5              0x000001E8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET6              0x00000228            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET7              0x00000268            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET8              0x000002A8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET9              0x000002E8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET10             0x00000328            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET11             0x00000368            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSET12             0x000003A8            /*  CORE Sensor Offset Adjustment */
#define REG_CORE_SENSOR_OFFSETn(i)           (REG_CORE_SENSOR_OFFSET0 + ((i) * 64))
#define REG_CORE_SENSOR_OFFSETn_COUNT        13
#define REG_CORE_SENSOR_GAINn_RESET          0x00000000            /*      Reset Value for Sensor_Gain[n]  */
#define REG_CORE_SENSOR_GAIN0_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN0  */
#define REG_CORE_SENSOR_GAIN1_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN1  */
#define REG_CORE_SENSOR_GAIN2_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN2  */
#define REG_CORE_SENSOR_GAIN3_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN3  */
#define REG_CORE_SENSOR_GAIN4_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN4  */
#define REG_CORE_SENSOR_GAIN5_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN5  */
#define REG_CORE_SENSOR_GAIN6_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN6  */
#define REG_CORE_SENSOR_GAIN7_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN7  */
#define REG_CORE_SENSOR_GAIN8_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN8  */
#define REG_CORE_SENSOR_GAIN9_RESET          0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN9  */
#define REG_CORE_SENSOR_GAIN10_RESET         0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN10  */
#define REG_CORE_SENSOR_GAIN11_RESET         0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN11  */
#define REG_CORE_SENSOR_GAIN12_RESET         0x00000000            /*      Reset Value for REG_CORE_SENSOR_GAIN12  */
#define REG_CORE_SENSOR_GAIN0                0x000000AC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN1                0x000000EC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN2                0x0000012C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN3                0x0000016C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN4                0x000001AC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN5                0x000001EC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN6                0x0000022C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN7                0x0000026C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN8                0x000002AC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN9                0x000002EC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN10               0x0000032C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN11               0x0000036C            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAIN12               0x000003AC            /*  CORE Sensor Gain Adjustment */
#define REG_CORE_SENSOR_GAINn(i)             (REG_CORE_SENSOR_GAIN0 + ((i) * 64))
#define REG_CORE_SENSOR_GAINn_COUNT          13
#define REG_CORE_ALERT_CODE_CHn_RESET        0x00000000            /*      Reset Value for Alert_Code_Ch[n]  */
#define REG_CORE_ALERT_CODE_CH0_RESET        0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH0  */
#define REG_CORE_ALERT_CODE_CH1_RESET        0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH1  */
#define REG_CORE_ALERT_CODE_CH2_RESET        0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH2  */
#define REG_CORE_ALERT_CODE_CH3_RESET        0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH3  */
#define REG_CORE_ALERT_CODE_CH4_RESET        0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH4  */
#define REG_CORE_ALERT_CODE_CH5_RESET        0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH5  */
#define REG_CORE_ALERT_CODE_CH6_RESET        0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH6  */
#define REG_CORE_ALERT_CODE_CH7_RESET        0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH7  */
#define REG_CORE_ALERT_CODE_CH8_RESET        0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH8  */
#define REG_CORE_ALERT_CODE_CH9_RESET        0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH9  */
#define REG_CORE_ALERT_CODE_CH10_RESET       0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH10  */
#define REG_CORE_ALERT_CODE_CH11_RESET       0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH11  */
#define REG_CORE_ALERT_CODE_CH12_RESET       0x00000000            /*      Reset Value for REG_CORE_ALERT_CODE_CH12  */
#define REG_CORE_ALERT_CODE_CH0              0x000000B0            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH1              0x000000F0            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH2              0x00000130            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH3              0x00000170            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH4              0x000001B0            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH5              0x000001F0            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH6              0x00000230            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH7              0x00000270            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH8              0x000002B0            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH9              0x000002F0            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH10             0x00000330            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH11             0x00000370            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CH12             0x000003B0            /*  CORE Per-Channel Detailed Alert-Code Information */
#define REG_CORE_ALERT_CODE_CHn(i)           (REG_CORE_ALERT_CODE_CH0 + ((i) * 64))
#define REG_CORE_ALERT_CODE_CHn_COUNT        13
#define REG_CORE_CHANNEL_SKIPn_RESET         0x00000000            /*      Reset Value for Channel_Skip[n]  */
#define REG_CORE_CHANNEL_SKIP0_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP0  */
#define REG_CORE_CHANNEL_SKIP1_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP1  */
#define REG_CORE_CHANNEL_SKIP2_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP2  */
#define REG_CORE_CHANNEL_SKIP3_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP3  */
#define REG_CORE_CHANNEL_SKIP4_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP4  */
#define REG_CORE_CHANNEL_SKIP5_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP5  */
#define REG_CORE_CHANNEL_SKIP6_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP6  */
#define REG_CORE_CHANNEL_SKIP7_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP7  */
#define REG_CORE_CHANNEL_SKIP8_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP8  */
#define REG_CORE_CHANNEL_SKIP9_RESET         0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP9  */
#define REG_CORE_CHANNEL_SKIP10_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP10  */
#define REG_CORE_CHANNEL_SKIP11_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP11  */
#define REG_CORE_CHANNEL_SKIP12_RESET        0x00000000            /*      Reset Value for REG_CORE_CHANNEL_SKIP12  */
#define REG_CORE_CHANNEL_SKIP0               0x000000B2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP1               0x000000F2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP2               0x00000132            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP3               0x00000172            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP4               0x000001B2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP5               0x000001F2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP6               0x00000232            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP7               0x00000272            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP8               0x000002B2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP9               0x000002F2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP10              0x00000332            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP11              0x00000372            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIP12              0x000003B2            /*  CORE Indicates If Channel Will Skip Some Measurement Cycles */
#define REG_CORE_CHANNEL_SKIPn(i)            (REG_CORE_CHANNEL_SKIP0 + ((i) * 64))
#define REG_CORE_CHANNEL_SKIPn_COUNT         13
#define REG_CORE_SENSOR_PARAMETERn_RESET     0x00000000            /*      Reset Value for Sensor_Parameter[n]  */
#define REG_CORE_SENSOR_PARAMETER0_RESET     0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER0  */
#define REG_CORE_SENSOR_PARAMETER1_RESET     0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER1  */
#define REG_CORE_SENSOR_PARAMETER2_RESET     0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER2  */
#define REG_CORE_SENSOR_PARAMETER3_RESET     0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER3  */
#define REG_CORE_SENSOR_PARAMETER4_RESET     0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER4  */
#define REG_CORE_SENSOR_PARAMETER5_RESET     0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER5  */
#define REG_CORE_SENSOR_PARAMETER6_RESET     0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER6  */
#define REG_CORE_SENSOR_PARAMETER7_RESET     0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER7  */
#define REG_CORE_SENSOR_PARAMETER8_RESET     0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER8  */
#define REG_CORE_SENSOR_PARAMETER9_RESET     0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER9  */
#define REG_CORE_SENSOR_PARAMETER10_RESET    0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER10  */
#define REG_CORE_SENSOR_PARAMETER11_RESET    0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER11  */
#define REG_CORE_SENSOR_PARAMETER12_RESET    0x00000000            /*      Reset Value for REG_CORE_SENSOR_PARAMETER12  */
#define REG_CORE_SENSOR_PARAMETER0           0x000000B4            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER1           0x000000F4            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER2           0x00000134            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER3           0x00000174            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER4           0x000001B4            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER5           0x000001F4            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER6           0x00000234            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER7           0x00000274            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER8           0x000002B4            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER9           0x000002F4            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER10          0x00000334            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER11          0x00000374            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETER12          0x000003B4            /*  CORE Sensor Parameter Adjustment */
#define REG_CORE_SENSOR_PARAMETERn(i)        (REG_CORE_SENSOR_PARAMETER0 + ((i) * 64))
#define REG_CORE_SENSOR_PARAMETERn_COUNT     13
#define REG_CORE_CALIBRATION_PARAMETERn_RESET 0x00000000            /*      Reset Value for Calibration_Parameter[n]  */
#define REG_CORE_CALIBRATION_PARAMETER0_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER0  */
#define REG_CORE_CALIBRATION_PARAMETER1_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER1  */
#define REG_CORE_CALIBRATION_PARAMETER2_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER2  */
#define REG_CORE_CALIBRATION_PARAMETER3_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER3  */
#define REG_CORE_CALIBRATION_PARAMETER4_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER4  */
#define REG_CORE_CALIBRATION_PARAMETER5_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER5  */
#define REG_CORE_CALIBRATION_PARAMETER6_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER6  */
#define REG_CORE_CALIBRATION_PARAMETER7_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER7  */
#define REG_CORE_CALIBRATION_PARAMETER8_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER8  */
#define REG_CORE_CALIBRATION_PARAMETER9_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER9  */
#define REG_CORE_CALIBRATION_PARAMETER10_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER10  */
#define REG_CORE_CALIBRATION_PARAMETER11_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER11  */
#define REG_CORE_CALIBRATION_PARAMETER12_RESET 0x00000000            /*      Reset Value for REG_CORE_CALIBRATION_PARAMETER12  */
#define REG_CORE_CALIBRATION_PARAMETER0      0x000000B8            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER1      0x000000F8            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER2      0x00000138            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER3      0x00000178            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER4      0x000001B8            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER5      0x000001F8            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER6      0x00000238            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER7      0x00000278            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER8      0x000002B8            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER9      0x000002F8            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER10     0x00000338            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER11     0x00000378            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETER12     0x000003B8            /*  CORE Calibration Parameter Value */
#define REG_CORE_CALIBRATION_PARAMETERn(i)   (REG_CORE_CALIBRATION_PARAMETER0 + ((i) * 64))
#define REG_CORE_CALIBRATION_PARAMETERn_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_CONFIGn_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Config[n]  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG0_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG0  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG1_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG1  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG2_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG2  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG3_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG3  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG4_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG4  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG5_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG5  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG6_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG6  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG7_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG7  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG8_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG8  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG9_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG9  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG10_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG10  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG11_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG11  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG12_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_CONFIG12  */
#define REG_CORE_DIGITAL_SENSOR_CONFIG0      0x000000BC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG1      0x000000FC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG2      0x0000013C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG3      0x0000017C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG4      0x000001BC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG5      0x000001FC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG6      0x0000023C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG7      0x0000027C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG8      0x000002BC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG9      0x000002FC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG10     0x0000033C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG11     0x0000037C            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIG12     0x000003BC            /*  CORE Digital Sensor Data Coding */
#define REG_CORE_DIGITAL_SENSOR_CONFIGn(i)   (REG_CORE_DIGITAL_SENSOR_CONFIG0 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_CONFIGn_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_ADDRESSn_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Address[n]  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS0_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS0  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS1_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS1  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS2_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS2  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS3_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS3  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS4_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS4  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS5_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS5  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS6_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS6  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS7_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS7  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS8_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS8  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS9_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS9  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS10_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS10  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS11_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS11  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS12_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_ADDRESS12  */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS0     0x000000BE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS1     0x000000FE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS2     0x0000013E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS3     0x0000017E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS4     0x000001BE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS5     0x000001FE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS6     0x0000023E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS7     0x0000027E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS8     0x000002BE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS9     0x000002FE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS10    0x0000033E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS11    0x0000037E            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESS12    0x000003BE            /*  CORE Sensor Address */
#define REG_CORE_DIGITAL_SENSOR_ADDRESSn(i)  (REG_CORE_DIGITAL_SENSOR_ADDRESS0 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_ADDRESSn_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDSn_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Num_Cmds[n]  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS0_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS0  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS1_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS1  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS2_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS2  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS3_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS3  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS4_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS4  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS5_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS5  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS6_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS6  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS7_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS7  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS8_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS8  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS9_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS9  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS10_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS10  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS11_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS11  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS12_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_NUM_CMDS12  */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS0    0x000000BF            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS1    0x000000FF            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS2    0x0000013F            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS3    0x0000017F            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS4    0x000001BF            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS5    0x000001FF            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS6    0x0000023F            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS7    0x0000027F            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS8    0x000002BF            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS9    0x000002FF            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS10   0x0000033F            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS11   0x0000037F            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDS12   0x000003BF            /*  CORE Number of Configuration, Read Commands for Digital Sensors */
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDSn(i) (REG_CORE_DIGITAL_SENSOR_NUM_CMDS0 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_NUM_CMDSn_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_COMMSn_RESET 0x00000006            /*      Reset Value for Digital_Sensor_Comms[n]  */
#define REG_CORE_DIGITAL_SENSOR_COMMS0_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS0  */
#define REG_CORE_DIGITAL_SENSOR_COMMS1_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS1  */
#define REG_CORE_DIGITAL_SENSOR_COMMS2_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS2  */
#define REG_CORE_DIGITAL_SENSOR_COMMS3_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS3  */
#define REG_CORE_DIGITAL_SENSOR_COMMS4_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS4  */
#define REG_CORE_DIGITAL_SENSOR_COMMS5_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS5  */
#define REG_CORE_DIGITAL_SENSOR_COMMS6_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS6  */
#define REG_CORE_DIGITAL_SENSOR_COMMS7_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS7  */
#define REG_CORE_DIGITAL_SENSOR_COMMS8_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS8  */
#define REG_CORE_DIGITAL_SENSOR_COMMS9_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS9  */
#define REG_CORE_DIGITAL_SENSOR_COMMS10_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS10  */
#define REG_CORE_DIGITAL_SENSOR_COMMS11_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS11  */
#define REG_CORE_DIGITAL_SENSOR_COMMS12_RESET 0x00000006            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMS12  */
#define REG_CORE_DIGITAL_SENSOR_COMMS0       0x000000C0            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS1       0x00000100            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS2       0x00000140            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS3       0x00000180            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS4       0x000001C0            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS5       0x00000200            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS6       0x00000240            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS7       0x00000280            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS8       0x000002C0            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS9       0x00000300            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS10      0x00000340            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS11      0x00000380            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMS12      0x000003C0            /*  CORE Digital Sensor Communication Clock Configuration */
#define REG_CORE_DIGITAL_SENSOR_COMMSn(i)    (REG_CORE_DIGITAL_SENSOR_COMMS0 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_COMMSn_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_COMMAND1n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command1[n]  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND10_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND10  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND11_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND11  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND12_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND12  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND13_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND13  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND14_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND14  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND15_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND15  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND16_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND16  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND17_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND17  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND18_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND18  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND19_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND19  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND110_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND110  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND111_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND111  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND112_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND112  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND10    0x000000C2            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND11    0x00000102            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND12    0x00000142            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND13    0x00000182            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND14    0x000001C2            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND15    0x00000202            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND16    0x00000242            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND17    0x00000282            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND18    0x000002C2            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND19    0x00000302            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND110   0x00000342            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND111   0x00000382            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND112   0x000003C2            /*  CORE Sensor Configuration Command1 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND1n(i) (REG_CORE_DIGITAL_SENSOR_COMMAND10 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_COMMAND1n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_COMMAND2n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command2[n]  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND20_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND20  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND21_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND21  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND22_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND22  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND23_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND23  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND24_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND24  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND25_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND25  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND26_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND26  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND27_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND27  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND28_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND28  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND29_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND29  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND210_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND210  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND211_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND211  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND212_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND212  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND20    0x000000C3            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND21    0x00000103            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND22    0x00000143            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND23    0x00000183            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND24    0x000001C3            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND25    0x00000203            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND26    0x00000243            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND27    0x00000283            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND28    0x000002C3            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND29    0x00000303            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND210   0x00000343            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND211   0x00000383            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND212   0x000003C3            /*  CORE Sensor Configuration Command2 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND2n(i) (REG_CORE_DIGITAL_SENSOR_COMMAND20 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_COMMAND2n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_COMMAND3n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command3[n]  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND30_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND30  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND31_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND31  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND32_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND32  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND33_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND33  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND34_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND34  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND35_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND35  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND36_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND36  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND37_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND37  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND38_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND38  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND39_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND39  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND310_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND310  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND311_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND311  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND312_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND312  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND30    0x000000C4            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND31    0x00000104            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND32    0x00000144            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND33    0x00000184            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND34    0x000001C4            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND35    0x00000204            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND36    0x00000244            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND37    0x00000284            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND38    0x000002C4            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND39    0x00000304            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND310   0x00000344            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND311   0x00000384            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND312   0x000003C4            /*  CORE Sensor Configuration Command3 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND3n(i) (REG_CORE_DIGITAL_SENSOR_COMMAND30 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_COMMAND3n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_COMMAND4n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command4[n]  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND40_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND40  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND41_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND41  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND42_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND42  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND43_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND43  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND44_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND44  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND45_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND45  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND46_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND46  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND47_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND47  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND48_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND48  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND49_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND49  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND410_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND410  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND411_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND411  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND412_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND412  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND40    0x000000C5            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND41    0x00000105            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND42    0x00000145            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND43    0x00000185            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND44    0x000001C5            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND45    0x00000205            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND46    0x00000245            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND47    0x00000285            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND48    0x000002C5            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND49    0x00000305            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND410   0x00000345            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND411   0x00000385            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND412   0x000003C5            /*  CORE Sensor Configuration Command4 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND4n(i) (REG_CORE_DIGITAL_SENSOR_COMMAND40 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_COMMAND4n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_COMMAND5n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command5[n]  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND50_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND50  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND51_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND51  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND52_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND52  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND53_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND53  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND54_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND54  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND55_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND55  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND56_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND56  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND57_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND57  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND58_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND58  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND59_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND59  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND510_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND510  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND511_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND511  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND512_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND512  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND50    0x000000C6            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND51    0x00000106            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND52    0x00000146            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND53    0x00000186            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND54    0x000001C6            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND55    0x00000206            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND56    0x00000246            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND57    0x00000286            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND58    0x000002C6            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND59    0x00000306            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND510   0x00000346            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND511   0x00000386            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND512   0x000003C6            /*  CORE Sensor Configuration Command5 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND5n(i) (REG_CORE_DIGITAL_SENSOR_COMMAND50 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_COMMAND5n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_COMMAND6n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command6[n]  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND60_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND60  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND61_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND61  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND62_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND62  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND63_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND63  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND64_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND64  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND65_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND65  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND66_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND66  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND67_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND67  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND68_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND68  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND69_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND69  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND610_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND610  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND611_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND611  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND612_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND612  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND60    0x000000C7            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND61    0x00000107            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND62    0x00000147            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND63    0x00000187            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND64    0x000001C7            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND65    0x00000207            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND66    0x00000247            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND67    0x00000287            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND68    0x000002C7            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND69    0x00000307            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND610   0x00000347            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND611   0x00000387            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND612   0x000003C7            /*  CORE Sensor Configuration Command6 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND6n(i) (REG_CORE_DIGITAL_SENSOR_COMMAND60 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_COMMAND6n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_COMMAND7n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Command7[n]  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND70_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND70  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND71_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND71  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND72_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND72  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND73_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND73  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND74_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND74  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND75_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND75  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND76_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND76  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND77_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND77  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND78_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND78  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND79_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND79  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND710_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND710  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND711_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND711  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND712_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_COMMAND712  */
#define REG_CORE_DIGITAL_SENSOR_COMMAND70    0x000000C8            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND71    0x00000108            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND72    0x00000148            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND73    0x00000188            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND74    0x000001C8            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND75    0x00000208            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND76    0x00000248            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND77    0x00000288            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND78    0x000002C8            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND79    0x00000308            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND710   0x00000348            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND711   0x00000388            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND712   0x000003C8            /*  CORE Sensor Configuration Command7 */
#define REG_CORE_DIGITAL_SENSOR_COMMAND7n(i) (REG_CORE_DIGITAL_SENSOR_COMMAND70 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_COMMAND7n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_READ_CMD1n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd1[n]  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD10_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD10  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD11_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD11  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD12_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD12  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD13_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD13  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD14_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD14  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD15_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD15  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD16_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD16  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD17_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD17  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD18_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD18  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD19_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD19  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD110_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD110  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD111_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD111  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD112_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD112  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD10   0x000000C9            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD11   0x00000109            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD12   0x00000149            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD13   0x00000189            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD14   0x000001C9            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD15   0x00000209            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD16   0x00000249            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD17   0x00000289            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD18   0x000002C9            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD19   0x00000309            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD110  0x00000349            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD111  0x00000389            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD112  0x000003C9            /*  CORE Sensor Read Command1 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD1n(i) (REG_CORE_DIGITAL_SENSOR_READ_CMD10 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_READ_CMD1n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_READ_CMD2n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd2[n]  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD20_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD20  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD21_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD21  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD22_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD22  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD23_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD23  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD24_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD24  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD25_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD25  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD26_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD26  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD27_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD27  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD28_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD28  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD29_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD29  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD210_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD210  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD211_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD211  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD212_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD212  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD20   0x000000CA            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD21   0x0000010A            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD22   0x0000014A            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD23   0x0000018A            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD24   0x000001CA            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD25   0x0000020A            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD26   0x0000024A            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD27   0x0000028A            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD28   0x000002CA            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD29   0x0000030A            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD210  0x0000034A            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD211  0x0000038A            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD212  0x000003CA            /*  CORE Sensor Read Command2 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD2n(i) (REG_CORE_DIGITAL_SENSOR_READ_CMD20 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_READ_CMD2n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_READ_CMD3n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd3[n]  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD30_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD30  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD31_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD31  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD32_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD32  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD33_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD33  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD34_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD34  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD35_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD35  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD36_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD36  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD37_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD37  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD38_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD38  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD39_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD39  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD310_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD310  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD311_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD311  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD312_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD312  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD30   0x000000CB            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD31   0x0000010B            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD32   0x0000014B            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD33   0x0000018B            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD34   0x000001CB            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD35   0x0000020B            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD36   0x0000024B            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD37   0x0000028B            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD38   0x000002CB            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD39   0x0000030B            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD310  0x0000034B            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD311  0x0000038B            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD312  0x000003CB            /*  CORE Sensor Read Command3 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD3n(i) (REG_CORE_DIGITAL_SENSOR_READ_CMD30 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_READ_CMD3n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_READ_CMD4n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd4[n]  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD40_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD40  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD41_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD41  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD42_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD42  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD43_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD43  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD44_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD44  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD45_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD45  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD46_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD46  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD47_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD47  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD48_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD48  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD49_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD49  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD410_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD410  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD411_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD411  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD412_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD412  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD40   0x000000CC            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD41   0x0000010C            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD42   0x0000014C            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD43   0x0000018C            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD44   0x000001CC            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD45   0x0000020C            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD46   0x0000024C            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD47   0x0000028C            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD48   0x000002CC            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD49   0x0000030C            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD410  0x0000034C            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD411  0x0000038C            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD412  0x000003CC            /*  CORE Sensor Read Command4 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD4n(i) (REG_CORE_DIGITAL_SENSOR_READ_CMD40 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_READ_CMD4n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_READ_CMD5n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd5[n]  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD50_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD50  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD51_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD51  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD52_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD52  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD53_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD53  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD54_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD54  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD55_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD55  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD56_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD56  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD57_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD57  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD58_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD58  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD59_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD59  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD510_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD510  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD511_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD511  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD512_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD512  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD50   0x000000CD            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD51   0x0000010D            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD52   0x0000014D            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD53   0x0000018D            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD54   0x000001CD            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD55   0x0000020D            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD56   0x0000024D            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD57   0x0000028D            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD58   0x000002CD            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD59   0x0000030D            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD510  0x0000034D            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD511  0x0000038D            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD512  0x000003CD            /*  CORE Sensor Read Command5 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD5n(i) (REG_CORE_DIGITAL_SENSOR_READ_CMD50 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_READ_CMD5n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_READ_CMD6n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd6[n]  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD60_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD60  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD61_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD61  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD62_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD62  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD63_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD63  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD64_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD64  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD65_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD65  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD66_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD66  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD67_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD67  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD68_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD68  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD69_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD69  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD610_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD610  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD611_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD611  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD612_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD612  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD60   0x000000CE            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD61   0x0000010E            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD62   0x0000014E            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD63   0x0000018E            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD64   0x000001CE            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD65   0x0000020E            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD66   0x0000024E            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD67   0x0000028E            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD68   0x000002CE            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD69   0x0000030E            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD610  0x0000034E            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD611  0x0000038E            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD612  0x000003CE            /*  CORE Sensor Read Command6 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD6n(i) (REG_CORE_DIGITAL_SENSOR_READ_CMD60 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_READ_CMD6n_COUNT 13
#define REG_CORE_DIGITAL_SENSOR_READ_CMD7n_RESET 0x00000000            /*      Reset Value for Digital_Sensor_Read_Cmd7[n]  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD70_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD70  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD71_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD71  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD72_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD72  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD73_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD73  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD74_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD74  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD75_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD75  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD76_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD76  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD77_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD77  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD78_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD78  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD79_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD79  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD710_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD710  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD711_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD711  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD712_RESET 0x00000000            /*      Reset Value for REG_CORE_DIGITAL_SENSOR_READ_CMD712  */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD70   0x000000CF            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD71   0x0000010F            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD72   0x0000014F            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD73   0x0000018F            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD74   0x000001CF            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD75   0x0000020F            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD76   0x0000024F            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD77   0x0000028F            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD78   0x000002CF            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD79   0x0000030F            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD710  0x0000034F            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD711  0x0000038F            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD712  0x000003CF            /*  CORE Sensor Read Command7 */
#define REG_CORE_DIGITAL_SENSOR_READ_CMD7n(i) (REG_CORE_DIGITAL_SENSOR_READ_CMD70 + ((i) * 64))
#define REG_CORE_DIGITAL_SENSOR_READ_CMD7n_COUNT 13

/* ============================================================================================================================
        CORE Register BitMasks, Positions & Enumerations 
   ============================================================================================================================ */
/* -------------------------------------------------------------------------------------------------------------------------
          CORE_COMMAND                         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_COMMAND_SPECIAL_COMMAND     0            /*  Special Command */
#define BITM_CORE_COMMAND_SPECIAL_COMMAND    0x000000FF    /*  Special Command */
#define ENUM_CORE_COMMAND_NOP                0x00000000            /*  Special_Command: No Command */
#define ENUM_CORE_COMMAND_CONVERT            0x00000001            /*  Special_Command: Start ADC Conversions */
#define ENUM_CORE_COMMAND_CONVERT_WITH_RAW   0x00000002            /*  Special_Command: Start Conversions with Added RAW ADC Data */
#define ENUM_CORE_COMMAND_LATCH_CONFIG       0x00000007            /*  Special_Command: Latch Configuration. */
#define ENUM_CORE_COMMAND_LOAD_LUT           0x00000008            /*  Special_Command: Load LUT from FLASH */
#define ENUM_CORE_COMMAND_SAVE_LUT           0x00000009            /*  Special_Command: Save LUT to FLASH */
#define ENUM_CORE_COMMAND_POWER_DOWN         0x00000014            /*  Special_Command: Enter Low Power State */
#define ENUM_CORE_COMMAND_LOAD_CONFIG_1      0x00000018            /*  Special_Command: Load Registers with Configuration#1 from FLASH */
#define ENUM_CORE_COMMAND_SAVE_CONFIG_1      0x00000019            /*  Special_Command: Store Current Registers to FLASH Configuration#1 */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_MODE                            Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_MODE_DRDY_MODE              2            /*  Indicates Behavior of DRDY with Respect to FIFO State */
#define BITP_CORE_MODE_CONVERSION_MODE        0            /*  Conversion Mode */
#define BITM_CORE_MODE_DRDY_MODE             0x0000000C    /*  Indicates Behavior of DRDY with Respect to FIFO State */
#define BITM_CORE_MODE_CONVERSION_MODE       0x00000003    /*  Conversion Mode */
#define ENUM_CORE_MODE_DRDY_PER_CONVERSION   0x00000000            /*  Drdy_Mode: Data Ready Per Conversion */
#define ENUM_CORE_MODE_DRDY_PER_CYCLE        0x00000004            /*  Drdy_Mode: Data Ready Per Cycle */
#define ENUM_CORE_MODE_SINGLECYCLE           0x00000000            /*  Conversion_Mode: Single Cycle */
#define ENUM_CORE_MODE_CONTINUOUS            0x00000002            /*  Conversion_Mode: Continuous Conversion */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_POWER_CONFIG                    Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_POWER_CONFIG_POWER_MODE_MCU  0            /*  MCU Power Mode */
#define BITM_CORE_POWER_CONFIG_POWER_MODE_MCU 0x00000001    /*  MCU Power Mode */
#define ENUM_CORE_POWER_CONFIG_ACTIVE_MODE   0x00000000            /*  Power_Mode_MCU: Part is fully powered up and either cycling through a sequence or awaiting a configuration */
#define ENUM_CORE_POWER_CONFIG_HIBERNATION   0x00000001            /*  Power_Mode_MCU: module has entede hibernation mode. All analog circuitry is disabled. All peripherals disabled apart from the Wake-up pin functionality. */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CYCLE_CONTROL                   Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CYCLE_CONTROL_CYCLE_TIME_UNITS 14            /*  Units for Cycle Time */
#define BITP_CORE_CYCLE_CONTROL_VBIAS        13            /*  Voltage Bias Global Enable */
#define BITP_CORE_CYCLE_CONTROL_CYCLE_TYPE   12            /*  Type of Measurement Cycle */
#define BITP_CORE_CYCLE_CONTROL_CYCLE_TIME    0            /*  Duration of a Full Measurement Cycle */
#define BITM_CORE_CYCLE_CONTROL_CYCLE_TIME_UNITS 0x0000C000    /*  Units for Cycle Time */
#define BITM_CORE_CYCLE_CONTROL_VBIAS        0x00002000    /*  Voltage Bias Global Enable */
#define BITM_CORE_CYCLE_CONTROL_CYCLE_TYPE   0x00001000    /*  Type of Measurement Cycle */
#define BITM_CORE_CYCLE_CONTROL_CYCLE_TIME   0x00000FFF    /*  Duration of a Full Measurement Cycle */
#define ENUM_CORE_CYCLE_CONTROL_MILLISECONDS 0x00000000            /*  Cycle_Time_Units: Milli-Seconds */
#define ENUM_CORE_CYCLE_CONTROL_SECONDS      0x00004000            /*  Cycle_Time_Units: Seconds */
#define ENUM_CORE_CYCLE_CONTROL_VBIAS_DISABLE 0x00000000            /*  Vbias: Vbias Disabled */
#define ENUM_CORE_CYCLE_CONTROL_VBIAS_ENABLE 0x00002000            /*  Vbias: Enable Vbias Output For the Duration of a Cycle */
#define ENUM_CORE_CYCLE_CONTROL_SWITCH       0x00000000            /*  Cycle_Type: Switch Channels After Every Conversion */
#define ENUM_CORE_CYCLE_CONTROL_FULL         0x00001000            /*  Cycle_Type: Perform Full Number Of Conversions On A Channel Consecutively */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_STATUS                          Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_STATUS_FIFO_ERROR           5            /*  Indicates Error with FIFO */
#define BITP_CORE_STATUS_CMD_RUNNING          4            /*  Indicates a Special Command is Active */
#define BITP_CORE_STATUS_DRDY                 3            /*  Indicates a New Sensor Result is Available to Be Read */
#define BITP_CORE_STATUS_ERROR                2            /*  Indicates an Error */
#define BITP_CORE_STATUS_ALERT_ACTIVE         1            /*  Indicates One or More Sensors Alerts are Active */
#define BITM_CORE_STATUS_FIFO_ERROR          0x00000020    /*  Indicates Error with FIFO */
#define BITM_CORE_STATUS_CMD_RUNNING         0x00000010    /*  Indicates a Special Command is Active */
#define BITM_CORE_STATUS_DRDY                0x00000008    /*  Indicates a New Sensor Result is Available to Be Read */
#define BITM_CORE_STATUS_ERROR               0x00000004    /*  Indicates an Error */
#define BITM_CORE_STATUS_ALERT_ACTIVE        0x00000002    /*  Indicates One or More Sensors Alerts are Active */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIAGNOSTICS_STATUS              Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIAGNOSTICS_STATUS_DIAG_CALIBRATION_ERROR 13            /*  Indicates Error During Internal Device Calibrations */
#define BITP_CORE_DIAGNOSTICS_STATUS_DIAG_CONVERSION_ERROR 12            /*  Indicates Error During Internal ADC Conversions */
#define BITP_CORE_DIAGNOSTICS_STATUS_DIAG_AINP_OV_ERROR 11            /*  Indicates Over-Voltage Error on Positive Analog Input */
#define BITP_CORE_DIAGNOSTICS_STATUS_DIAG_AINP_UV_ERROR 10            /*  Indicates Under-Voltage Error on Positive Analog Input */
#define BITP_CORE_DIAGNOSTICS_STATUS_DIAG_AINM_OV_ERROR  9            /*  Indicates Over-Voltage Error on Negative Analog Input */
#define BITP_CORE_DIAGNOSTICS_STATUS_DIAG_AINM_UV_ERROR  8            /*  Indicates Under-Voltage Error on Negative Analog Input */
#define BITP_CORE_DIAGNOSTICS_STATUS_DIAG_CHECKSUM_ERROR  0            /*  Indicates Error on Internal Checksum Calculations */
#define BITM_CORE_DIAGNOSTICS_STATUS_DIAG_CALIBRATION_ERROR 0x00002000    /*  Indicates Error During Internal Device Calibrations */
#define BITM_CORE_DIAGNOSTICS_STATUS_DIAG_CONVERSION_ERROR 0x00001000    /*  Indicates Error During Internal ADC Conversions */
#define BITM_CORE_DIAGNOSTICS_STATUS_DIAG_AINP_OV_ERROR 0x00000800    /*  Indicates Over-Voltage Error on Positive Analog Input */
#define BITM_CORE_DIAGNOSTICS_STATUS_DIAG_AINP_UV_ERROR 0x00000400    /*  Indicates Under-Voltage Error on Positive Analog Input */
#define BITM_CORE_DIAGNOSTICS_STATUS_DIAG_AINM_OV_ERROR 0x00000200    /*  Indicates Over-Voltage Error on Negative Analog Input */
#define BITM_CORE_DIAGNOSTICS_STATUS_DIAG_AINM_UV_ERROR 0x00000100    /*  Indicates Under-Voltage Error on Negative Analog Input */
#define BITM_CORE_DIAGNOSTICS_STATUS_DIAG_CHECKSUM_ERROR 0x00000001    /*  Indicates Error on Internal Checksum Calculations */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CHANNEL_ALERT_STATUS            Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH11 11            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH10 10            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH9  9            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH8  8            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH7  7            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH6  6            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH5  5            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH4  4            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH3  3            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH2  2            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH1  1            /*  Indicates Channel Alert is Active */
#define BITP_CORE_CHANNEL_ALERT_STATUS_ALERT_CH0  0            /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH11 0x00000800    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH10 0x00000400    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH9 0x00000200    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH8 0x00000100    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH7 0x00000080    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH6 0x00000040    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH5 0x00000020    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH4 0x00000010    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH3 0x00000008    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH2 0x00000004    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH1 0x00000002    /*  Indicates Channel Alert is Active */
#define BITM_CORE_CHANNEL_ALERT_STATUS_ALERT_CH0 0x00000001    /*  Indicates Channel Alert is Active */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_ALERT_STATUS_2                  Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_ALERT_STATUS_2_CONFIGURATION_ERROR  2            /*  Indicates Error with Programmed Configuration */
#define BITP_CORE_ALERT_STATUS_2_LUT_ERROR    1            /*  Indicates Error with One or More Look-Up-Tables */
#define BITM_CORE_ALERT_STATUS_2_CONFIGURATION_ERROR 0x00000004    /*  Indicates Error with Programmed Configuration */
#define BITM_CORE_ALERT_STATUS_2_LUT_ERROR   0x00000002    /*  Indicates Error with One or More Look-Up-Tables */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_ALERT_DETAIL_CH[n]              Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_ALERT_DETAIL_CH_COMP_NOT_READY 15            /*  Indicates Compensation Channel Not Ready When Required */
#define BITP_CORE_ALERT_DETAIL_CH_SENSOR_NOT_READY 14            /*  Indicates Digital Sensor Not Ready When Read */
#define BITP_CORE_ALERT_DETAIL_CH_CORRECTION_OVERRANGE 13            /*  Indicates Result Larger Than LUT/Equation Range */
#define BITP_CORE_ALERT_DETAIL_CH_CORRECTION_UNDERRANGE 12            /*  Indicates Result Less Than LUT/Equation Range */
#define BITP_CORE_ALERT_DETAIL_CH_OVER_VOLTAGE 11            /*  Indicates Channel Over-Voltage */
#define BITP_CORE_ALERT_DETAIL_CH_UNDER_VOLTAGE 10            /*  Indicates Channel Under-Voltage */
#define BITP_CORE_ALERT_DETAIL_CH_LUT_ERROR_CH  9            /*  Indicates Error with Channel Look-Up-Table */
#define BITP_CORE_ALERT_DETAIL_CH_CONFIG_ERR  8            /*  Indicates Configuration Error on Channel */
#define BITP_CORE_ALERT_DETAIL_CH_CALIBRATION_INVALID  7            /*  Indicates Problem During Calibration of Channel */
#define BITP_CORE_ALERT_DETAIL_CH_REF_DETECT  6            /*  Indicates Whether ADC Reference is Valid */
#define BITP_CORE_ALERT_DETAIL_CH_SENSOR_OPEN  5            /*  Indicates Sensor Input is Open Circuit */
#define BITP_CORE_ALERT_DETAIL_CH_HIGH_LIMIT  4            /*  Indicates Sensor Result is Greater Than High Limit */
#define BITP_CORE_ALERT_DETAIL_CH_LOW_LIMIT   3            /*  Indicates Sensor Result is Less Than Low Limit */
#define BITP_CORE_ALERT_DETAIL_CH_OVER_RANGE  2            /*  Indicates Channel Over-Range */
#define BITP_CORE_ALERT_DETAIL_CH_UNDER_RANGE  1            /*  Indicates Channel Under-Range */
#define BITP_CORE_ALERT_DETAIL_CH_TIME_OUT    0            /*  Indicates Time-Out Error from Digital Sensor */
#define BITM_CORE_ALERT_DETAIL_CH_COMP_NOT_READY 0x00008000    /*  Indicates Compensation Channel Not Ready When Required */
#define BITM_CORE_ALERT_DETAIL_CH_SENSOR_NOT_READY 0x00004000    /*  Indicates Digital Sensor Not Ready When Read */
#define BITM_CORE_ALERT_DETAIL_CH_CORRECTION_OVERRANGE 0x00002000    /*  Indicates Result Larger Than LUT/Equation Range */
#define BITM_CORE_ALERT_DETAIL_CH_CORRECTION_UNDERRANGE 0x00001000    /*  Indicates Result Less Than LUT/Equation Range */
#define BITM_CORE_ALERT_DETAIL_CH_OVER_VOLTAGE 0x00000800    /*  Indicates Channel Over-Voltage */
#define BITM_CORE_ALERT_DETAIL_CH_UNDER_VOLTAGE 0x00000400    /*  Indicates Channel Under-Voltage */
#define BITM_CORE_ALERT_DETAIL_CH_LUT_ERROR_CH 0x00000200    /*  Indicates Error with Channel Look-Up-Table */
#define BITM_CORE_ALERT_DETAIL_CH_CONFIG_ERR 0x00000100    /*  Indicates Configuration Error on Channel */
#define BITM_CORE_ALERT_DETAIL_CH_CALIBRATION_INVALID 0x00000080    /*  Indicates Problem During Calibration of Channel */
#define BITM_CORE_ALERT_DETAIL_CH_REF_DETECT 0x00000040    /*  Indicates Whether ADC Reference is Valid */
#define BITM_CORE_ALERT_DETAIL_CH_SENSOR_OPEN 0x00000020    /*  Indicates Sensor Input is Open Circuit */
#define BITM_CORE_ALERT_DETAIL_CH_HIGH_LIMIT 0x00000010    /*  Indicates Sensor Result is Greater Than High Limit */
#define BITM_CORE_ALERT_DETAIL_CH_LOW_LIMIT  0x00000008    /*  Indicates Sensor Result is Less Than Low Limit */
#define BITM_CORE_ALERT_DETAIL_CH_OVER_RANGE 0x00000004    /*  Indicates Channel Over-Range */
#define BITM_CORE_ALERT_DETAIL_CH_UNDER_RANGE 0x00000002    /*  Indicates Channel Under-Range */
#define BITM_CORE_ALERT_DETAIL_CH_TIME_OUT   0x00000001    /*  Indicates Time-Out Error from Digital Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_ERROR_CODE                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_ERROR_CODE_ERROR_CODE       0            /*  Code Indicating Type of Error */
#define BITM_CORE_ERROR_CODE_ERROR_CODE      0x0000FFFF    /*  Code Indicating Type of Error */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_ALERT_CODE                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_ALERT_CODE_ALERT_CODE       0            /*  Code Indicating Type of Alert */
#define BITM_CORE_ALERT_CODE_ALERT_CODE      0x0000FFFF    /*  Code Indicating Type of Alert */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_EXTERNAL_REFERENCE_RESISTOR     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_EXTERNAL_REFERENCE_RESISTOR_EXT_REFIN1_VALUE  0            /*  Refin1 Value */
#define BITM_CORE_EXTERNAL_REFERENCE_RESISTOR_EXT_REFIN1_VALUE 0x00000000    /*  Refin1 Value */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_EXTERNAL_VOLTAGE_REFERENCE      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_EXTERNAL_VOLTAGE_REFERENCE_EXT_REFIN2_VALUE  0            /*  Refin2 Value */
#define BITM_CORE_EXTERNAL_VOLTAGE_REFERENCE_EXT_REFIN2_VALUE 0x00000000    /*  Refin2 Value */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIAGNOSTICS_CONTROL             Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIAGNOSTICS_CONTROL_DIAG_OSD_FREQ  2            /*  Diagnostics Open Sensor Detect Frequency */
#define BITP_CORE_DIAGNOSTICS_CONTROL_DIAG_MEAS_EN  1            /*  Diagnostics Measure Enable */
#define BITP_CORE_DIAGNOSTICS_CONTROL_DIAG_GLOBAL_EN  0            /*  Diagnostics Global Enable */
#define BITM_CORE_DIAGNOSTICS_CONTROL_DIAG_OSD_FREQ 0x0000000C    /*  Diagnostics Open Sensor Detect Frequency */
#define BITM_CORE_DIAGNOSTICS_CONTROL_DIAG_MEAS_EN 0x00000002    /*  Diagnostics Measure Enable */
#define BITM_CORE_DIAGNOSTICS_CONTROL_DIAG_GLOBAL_EN 0x00000001    /*  Diagnostics Global Enable */
#define ENUM_CORE_DIAGNOSTICS_CONTROL_OCD_OFF 0x00000000            /*  Diag_OSD_Freq: No Open-Circuit Detection During Measurement */
#define ENUM_CORE_DIAGNOSTICS_CONTROL_OCD_PER_1_CYCLE 0x00000004            /*  Diag_OSD_Freq: Open-Circuit Detection Performed Once Per Measurement Cycle */
#define ENUM_CORE_DIAGNOSTICS_CONTROL_OCD_PER_100_CYCLES 0x00000008            /*  Diag_OSD_Freq: Open-Circuit Detection Performed Once Per Hundred Measurement Cycles */
#define ENUM_CORE_DIAGNOSTICS_CONTROL_OCD_PER_1000_CYCLES 0x0000000C            /*  Diag_OSD_Freq: Open-Circuit Detection Performed Once Per Thousand Measurement Cycles */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DATA_FIFO                       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DATA_FIFO_DATA_FIFO         0            /*  Fifo Buffer of Sensor Results */
#define BITM_CORE_DATA_FIFO_DATA_FIFO        0x000000FF    /*  Fifo Buffer of Sensor Results */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DEBUG_CODE                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DEBUG_CODE_DEBUG_CODE       0            /*  Additional Information on Source of Alert or Errors */
#define BITM_CORE_DEBUG_CODE_DEBUG_CODE      0x00000000    /*  Additional Information on Source of Alert or Errors */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_ADVANCED_SENSOR_ACCESS          Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_ADVANCED_SENSOR_ACCESS_ADVANCED_SENSOR_ACCESS  0            /*  Write Specific Key Value to Access Advanced Sensors */
#define BITM_CORE_ADVANCED_SENSOR_ACCESS_ADVANCED_SENSOR_ACCESS 0x0000FFFF    /*  Write Specific Key Value to Access Advanced Sensors */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_LUT_SELECT                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_LUT_SELECT_LUT_RW           7            /*  Read or Write LUT Data */
#define BITM_CORE_LUT_SELECT_LUT_RW          0x00000080    /*  Read or Write LUT Data */
#define ENUM_CORE_LUT_SELECT_LUT_READ        0x00000000            /*  LUT_RW: Read Addressed LUT Data */
#define ENUM_CORE_LUT_SELECT_LUT_WRITE       0x00000080            /*  LUT_RW: Write Addressed LUT Data */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_LUT_OFFSET                      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_LUT_OFFSET_LUT_OFFSET       0            /*  Offset into Look-Up-Table */
#define BITM_CORE_LUT_OFFSET_LUT_OFFSET      0x00003FFF    /*  Offset into Look-Up-Table */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_LUT_DATA                        Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_LUT_DATA_LUT_DATA           0            /*  Data Byte to Write to / Read from Look-Up-Table */
#define BITM_CORE_LUT_DATA_LUT_DATA          0x000000FF    /*  Data Byte to Write to / Read from Look-Up-Table */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_REVISION                        Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_REVISION_REV_MAJOR         24            /*  Major Revision Information */
#define BITP_CORE_REVISION_REV_MINOR         16            /*  Minor Revision Information */
#define BITP_CORE_REVISION_REV_PATCH          0            /*  Patch Revision Information */
#define BITM_CORE_REVISION_REV_MAJOR         0xFF000000    /*  Major Revision Information */
#define BITM_CORE_REVISION_REV_MINOR         0x00FF0000    /*  Minor Revision Information */
#define BITM_CORE_REVISION_REV_PATCH         0x0000FFFF    /*  Patch Revision Information */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CHANNEL_COUNT[n]                Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CHANNEL_COUNT_CHANNEL_ENABLE  7            /*  Enable Channel in Measurement Cycle */
#define BITP_CORE_CHANNEL_COUNT_CHANNEL_COUNT  0            /*  How Many Times Channel Should Appear in One Cycle */
#define BITM_CORE_CHANNEL_COUNT_CHANNEL_ENABLE 0x00000080    /*  Enable Channel in Measurement Cycle */
#define BITM_CORE_CHANNEL_COUNT_CHANNEL_COUNT 0x0000007F    /*  How Many Times Channel Should Appear in One Cycle */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CHANNEL_OPTIONS[n]              Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CHANNEL_OPTIONS_CHANNEL_PRIORITY  0            /*  Indicates Priority or Position of This Channel in Sequence */
#define BITM_CORE_CHANNEL_OPTIONS_CHANNEL_PRIORITY 0x0000000F    /*  Indicates Priority or Position of This Channel in Sequence */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SENSOR_TYPE[n]                  Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SENSOR_TYPE_SENSOR_TYPE     0            /*  Sensor Type */
#define BITM_CORE_SENSOR_TYPE_SENSOR_TYPE    0x00000FFF    /*  Sensor Type */
#define ENUM_CORE_SENSOR_TYPE_THERMOCOUPLE_T 0x00000000            /*  Sensor_Type: Thermocouple T-Type Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_THERMOCOUPLE_J 0x00000001            /*  Sensor_Type: Thermocouple J-Type Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_THERMOCOUPLE_K 0x00000002            /*  Sensor_Type: Thermocouple K-Type Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_RTD_2W_PT100   0x00000020            /*  Sensor_Type: RTD 2 Wire PT100 Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_RTD_2W_PT1000  0x00000021            /*  Sensor_Type: RTD 2 Wire PT1000 Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_RTD_3W_PT100   0x00000040            /*  Sensor_Type: RTD 3 Wire PT100 Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_RTD_3W_PT1000  0x00000041            /*  Sensor_Type: RTD 3 Wire PT1000 Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_RTD_4W_PT100   0x00000060            /*  Sensor_Type: RTD 4 Wire PT100 Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_RTD_4W_PT1000  0x00000061            /*  Sensor_Type: RTD 4 Wire PT1000 Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_THERMISTOR_A_10K 0x00000080            /*  Sensor_Type: Thermistor Type A 10kOhm Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_THERMISTOR_B_10K 0x00000081            /*  Sensor_Type: Thermistor Type B 10kOhm Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_BRIDGE_4W_2    0x000000A9            /*  Sensor_Type: Bridge 4 Wire Sensor 2 Defined Level 2 */
#define ENUM_CORE_SENSOR_TYPE_BRIDGE_6W_1    0x000000C8            /*  Sensor_Type: Bridge 6 Wire Sensor 1 Defined Level 2 */
#define ENUM_CORE_SENSOR_TYPE_BRIDGE_6W_2    0x000000C9            /*  Sensor_Type: Bridge 6 Wire Sensor 2 Defined Level 2 */
#define ENUM_CORE_SENSOR_TYPE_DIODE_2C_TYPEA 0x000000E0            /*  Sensor_Type: Diode 2 Current Type A Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_DIODE_3C_TYPEA 0x000000E1            /*  Sensor_Type: Diode 3 Current Type A Sensor Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_DIODE_2C_1     0x000000E8            /*  Sensor_Type: Diode 2 Current Sensor 1 Defined Level 2 */
#define ENUM_CORE_SENSOR_TYPE_DIODE_3C_1     0x000000E9            /*  Sensor_Type: Diode 3 Current Sensor 1 Defined Level 2 */
#define ENUM_CORE_SENSOR_TYPE_VOLTAGE        0x00000200            /*  Sensor_Type: Voltage Input */
#define ENUM_CORE_SENSOR_TYPE_VOLTAGE_PRESSURE_A 0x00000220            /*  Sensor_Type: Voltage Output Pressure Sensor A Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_VOLTAGE_PRESSURE_B 0x00000221            /*  Sensor_Type: Voltage Output Pressure Sensor B Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_CURRENT        0x00000300            /*  Sensor_Type: Current Input */
#define ENUM_CORE_SENSOR_TYPE_I2C_PRESSURE_A 0x00000800            /*  Sensor_Type: I2C Pressure Sensor A Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_I2C_PRESSURE_B 0x00000801            /*  Sensor_Type: I2C Pressure Sensor B Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_I2C_HUMIDITY_A 0x00000840            /*  Sensor_Type: I2C Humidity Sensor A Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_I2C_HUMIDITY_B 0x00000841            /*  Sensor_Type: I2C Humidity Sensor B Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_SPI_ACCELEROMETER_A 0x00000C80            /*  Sensor_Type: SPI Accelerometer Sensor A 3-Axis Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_SPI_ACCELEROMETER_B 0x00000C81            /*  Sensor_Type: SPI Accelerometer Sensor B 3-Axis Defined Level 1 */
#define ENUM_CORE_SENSOR_TYPE_CO2_A_DEF      0x00000E00            /*  Sensor_Type: CO2 Sensor A Defined Level 1 */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SENSOR_DETAILS[n]               Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SENSOR_DETAILS_COMPENSATION_DISABLE 31            /*  Indicates Compensation Data Should Not Be Used */
#define BITP_CORE_SENSOR_DETAILS_RTD_CURVE   27            /*  Select RTD Curve for Linearisation */
#define BITP_CORE_SENSOR_DETAILS_PGA_GAIN    24            /*  PGA Gain */
#define BITP_CORE_SENSOR_DETAILS_REFERENCE_SELECT 20            /*  Reference Selection */
#define BITP_CORE_SENSOR_DETAILS_DO_NOT_PUBLISH 17            /*  Do Not Publish Channel Result */
#define BITP_CORE_SENSOR_DETAILS_LUT_SELECT  15            /*  Lookup Table Select */
#define BITP_CORE_SENSOR_DETAILS_COMPENSATION_CHANNEL  4            /*  Indicates Which Channel is Used to Compensate Sensor Result */
#define BITP_CORE_SENSOR_DETAILS_MEASUREMENT_UNITS  0            /*  Units of Sensor Measurement */
#define BITM_CORE_SENSOR_DETAILS_COMPENSATION_DISABLE 0x80000000    /*  Indicates Compensation Data Should Not Be Used */
#define BITM_CORE_SENSOR_DETAILS_RTD_CURVE   0x18000000    /*  Select RTD Curve for Linearisation */
#define BITM_CORE_SENSOR_DETAILS_PGA_GAIN    0x07000000    /*  PGA Gain */
#define BITM_CORE_SENSOR_DETAILS_REFERENCE_SELECT 0x00F00000    /*  Reference Selection */
#define BITM_CORE_SENSOR_DETAILS_DO_NOT_PUBLISH 0x00020000    /*  Do Not Publish Channel Result */
#define BITM_CORE_SENSOR_DETAILS_LUT_SELECT  0x00018000    /*  Lookup Table Select */
#define BITM_CORE_SENSOR_DETAILS_COMPENSATION_CHANNEL 0x000000F0    /*  Indicates Which Channel is Used to Compensate Sensor Result */
#define BITM_CORE_SENSOR_DETAILS_MEASUREMENT_UNITS 0x0000000F    /*  Units of Sensor Measurement */
#define ENUM_CORE_SENSOR_DETAILS_EUROPEAN_CURVE 0x00000000            /*  RTD_Curve: European Curve */
#define ENUM_CORE_SENSOR_DETAILS_AMERICAN_CURVE 0x08000000            /*  RTD_Curve: American Curve */
#define ENUM_CORE_SENSOR_DETAILS_JAPANESE_CURVE 0x10000000            /*  RTD_Curve: Japanese Curve */
#define ENUM_CORE_SENSOR_DETAILS_ITS90_CURVE 0x18000000            /*  RTD_Curve: ITS-90 Curve */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_1  0x00000000            /*  PGA_Gain: Gain of 1 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_2  0x01000000            /*  PGA_Gain: Gain of 2 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_4  0x02000000            /*  PGA_Gain: Gain of 4 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_8  0x03000000            /*  PGA_Gain: Gain of 8 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_16 0x04000000            /*  PGA_Gain: Gain of 16 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_32 0x05000000            /*  PGA_Gain: Gain of 32 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_64 0x06000000            /*  PGA_Gain: Gain of 64 */
#define ENUM_CORE_SENSOR_DETAILS_PGA_GAIN_128 0x07000000            /*  PGA_Gain: Gain of 128 */
#define ENUM_CORE_SENSOR_DETAILS_REF_VINT    0x00000000            /*  Reference_Select: Internal voltage reference (1.2V) */
#define ENUM_CORE_SENSOR_DETAILS_REF_VEXT1   0x00100000            /*  Reference_Select: External Voltage reference applied to VERF+ and VREF- */
#define ENUM_CORE_SENSOR_DETAILS_REF_AVDD    0x00300000            /*  Reference_Select: AVDD Supply Used as Excitation and Internally applied as Reference */
#define ENUM_CORE_SENSOR_DETAILS_LUT_DEFAULT 0x00000000            /*  LUT_Select: Default Lookup Table for Selected Sensor Type */
#define ENUM_CORE_SENSOR_DETAILS_LUT_UNITY   0x00008000            /*  LUT_Select: Unity Lookup Table. 1:1 Mapping From Input to Output */
#define ENUM_CORE_SENSOR_DETAILS_LUT_CUSTOM  0x00010000            /*  LUT_Select: User Defined Custom Lookup Table. */
#define ENUM_CORE_SENSOR_DETAILS_LUT_RESERVED 0x00018000            /*  LUT_Select: Reserved */
#define ENUM_CORE_SENSOR_DETAILS_UNITS_UNSPECIFIED 0x00000000            /*  Measurement_Units: Not Specified */
#define ENUM_CORE_SENSOR_DETAILS_UNITS_RESERVED 0x00000001            /*  Measurement_Units: Reserved */
#define ENUM_CORE_SENSOR_DETAILS_UNITS_DEGC  0x00000002            /*  Measurement_Units: Degrees C */
#define ENUM_CORE_SENSOR_DETAILS_UNITS_DEGF  0x00000003            /*  Measurement_Units: Degrees F */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CHANNEL_EXCITATION[n]           Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CHANNEL_EXCITATION_IOUT_DIODE_RATIO  6            /*  Modify Current Ratios Used for Diode Sensor */
#define BITP_CORE_CHANNEL_EXCITATION_IOUT_EXCITATION_CURRENT  0            /*  Current Source Value */
#define BITM_CORE_CHANNEL_EXCITATION_IOUT_DIODE_RATIO 0x000001C0    /*  Modify Current Ratios Used for Diode Sensor */
#define BITM_CORE_CHANNEL_EXCITATION_IOUT_EXCITATION_CURRENT 0x0000000F    /*  Current Source Value */
#define ENUM_CORE_CHANNEL_EXCITATION_DIODE_2PT_10UA_100UA 0x00000000            /*  IOUT_Diode_Ratio: 2 Current measurement 10uA 100uA */
#define ENUM_CORE_CHANNEL_EXCITATION_DIODE_2PT_20UA_160UA 0x00000040            /*  IOUT_Diode_Ratio: 2 Current measurement 20uA 160uA */
#define ENUM_CORE_CHANNEL_EXCITATION_DIODE_2PT_50UA_300UA 0x00000080            /*  IOUT_Diode_Ratio: 2 Current measurement 50uA 300uA */
#define ENUM_CORE_CHANNEL_EXCITATION_DIODE_2PT_100UA_600UA 0x000000C0            /*  IOUT_Diode_Ratio: 2 Current measurement 100uA 600uA */
#define ENUM_CORE_CHANNEL_EXCITATION_DIODE_3PT_10UA_50UA_100UA 0x00000100            /*  IOUT_Diode_Ratio: 3 current measuremet 10uA 50uA 100uA */
#define ENUM_CORE_CHANNEL_EXCITATION_DIODE_3PT_20UA_100UA_160UA 0x00000140            /*  IOUT_Diode_Ratio: 3 current measuremet 20uA 100uA 160uA */
#define ENUM_CORE_CHANNEL_EXCITATION_DIODE_3PT_50UA_150UA_300UA 0x00000180            /*  IOUT_Diode_Ratio: 3 current measuremet 50uA 150uA 300uA */
#define ENUM_CORE_CHANNEL_EXCITATION_DIODE_3PT_100UA_300UA_600UA 0x000001C0            /*  IOUT_Diode_Ratio: 3 current measuremet 100uA 300uA 600uA */
#define ENUM_CORE_CHANNEL_EXCITATION_EXTERNAL 0x00000000            /*  IOUT_Excitation_Current: External Current Sourced */
#define ENUM_CORE_CHANNEL_EXCITATION_RESERVED 0x00000001            /*  IOUT_Excitation_Current: Reserved */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_10UA 0x00000002            /*  IOUT_Excitation_Current: 10 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_RESERVED2 0x00000003            /*  IOUT_Excitation_Current: Reserved */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_50UA 0x00000004            /*  IOUT_Excitation_Current: 50 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_100UA 0x00000005            /*  IOUT_Excitation_Current: 100 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_250UA 0x00000006            /*  IOUT_Excitation_Current: 250 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_500UA 0x00000007            /*  IOUT_Excitation_Current: 500 \mu;A */
#define ENUM_CORE_CHANNEL_EXCITATION_IEXC_1000UA 0x00000008            /*  IOUT_Excitation_Current: 1000 \mu;A */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SETTLING_TIME[n]                Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SETTLING_TIME_SETTLING_TIME_UNITS 14            /*  Units for Settling Time */
#define BITP_CORE_SETTLING_TIME_SETTLING_TIME  0            /*  Settling Time to Allow When Switching to Channel */
#define BITM_CORE_SETTLING_TIME_SETTLING_TIME_UNITS 0x0000C000    /*  Units for Settling Time */
#define BITM_CORE_SETTLING_TIME_SETTLING_TIME 0x00003FFF    /*  Settling Time to Allow When Switching to Channel */
#define ENUM_CORE_SETTLING_TIME_MICROSECONDS 0x00000000            /*  Settling_Time_Units: Micro-Seconds */
#define ENUM_CORE_SETTLING_TIME_MILLISECONDS 0x00004000            /*  Settling_Time_Units: Milli-Seconds */
#define ENUM_CORE_SETTLING_TIME_SECONDS      0x00008000            /*  Settling_Time_Units: Seconds */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_MEASUREMENT_SETUP[n]            Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_MEASUREMENT_SETUP_BUFFER_BYPASS 15            /*  Disable Buffers */
#define BITP_CORE_MEASUREMENT_SETUP_GND_SW   13            /*  GND_SW */
#define BITP_CORE_MEASUREMENT_SETUP_ADC_FILTER_TYPE 12            /*  ADC Digital Filter Type */
#define BITP_CORE_MEASUREMENT_SETUP_CHOP_MODE 10            /*  Enabled and Disable Chop Mode */
#define BITP_CORE_MEASUREMENT_SETUP_PST_MEAS_EXC_CTRL  9            /*  Disabled Current Sources After Measurement Has Been Complete */
#define BITP_CORE_MEASUREMENT_SETUP_NOTCH_EN_2  8            /*  Enable Notch 2 Filter Mode */
#define BITP_CORE_MEASUREMENT_SETUP_CUSTOM_CALIBRATION  7            /*  Enables Custom Calibration for Selected Sensor */
#define BITP_CORE_MEASUREMENT_SETUP_ADC_SF    0            /*  ADC Digital Filter Select */
#define BITM_CORE_MEASUREMENT_SETUP_BUFFER_BYPASS 0x00008000    /*  Disable Buffers */
#define BITM_CORE_MEASUREMENT_SETUP_GND_SW   0x00006000    /*  GND_SW */
#define BITM_CORE_MEASUREMENT_SETUP_ADC_FILTER_TYPE 0x00001000    /*  ADC Digital Filter Type */
#define BITM_CORE_MEASUREMENT_SETUP_CHOP_MODE 0x00000C00    /*  Enabled and Disable Chop Mode */
#define BITM_CORE_MEASUREMENT_SETUP_PST_MEAS_EXC_CTRL 0x00000200    /*  Disabled Current Sources After Measurement Has Been Complete */
#define BITM_CORE_MEASUREMENT_SETUP_NOTCH_EN_2 0x00000100    /*  Enable Notch 2 Filter Mode */
#define BITM_CORE_MEASUREMENT_SETUP_CUSTOM_CALIBRATION 0x00000080    /*  Enables Custom Calibration for Selected Sensor */
#define BITM_CORE_MEASUREMENT_SETUP_ADC_SF   0x0000007F    /*  ADC Digital Filter Select */
#define ENUM_CORE_MEASUREMENT_SETUP_BUFFERS_ENABLED 0x00000000
#define ENUM_CORE_MEASUREMENT_SETUP_BUFFERS_DISABLED 0x00008000
#define ENUM_CORE_MEASUREMENT_SETUP_GND_SW_OPEN 0x00000000            /*  GND_SW: GND_SW Open. The GND SW is not enabled for the sensor measurement */
#define ENUM_CORE_MEASUREMENT_SETUP_GND_SW_CLOSED 0x00002000            /*  GND_SW: GND_SW Closed. The GND SW is enabled for the sensor measurement, bit wiil Remain Closed After the Measurement */
#define ENUM_CORE_MEASUREMENT_SETUP_ENABLE_SINC4 0x00000000            /*  ADC_Filter_Type: Enabled SINC4 Filter */
#define ENUM_CORE_MEASUREMENT_SETUP_ENABLE_SINC3 0x00001000            /*  ADC_Filter_Type: Enabled SINC3 Filter */
#define ENUM_CORE_MEASUREMENT_SETUP_DISABLE_CHOP 0x00000000            /*  Chop_Mode: Chop Mode Disabled */
#define ENUM_CORE_MEASUREMENT_SETUP_HW_CHOP  0x00000400            /*  Chop_Mode: Chop Mode Enabled */
#define ENUM_CORE_MEASUREMENT_SETUP_ENABLE_CHOP 0x00000800            /*  Chop_Mode: Chop Mode Enabled */
#define ENUM_CORE_MEASUREMENT_SETUP_HW_SW_CHOP 0x00000C00            /*  Chop_Mode: Chop Mode Enabled */
#define ENUM_CORE_MEASUREMENT_SETUP_POWERCYCLE 0x00000000
#define ENUM_CORE_MEASUREMENT_SETUP_ALWAYSON 0x00000200
#define ENUM_CORE_MEASUREMENT_SETUP_NOTCH_DIS 0x00000000            /*  NOTCH_EN_2: Disable Notch Filter */
#define ENUM_CORE_MEASUREMENT_SETUP_NOTCH_EN 0x00000100            /*  NOTCH_EN_2: Enable Notch 2 Filter option. Places a addtional notch at 1.2X ODR. Can be used for 50 and 60Hz rejection simultaneously */
#define ENUM_CORE_MEASUREMENT_SETUP_INTERNAL_CALIBRATION 0x00000000
#define ENUM_CORE_MEASUREMENT_SETUP_CUSTOM_CALIBRATION 0x00000080

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_HIGH_THRESHOLD_LIMIT[n]         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_HIGH_THRESHOLD_LIMIT_HIGH_THRESHOLD  0            /*  Upper Limit for Sensor Alert Comparison */
#define BITM_CORE_HIGH_THRESHOLD_LIMIT_HIGH_THRESHOLD 0x00000000    /*  Upper Limit for Sensor Alert Comparison */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_LOW_THRESHOLD_LIMIT[n]          Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_LOW_THRESHOLD_LIMIT_LOW_THRESHOLD  0            /*  Lower Limit for Sensor Alert Comparison */
#define BITM_CORE_LOW_THRESHOLD_LIMIT_LOW_THRESHOLD 0x00000000    /*  Lower Limit for Sensor Alert Comparison */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SENSOR_OFFSET[n]                Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SENSOR_OFFSET_SENSOR_OFFSET  0            /*  Sensor Offset Adjustment */
#define BITM_CORE_SENSOR_OFFSET_SENSOR_OFFSET 0x00000000    /*  Sensor Offset Adjustment */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SENSOR_GAIN[n]                  Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SENSOR_GAIN_SENSOR_GAIN     0            /*  Sensor Gain Adjustment */
#define BITM_CORE_SENSOR_GAIN_SENSOR_GAIN    0x00000000    /*  Sensor Gain Adjustment */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_ALERT_CODE_CH[n]                Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_ALERT_CODE_CH_ALERT_CODE_CH  0            /*  Per-Channel Code Indicating Type of Alert */
#define BITM_CORE_ALERT_CODE_CH_ALERT_CODE_CH 0x0000FFFF    /*  Per-Channel Code Indicating Type of Alert */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CHANNEL_SKIP[n]                 Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CHANNEL_SKIP_CHANNEL_SKIP   0            /*  Indicates If Channel Will Skip Some Measurement Cycles */
#define BITM_CORE_CHANNEL_SKIP_CHANNEL_SKIP  0x000000FF    /*  Indicates If Channel Will Skip Some Measurement Cycles */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_SENSOR_PARAMETER[n]             Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_SENSOR_PARAMETER_SENSOR_PARAMETER  0            /*  Sensor Parameter Adjustment */
#define BITM_CORE_SENSOR_PARAMETER_SENSOR_PARAMETER 0x00000000    /*  Sensor Parameter Adjustment */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_CALIBRATION_PARAMETER[n]        Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_CALIBRATION_PARAMETER_CALIBRATION_PARAMETER_ENABLE 24            /*  Enables Use of Calibration_Parameter */
#define BITP_CORE_CALIBRATION_PARAMETER_CALIBRATION_PARAMETER  0            /*  Calibration Parameter Value */
#define BITM_CORE_CALIBRATION_PARAMETER_CALIBRATION_PARAMETER_ENABLE 0x01000000    /*  Enables Use of Calibration_Parameter */
#define BITM_CORE_CALIBRATION_PARAMETER_CALIBRATION_PARAMETER 0x00FFFFFF    /*  Calibration Parameter Value */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_CONFIG[n]        Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_DATA_BITS 11            /*  Number of Relevant Data Bits */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_READ_BYTES  8            /*  Number of Bytes to Read from the Sensor */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_BIT_OFFSET  4            /*  Data Bit Offset, Relative to Alignment */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LEFT_ALIGNED  3            /*  Data Alignment Within the Data Frame */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LITTLE_ENDIAN  2            /*  Data Endianness of Sensor Result */
#define BITP_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_CODING  0            /*  Data Encoding of Sensor Result */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_DATA_BITS 0x0000F800    /*  Number of Relevant Data Bits */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_READ_BYTES 0x00000700    /*  Number of Bytes to Read from the Sensor */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_BIT_OFFSET 0x000000F0    /*  Data Bit Offset, Relative to Alignment */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LEFT_ALIGNED 0x00000008    /*  Data Alignment Within the Data Frame */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_LITTLE_ENDIAN 0x00000004    /*  Data Endianness of Sensor Result */
#define BITM_CORE_DIGITAL_SENSOR_CONFIG_DIGITAL_SENSOR_CODING 0x00000003    /*  Data Encoding of Sensor Result */
#define ENUM_CORE_DIGITAL_SENSOR_CONFIG_CODING_NONE 0x00000000            /*  Digital_Sensor_Coding: None/Invalid */
#define ENUM_CORE_DIGITAL_SENSOR_CONFIG_CODING_UNIPOLAR 0x00000001            /*  Digital_Sensor_Coding: Unipolar */
#define ENUM_CORE_DIGITAL_SENSOR_CONFIG_CODING_TWOS_COMPL 0x00000002            /*  Digital_Sensor_Coding: Twos Complement */
#define ENUM_CORE_DIGITAL_SENSOR_CONFIG_CODING_OFFSET_BINARY 0x00000003            /*  Digital_Sensor_Coding: Offset Binary */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_ADDRESS[n]       Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_ADDRESS_DIGITAL_SENSOR_ADDRESS  0            /*  I2C Address or Write Address Command for SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_ADDRESS_DIGITAL_SENSOR_ADDRESS 0x000000FF    /*  I2C Address or Write Address Command for SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_NUM_CMDS[n]      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_NUM_CMDS_DIGITAL_SENSOR_NUM_READ_CMDS  4            /*  Number of Read Commands for Digital Sensor */
#define BITP_CORE_DIGITAL_SENSOR_NUM_CMDS_DIGITAL_SENSOR_NUM_CFG_CMDS  0            /*  Number of Configuration Commands for Digital Sensor */
#define BITM_CORE_DIGITAL_SENSOR_NUM_CMDS_DIGITAL_SENSOR_NUM_READ_CMDS 0x00000070    /*  Number of Read Commands for Digital Sensor */
#define BITM_CORE_DIGITAL_SENSOR_NUM_CMDS_DIGITAL_SENSOR_NUM_CFG_CMDS 0x00000007    /*  Number of Configuration Commands for Digital Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_COMMS[n]         Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE 10            /*  Configuration for Sensor SPI Protocol */
#define BITP_CORE_DIGITAL_SENSOR_COMMS_I2C_CLOCK  5            /*  Controls SCLK Frequency for I2C Sensors */
#define BITP_CORE_DIGITAL_SENSOR_COMMS_SPI_CLOCK  1            /*  Controls Clock Frequency for SPI Sensors */
#define BITP_CORE_DIGITAL_SENSOR_COMMS_DIGITAL_SENSOR_COMMS_EN  0            /*  Enable Digital Sensor Comms Register Parameters */
#define BITM_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE 0x00000C00    /*  Configuration for Sensor SPI Protocol */
#define BITM_CORE_DIGITAL_SENSOR_COMMS_I2C_CLOCK 0x00000060    /*  Controls SCLK Frequency for I2C Sensors */
#define BITM_CORE_DIGITAL_SENSOR_COMMS_SPI_CLOCK 0x0000001E    /*  Controls Clock Frequency for SPI Sensors */
#define BITM_CORE_DIGITAL_SENSOR_COMMS_DIGITAL_SENSOR_COMMS_EN 0x00000001    /*  Enable Digital Sensor Comms Register Parameters */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_0 0x00000000            /*  SPI_Mode: Clock Polarity = 0 Clock Phase = 0 */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_1 0x00000400            /*  SPI_Mode: Clock Polarity = 0 Clock Phase = 1 */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_2 0x00000800            /*  SPI_Mode: Clock Polarity = 1 Clock Phase = 0 */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_MODE_3 0x00000C00            /*  SPI_Mode: Clock Polarity = 1 Clock Phase = 1 */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_I2C_100K 0x00000000            /*  I2C_Clock: 100kHz SCL */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_I2C_400K 0x00000020            /*  I2C_Clock: 400kHz SCL */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_I2C_RESERVED1 0x00000040            /*  I2C_Clock: Reserved */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_I2C_RESERVED2 0x00000060            /*  I2C_Clock: Reserved */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_8MHZ 0x00000000            /*  SPI_Clock: 8MHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_4MHZ 0x00000002            /*  SPI_Clock: 4MHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_2MHZ 0x00000004            /*  SPI_Clock: 2MHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_1MHZ 0x00000006            /*  SPI_Clock: 1MHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_500KHZ 0x00000008            /*  SPI_Clock: 500kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_250KHZ 0x0000000A            /*  SPI_Clock: 250kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_125KHZ 0x0000000C            /*  SPI_Clock: 125kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_62P5KHZ 0x0000000E            /*  SPI_Clock: 62.5kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_31P3KHZ 0x00000010            /*  SPI_Clock: 31.25kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_15P6KHZ 0x00000012            /*  SPI_Clock: 15.625kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_7P8KHZ 0x00000014            /*  SPI_Clock: 7.8kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_3P9KHZ 0x00000016            /*  SPI_Clock: 3.9kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_1P9KHZ 0x00000018            /*  SPI_Clock: 1.95kHz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_977HZ 0x0000001A            /*  SPI_Clock: 977Hz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_488HZ 0x0000001C            /*  SPI_Clock: 488Hz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_SPI_244HZ 0x0000001E            /*  SPI_Clock: 244Hz */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_DIGITAL_COMMS_DEFAULT 0x00000000            /*  Digital_Sensor_Comms_En: Default Parameters Used for Digital Sensor Communications */
#define ENUM_CORE_DIGITAL_SENSOR_COMMS_DIGITAL_COMMS_USER 0x00000001            /*  Digital_Sensor_Comms_En: User Supplied Parameters Used for Digital Sensor Communications */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_COMMAND1[n]      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_COMMAND1_DIGITAL_SENSOR_COMMAND1  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_COMMAND1_DIGITAL_SENSOR_COMMAND1 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_COMMAND2[n]      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_COMMAND2_DIGITAL_SENSOR_COMMAND2  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_COMMAND2_DIGITAL_SENSOR_COMMAND2 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_COMMAND3[n]      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_COMMAND3_DIGITAL_SENSOR_COMMAND3  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_COMMAND3_DIGITAL_SENSOR_COMMAND3 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_COMMAND4[n]      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_COMMAND4_DIGITAL_SENSOR_COMMAND4  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_COMMAND4_DIGITAL_SENSOR_COMMAND4 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_COMMAND5[n]      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_COMMAND5_DIGITAL_SENSOR_COMMAND5  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_COMMAND5_DIGITAL_SENSOR_COMMAND5 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_COMMAND6[n]      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_COMMAND6_DIGITAL_SENSOR_COMMAND6  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_COMMAND6_DIGITAL_SENSOR_COMMAND6 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_COMMAND7[n]      Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_COMMAND7_DIGITAL_SENSOR_COMMAND7  0            /*  Configuration Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_COMMAND7_DIGITAL_SENSOR_COMMAND7 0x000000FF    /*  Configuration Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_READ_CMD1[n]     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_READ_CMD1_DIGITAL_SENSOR_READ_CMD1  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_READ_CMD1_DIGITAL_SENSOR_READ_CMD1 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_READ_CMD2[n]     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_READ_CMD2_DIGITAL_SENSOR_READ_CMD2  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_READ_CMD2_DIGITAL_SENSOR_READ_CMD2 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_READ_CMD3[n]     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_READ_CMD3_DIGITAL_SENSOR_READ_CMD3  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_READ_CMD3_DIGITAL_SENSOR_READ_CMD3 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_READ_CMD4[n]     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_READ_CMD4_DIGITAL_SENSOR_READ_CMD4  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_READ_CMD4_DIGITAL_SENSOR_READ_CMD4 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_READ_CMD5[n]     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_READ_CMD5_DIGITAL_SENSOR_READ_CMD5  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_READ_CMD5_DIGITAL_SENSOR_READ_CMD5 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_READ_CMD6[n]     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_READ_CMD6_DIGITAL_SENSOR_READ_CMD6  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_READ_CMD6_DIGITAL_SENSOR_READ_CMD6 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */

/* -------------------------------------------------------------------------------------------------------------------------
          CORE_DIGITAL_SENSOR_READ_CMD7[n]     Pos/Masks         Description
   ------------------------------------------------------------------------------------------------------------------------- */
#define BITP_CORE_DIGITAL_SENSOR_READ_CMD7_DIGITAL_SENSOR_READ_CMD7  0            /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */
#define BITM_CORE_DIGITAL_SENSOR_READ_CMD7_DIGITAL_SENSOR_READ_CMD7 0x000000FF    /*  Per Conversion Command to Send to Digital I2C/SPI Sensor */


#endif  /* end ifndef _DEF_ADMW1001_REGISTERS_H */
