#ifndef __UTILS_H__
#define __UTILS_H__

#include "admw_api.h"
#include "admw1001/admw1001_api.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Utility function to print the status read from the ADI Sense device */
void utils_printStatus(
    ADMW_STATUS *pStatus);

/* Utility function to print data samples read from the ADI Sense device */
void utils_printSamples(
    ADMW_DATA_SAMPLE *pSampleBuffer,
    uint32_t nNumSamples,
    ADMW_MEASUREMENT_MODE eMeasurementMode);

/* Utility function to register callbacks for ADI Sense device notification signals  */
ADMW_RESULT utils_registerCallbacks(
    ADMW_DEVICE_HANDLE hDevice,
    volatile bool *pbDataReady,
    volatile bool *pbError,
    volatile bool *pbAlert);

/* Utility function to de-register callbacks for ADI Sense device notification signals */
ADMW_RESULT utils_deregisterCallbacks(
    ADMW_DEVICE_HANDLE hDevice);

/* Utility function to run measurements on ADI Sense device, according to its current
 * configuration, and display data samples and device status following each cycle */
ADMW_RESULT utils_runMeasurement(
    ADMW_DEVICE_HANDLE hDevice,
    ADMW_MEASUREMENT_MODE eMeasurementMode);
 
/* Utility function to retrieve and print the factory calibration coefficients table from the ADI Sense device */
ADMW_RESULT utils_printCalTable(
    ADMW_DEVICE_HANDLE hDevice);

#ifdef __cplusplus
}
#endif

#endif /* __UTILS_H__ */

