#ifndef __PLATFORM_H__
#define __PLATFORM_H__

#include "admw_api.h"
#include "admw1001/admw1001_api.h"

#if defined (__MBED__)

#  include <mbed.h>

#  if defined(TARGET_NUCLEO_F411RE)
#    define PLATFORM_SPI_MOSI        SPI_MOSI
#    define PLATFORM_SPI_MISO        SPI_MISO
#    define PLATFORM_SPI_SCK         SPI_SCK
#    define PLATFORM_SPI_CS          D10
#    define PLATFORM_GPIO_RESET      D6
#    define PLATFORM_GPIO_ALERT_ERROR      D3
#    define PLATFORM_GPIO_DATAREADY  D4
#    define PLATFORM_LOG_TX          D1
#    define PLATFORM_LOG_RX          D0
#  elif defined(TARGET_ADUCM4050)
#    define PLATFORM_SPI_MOSI        SPI0_MOSI
#    define PLATFORM_SPI_MISO        SPI0_MISO
#    define PLATFORM_SPI_SCK         SPI0_SCLK
#    define PLATFORM_SPI_CS          D10
#    define PLATFORM_GPIO_RESET      D6
#    define PLATFORM_GPIO_ALERT_ERROR      D3
#    define PLATFORM_GPIO_DATAREADY  D5
#    define PLATFORM_LOG_TX          D0
#    define PLATFORM_LOG_RX          D1
#  else
#    error "Unknown target device"
#  endif

#  define PLATFORM_CONNECTION_INFO                  \
    {                                               \
        .type = ADMW_CONNECTION_TYPE_SPI,      \
        .spi = {                                    \
            .mosiPin    = PLATFORM_SPI_MOSI,        \
            .misoPin    = PLATFORM_SPI_MISO,        \
            .sckPin     = PLATFORM_SPI_SCK,         \
            .csPin      = PLATFORM_SPI_CS,          \
            .maxSpeedHz = 1600000,                  \
        },                                          \
        .gpio = {                                   \
            .resetPin     = PLATFORM_GPIO_RESET,    \
            .alertErrorPin     = PLATFORM_GPIO_ALERT_ERROR,    \
            .datareadyPin = PLATFORM_GPIO_DATAREADY,\
        },                                          \
        .log = {                                    \
            .txPin        = PLATFORM_LOG_TX,        \
            .rxPin        = PLATFORM_LOG_RX,        \
            .baudRate     = 115200,                 \
            .disableLogs  = false,                  \
        } \
    }

#else
#  error "Unknown host platform"
#endif

#endif /* __PLATFORM_H__ */

