#include "mbed.h"

typedef struct  WAV_HEADER
{
char                RIFF[4];        
int                 ChunkSize;     
char                WAVE[4];       
char                fmt[4];        
int                 Subchunk1Size;                              
short int           AudioFormat;  
short int           NumOfChan;      
int                 SamplesPerSec;  
int                 bytesPerSec;    
short int           blockAlign;    
short int           bitsPerSample;  
int                 Subchunk2Size; 
char                Subchunk2ID[4];
}wavhdr;

struct wav_header_t
{
    char chunkID[4]; //"RIFF" = 0x46464952
    unsigned long chunkSize; //28 [+ sizeof(wExtraFormatBytes) + wExtraFormatBytes] + sum(sizeof(chunk.id) + sizeof(chunk.size) + chunk.size)
    char format[4]; //"WAVE" = 0x45564157
    char subchunk1ID[4]; //"fmt " = 0x20746D66
    unsigned long subchunk1Size; //16 [+ sizeof(wExtraFormatBytes) + wExtraFormatBytes]
    unsigned short audioFormat;
    unsigned short numChannels;
    unsigned long sampleRate;
    unsigned long byteRate;
    unsigned short blockAlign;
    unsigned short bitsPerSample;
    //[WORD wExtraFormatBytes;]
    //[Extra format bytes]
};