#include "mbed.h"
#include <stdio.h>
#include <string.h>
#include "SDFileSystem.h"
#include "wavheader.h"

SDFileSystem sd(p5, p6, p7, p20, "sd"); // the pinout on the mbed Cool Components workshop board
SPI dac(p11,p12,p13);
DigitalOut LR(p14);
DigitalOut LED(LED1);
DigitalOut LEDn(LED1);
Ticker sampler;


char filer[64][64];
int numberOfFiles = 0; //files in filer array
int chuncksize = 0;
int readern = 0;
int playern = 0;
int16_t databuf[1024];
int16_t sbuffer[1];

struct WAV_HEADER wavHeader;


void sdToArray(char directory[64]="/sd", char type[5] = ".wav")
{
    DIR *d;
    struct dirent *dir;
    d = opendir(directory);
    char buffer[64];
    if (d) {
        while ((dir = readdir(d)) != NULL) {
            //leser alle filnavn fra sd kort og leger de i en buffer
            sprintf(buffer, "%s", dir->d_name);
            //sjekker at filen ikke starter med [ . ] og slutter med valgt type (wav).
            //legger så disse i filer arrayet.
            if (!strcmp(strrchr(buffer, '\0') - 4, type)) {
                if (strncmp(buffer, ".",1)) {
                    strcpy(filer[numberOfFiles], buffer);
                    numberOfFiles++;
                }
            }
        }

        closedir(d);
    }
}

void analyzeWAV(char filnavn[64])
{
    char dir[128] = "/sd/";
    strcat(dir,filnavn);
    FILE *fil = fopen(dir, "rb");
    if(fil!=NULL) {
        fread(&wavHeader,sizeof(wavHeader),1,fil);
        fclose(fil);
        printf("riff: %s \r\n", wavHeader.RIFF);
        printf("wave: %s \r\n", wavHeader.WAVE);
        printf("Samples: %d \r\n", wavHeader.SamplesPerSec);
        printf("bitprsamp: %d \r\n", wavHeader.bitsPerSample);
        printf("channels: %d \r\n", wavHeader.NumOfChan);
    }
    printf("funcedn");
    fclose(fil);
}

void play()
{
    if (playern<readern) {
        LR = 0;
        dac.write(sbuffer[1]);
        LR = 1;
        dac.write(sbuffer[1]);
        LEDn != LEDn;
    }
}
int main()
{
    numberOfFiles=0;
    sdToArray();
    printf("WAV filer:\r\n");
    for(int i = 0; i < numberOfFiles; i++) {
        printf("%d | %s \r\n",i,filer[i]);
    }
    printf("Skriv filnummer:");
    int nummer;
    scanf("%d", &nummer);
    printf("%d - %s \r\n", nummer, filer[nummer]);
    printf("\r\n END!! \r");
    
    //
    float frekvensplay = 1.0/wavHeader.SamplesPerSec;
    printf("attacher-");
    sampler.attach(&play,frekvensplay);
    printf("spiller-");

    char dir[128] = "/sd/";
    strcat(dir,filer[nummer]);
    FILE *fip = fopen(dir, "rb");
    if(fip==NULL) {
        printf("error opening wav %c - \r\n", dir);
    }
    fseek(fip, SEEK_SET, 0);
    while(1) {
        fread(sbuffer, 2,1,fip);
    }
}
