#include "mbed.h"
#include "SDFileSystem.h"
 

//SDFileSystem sd(mosi, miso, sclk, cs, "sd");

SDFileSystem sd(D11, D12, D13, D10, "sd"); // the pinout on the mbed Cool Components workshop board

/* on the Break out Module
    G   = GND           goes to         GND 0V
    DO  = Digital Out   goes to MISO    D12
    CLK = Clock         goes to SCLK    D13
    DI  = Digital In    goes to MOSI    D11
    CS  = Chip Select   goes to CS      D10
    +   = +ve supply    goes to         3V3 Check! Slider switch on SD side is set to 3V3
*/
//    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");//Open device "sd" with a folder "mdir" of root on the SD card


char myStr[128];

int main() {
    printf("Start to write!\n");   
 
    mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello World!");
    fprintf(fp, "This is a second line");
    fprintf(fp, "and now a third line");
    fclose(fp); 
 
    printf("Finished writing and closed file\n");
    
    FILE *fp1 = fopen("/sd/mydir/sdtest.txt", "r");
    //fscanf(fp1, "%s", myStr);
    fgets(myStr, 12, fp1);
    printf("\t%s\n\r",myStr);
    fclose(fp1); 
}
