/*
This is the stepper motor class and is used to control all of the motors individually
*/
#ifndef STEPPER_MOTOR_HPP//Header Guards Prevents Multiple includes
#define STEPPER_MOTOR_HPP
//Libraries and header includes
#include "THREADS.hpp"
#include "mbed.h"
#include "rtos.h"
#include "SERIAL.hpp"
class STEPPER_MOTOR                       //This creates a class called Led
{ 
public: 
    STEPPER_MOTOR(PinName STEP, PinName DIRECTION); //Constructor
    ~STEPPER_MOTOR();                                 //Destructor
    void Permanent_Rotate();
    void Permanent_Rotate_clock_wise();
    void Permanent_Rotate_anti_clock_wise();
    void Rotate_90();
    void Rotate_Steps(int Steps, int Direction);
private:    
    //Private member variables to prevent them being accessed externally 
    //Data Pins
    int _Number_of_steps;
    DigitalOut _STEP;       //Step
    DigitalOut _DIRECTION;  //Direction
};
#endif//STEPPER_MOTOR_HPP

//Object creations


