/*
This is where we control the Time of the MicroController and the DATA
*/

#ifndef _TIME_HPP_//Header Guards Prevents Multiple includes
#define _TIME_HPP_
//Libraries and header includes
#include "mbed.h"
#include "rtos.h"
#include <string>
#include <iostream>
#include <sstream>

//Definitions of Parameters according to the UNIX time standard
#define Days_In_Month 30.436875
#define second 1
#define minute 60
#define hour 3600
#define day 86400
#define week 604800
#define month 2629743
#define year 31556926

int get_current_time();                                 //Returns Current time
void set_new_date(int days, int months, int years);     //Sets the day,month and year
void set_new_time(int hours, int minutes, int seconds); //Sets the hour, minute and seconds
void Add_Second();                                      //Adds a seconds to time
void Subtract_Second();                                 //Subtracts a second from time
void Add_Minute();                                      //Add a minute to time
void Subtract_Minute();                                 //Subtracts a minute from time
void Add_Hour();                                        //Adds an hour to time
void Subtract_Hour();                                   //Subtracts an hour from time
void Add_Day();                                         //Add a day to time
void Subtract_Day();                                    //Subtracts a day from time
void Add_Month();                                       //Adds a month to time
void Subtract_Month();                                  //Subtracts a month to time
void Add_Year();                                        //Add a year to time
void Subtract_Year();                                   //Subtracts a year from time

#endif