#ifndef __sample_hardware__
#define __sample_hardware__
//#define BME
#ifdef BME
#include "BME280.h"
#else
#include "BMP280.h"
#endif
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "LCD_COMMAND.hpp"
#include "LCD.hpp"
#include "NETWORK.hpp"
#include "SERIAL_COMMANDS.hpp"
#include "SD_CARD.hpp"

enum ELEC350_ERROR_CODE {OK, NETWORK_FATAL,SD_CARD_REMOVED,FATAL};//Error Codes

extern DigitalOut onBoardLED;

extern DigitalIn  onBoardSwitch;
extern InterruptIn  SW1;
extern InterruptIn  SW2;
//extern Serial pc;
extern AnalogIn adcIn;

#ifdef BME
extern BME280 sensor;
#else
extern BMP280 sensor;
#endif
extern SDBlockDevice sd;

extern void post();
extern void errorCode(ELEC350_ERROR_CODE err);

#endif