#include "mbed.h"
#include "sample_hardware.hpp"
#include "LCD.hpp"

#define RED_DONE 1
#define YELLOW_DONE 2

//Digital outputs
DigitalOut onBoardLED(LED1);
DigitalOut redLED(PE_15);
DigitalOut yellowLED(PB_10);
DigitalOut greenLED(PB_11);

//Inputs
DigitalIn  onBoardSwitch(USER_BUTTON);
InterruptIn  SW1(PE_12);
InterruptIn  SW2(PE_14);
//Serial pc(USBTX, USBRX);
AnalogIn adcIn(PA_0);

//Environmental Sensor driver
#ifdef BME
BME280 sensor(D14, D15);
#else
BMP280 sensor(D14, D15);
#endif

//SD Card
SDBlockDevice sd(PB_5, D12, D13, D10); // mosi, miso, sclk, cs 

//POWER ON SELF TEST
void post() 
{
    //POWER ON TEST (POT)
    puts("**********STARTING POWER ON SELF TEST (POST)**********");
    
    //Test LEDs
    puts("ALL LEDs should be blinking");
    for (unsigned int n=0; n<10; n++) {
        redLED    = 1;
        yellowLED = 1;
        greenLED  = 1;
        wait(0.05);
        redLED    = 0;
        yellowLED = 0;
        greenLED  = 0;     
        wait(0.05);         
    } 
    
    //Output the switch states (hold them down to test)
    printf("SW1: %d\tSW2: %d\n\r", SW1.read(), SW2.read());    
    printf("USER: %d\n\r", onBoardSwitch.read()); 
    
    //Output the ADC
    printf("ADC: %f\n\r", adcIn.read());
    
    //Read Sensors (I2C)
    float temp = sensor.getTemperature();
    float pressure = sensor.getPressure();
    #ifdef BME
    float humidity = sensor.getHumidity();
    #endif
   
    //Display in PuTTY
    printf("Temperature: %5.1f\n", temp);
    printf("Pressure: %5.1f\n", pressure);
    #ifdef BME
    printf("Pressure: %5.1f\n", humidity);
    #endif
    
    //Display on LCD
    redLED = 1;
    //LCD.Display_Clear();
    //LCD.DDRAM_Address(0x00);
    //LCD.Write_String("LCD TEST...");
    wait(0.5);
    redLED = 0;
    
    //Network test (if BOTH switches are held down)
    //networktest();
    NetworkWaitTime = NetworkWait;
        //Initialise the SD card (this needs to move)
    if ( sd.init() != 0) {
        printf("SD Init failed \n");
        LCD.Display_Clear();
        LCD.Write_String("CANNOT INIT SD");        //Change me
        errorCode(FATAL);
    }
    //Create a filing system for SD Card
    FATFileSystem fs("sd", &sd);     

    //Open to WRITE
    
    FILE* fp = fopen("/sd/test.csv","w");
    if (fp == NULL) {
        error("Could not open file for write\n");
        LCD.Display_Clear();
        LCD.Write_String("CANNOT OPEN FILE");
        errorCode(FATAL);
    }
    //Close File
    fclose(fp);
    
    int network_temp;
    network_temp = Network_Init();
    if(network_temp == 1)//Sets up the network and checks if the network cable is not pluged in
    {
        error("Could not access network");
        LCD.Display_Clear();
        LCD.Write_String("Could not access network");
        errorCode(NETWORK_FATAL);   
    }
    //Last message before sampling begins
    LCD.Display_Clear();
    LCD.Write_String("READY     PLAYER");
    LCD.DDRAM_Address(0x40);
    LCD.Write_String("      One     ");
    LCD.DDRAM_Address(0x00);
    puts("**********POST END**********\n");
 
}

void errorCode(ELEC350_ERROR_CODE err)
{
    switch (err) {
      case OK:
        greenLED = 1;
        wait(1.0);
        greenLED = 0;
        return;
    case NETWORK_FATAL:
        while(1) {
            pc.printf("NETWOK FATAL\n");
        }
    case SD_CARD_REMOVED:
            wait(0.1);
            LCD.Display_Clear();
            LCD.DDRAM_Address(0x00);
            LCD.Write_String("SD CARD");
            LCD.DDRAM_Address(0x40);
            LCD.Write_String("Removed");
            
            wait(5);
            pc.printf("SD CARD REMOVED\n");
            while(1) 
            {
                if(SD_CARD_DETECT.read() == 0)
                {
                    LCD.Display_Clear();
                    LCD.DDRAM_Address(0x00);
                    LCD.Write_String("SD CARD");
                    LCD.DDRAM_Address(0x40);
                    LCD.Write_String("Inserted");
                    pc.printf("SD CARD INSERTED\n");
                    SD_Write = 1;
                    return;    
                }   
            }                   
    case FATAL:
        while(1) {
            pc.printf("FATAL\n");               
        }
    };
}