#include "SD_CARD.hpp"
FILE* fp; 
InterruptIn SD_CARD_DETECT(D0);
   

bool SD_Write = 1;
void SD_Init()//Initialised the SD CARD
{
    
}
void SD_Card_Eject()
{/*
    SD_Write = 0;
    if(Log_Value==5){pc.printf("Closing File Ejecting SD Card\n");}
    //fclose(fp);//Close File
    sd.deinit();//Close down
    LCD.Display_Clear();
    LCD.DDRAM_Address(0x00);
    LCD.Write_String("SD Card");
    LCD.DDRAM_Address(0x40);
    LCD.Write_String("Unmounted");
    LCD.DDRAM_Address(0x00);
    pc.printf("SD Card Unmounted\n");
    */
}
void SD_Card_Write()
{
    if(SD_Write == 0)
    {
        if(Log_Value==5){pc.printf("SD Has Been Ejected Please do a Hardware Restart\n");}
        return;   
    }
    if(Write_Pointer == mailsize - 1)
        {
            if(Log_Value==5){pc.printf("In SD_Card Thread\n");}
            
            FATFileSystem fs("sd", &sd);
            
            
            time_t File_Time = Data_Buffer[Write_Pointer - 1].get_time();
            tm* File_Time_Pointer = localtime(&File_Time);
            int File_temp_day = File_Time_Pointer->tm_mday;
            int File_temp_month = (File_Time_Pointer->tm_mon+1);//Set to current month
            int File_temp_year = (File_Time_Pointer->tm_year+1900);//Set to current year
            
            char FileToOpen[50] = {};
            snprintf (FileToOpen, sizeof(char) * sizeof(FileToOpen), "/sd/%d_%02d_%02d.csv",File_temp_year,File_temp_month,File_temp_day);
            
            fp = fopen(FileToOpen,"wb");
            if (fp == NULL) 
            {
                error("Could not open file for write in SD_Card\n");
                LCD.Display_Clear();
                LCD.Write_String("CANNOT OPEN FILE");
                errorCode(FATAL);
            }                             //Open to WRITE
            
            if(Log_Value==5){pc.printf("File Opened\n");}  
                   
            for(int SD_Card_Data_Pointer = 0; SD_Card_Data_Pointer != mailsize; SD_Card_Data_Pointer++)
            {
                if(Log_Value==5){pc.printf("Copying from address: %d\n", SD_Card_Data_Pointer);}
                
                //ofstream outfile ("Hello Tom.txt");
                time_t Time = Data_Buffer[SD_Card_Data_Pointer].get_time();
                tm* Time_Pointer = localtime(&Time);
                int temp_day = Time_Pointer->tm_mday;
                int temp_month = (Time_Pointer->tm_mon+1);//Set to current month
                int temp_year = (Time_Pointer->tm_year+1900);//Set to current year
                    
                int temp_hours = Time_Pointer->tm_hour; 
                int temp_minute = Time_Pointer->tm_min;
                int temp_seconds = Time_Pointer->tm_sec;
                    
                float temp_temperature = Data_Buffer[SD_Card_Data_Pointer].get_temperature();
                float temp_pressure = Data_Buffer[SD_Card_Data_Pointer].get_pressure();
                float temp_light = Data_Buffer[SD_Card_Data_Pointer].get_light();
                
                
                fprintf(fp, "Date: %02d/%02d/%d,",temp_day,temp_month,temp_year);//Date
                fprintf(fp, "Time: %02d:%02d:%02d,",temp_hours,temp_minute, temp_seconds);//Time
                fprintf(fp, "Temperature: %1.1f,",temp_temperature);//Temperature
                fprintf(fp, "Pressure: %1.1f,",temp_pressure);//Pressure
                fprintf(fp, "Light: %5.3f,",temp_light);//Light
                fprintf(fp, "End of Data \n");//End of data
            }
            
            //Close File
            fclose(fp);
            if(Log_Value==5){pc.printf("Dumped data to SD Card\n");}

        }
}

