#include "LCD_COMMAND.hpp"
void LCD_Write_Year()
{
        Time_Lock_Main.lock();//Appling lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Year Time lock taken\n");}
        time_t Time = time(NULL);
        tm* Time_Pointer = localtime(&Time);
        int Years = 1900 + Time_Pointer->tm_year;
        Time_Lock_Main.unlock();//Releasing lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Year Time lock released\n");}
        stringstream ss;
        ss << Years;
        string Year_String = ss.str();
        LCD.DDRAM_Address(0x00);
        LCD.Write_String("Set Year");
        LCD.DDRAM_Address(0x40);
        LCD.Write_String(Year_String);   
}
void LCD_Write_Month()
{
        Time_Lock_Main.lock();//Appling lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Month Time lock taken\n");}
        time_t Time = time(NULL);
        tm* Time_Pointer = localtime(&Time);
        int Months = 1 + Time_Pointer->tm_mon;
        Time_Lock_Main.unlock();//Releasing lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Month Time lock released\n");}
        stringstream ss;
        ss << Months;
        string Month_String = ss.str();
        LCD.DDRAM_Address(0x00);
        LCD.Write_String("Set Month");
        LCD.DDRAM_Address(0x40);
        LCD.Write_String(Month_String);   
}
void LCD_Write_Day()
{
        Time_Lock_Main.lock();//Appling lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Day Time lock taken\n");}
        time_t Time = time(NULL);
        tm* Time_Pointer = localtime(&Time);
        int Days = Time_Pointer->tm_mday;
        Time_Lock_Main.unlock();//Releasing lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Day Time lock released\n");}
        stringstream ss;
        ss << Days;
        string Day_String = ss.str();
        LCD.DDRAM_Address(0x00);
        LCD.Write_String("Set Day");
        LCD.DDRAM_Address(0x40);
        LCD.Write_String(Day_String);   
}
void LCD_Write_Hour()
{
        Time_Lock_Main.lock();//Appling lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Hour Time lock taken\n");}
        time_t Time = time(NULL);
        tm* Time_Pointer = localtime(&Time);
        int Hours = Time_Pointer->tm_hour;
        Time_Lock_Main.unlock();//Releasing lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Hour Time lock released\n");}
        stringstream ss;
        ss << Hours;
        string Hour_String = ss.str();
        LCD.DDRAM_Address(0x00);
        LCD.Write_String("Set Hour");
        LCD.DDRAM_Address(0x40);
        LCD.Write_String(Hour_String);   
}
void LCD_Write_Minute()
{
        Time_Lock_Main.lock();//Appling lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Minute Time lock taken\n");}
        time_t Time = time(NULL);
        tm* Time_Pointer = localtime(&Time);
        int Minutes = Time_Pointer->tm_min;
        Time_Lock_Main.unlock();//Releasing lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Minute Time lock released\n");}
        stringstream ss;
        ss << Minutes;
        string Minute_String = ss.str();
        LCD.DDRAM_Address(0x00);
        LCD.Write_String("Set Minute");
        LCD.DDRAM_Address(0x40);
        LCD.Write_String(Minute_String);   
}
void LCD_Write_Seconds()
{
        Time_Lock_Main.lock();//Appling lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Seconds Time lock taken\n");}
        time_t Time = time(NULL);
        tm* Time_Pointer = localtime(&Time);
        int Seconds = Time_Pointer->tm_sec;
        Time_Lock_Main.unlock();//Releasing lock for critial section
        if(Log_Value == 1){pc.printf("In LCD_Write_Seconds Time lock released\n");}
        stringstream ss;
        ss << Seconds;
        string Second_String = ss.str();
        LCD.DDRAM_Address(0x00);
        LCD.Write_String("Set Second");
        LCD.DDRAM_Address(0x40);
        LCD.Write_String(Second_String);   
}


void LCD_Print_Output()
{      

        if(mode == 0)//Default mode
        { 
            if(Log_Value == 1){pc.printf("In Default Mode\n");}
            
            Thread::wait(Default_Mode_Toggle_Time);//Wait for this amount of time
            if(Log_Value == 1){pc.printf("Writing Data to LCD\n");}
            sprintf (LCD_buffer, "%1.1f  %1.0f  %1.2f",Data_Active.get_temperature(),Data_Active.get_pressure(),Data_Active.get_light());//Used for converting to a sting  
             
            LCD.DDRAM_Address(0x00);
            LCD.Write_String("Temp  Pres  Lite");
            LCD.DDRAM_Address(0x40);
            LCD.Write_String(LCD_buffer);//Print out current data values to the LCD

            Thread::wait(Default_Mode_Toggle_Time); //Wait for this amount of time   
            if(Log_Value == 1){pc.printf("Writing Time and Date to LCD\n");}
            Time_Lock_Main.lock();//lock Time_lock for critial section
            time_t Time = Data_Active.get_time();
            tm* Time_Pointer = localtime(&Time);
            LCD.Display_Clear();
            sprintf (LCD_buffer, "%02d:%02d    %02d,%d",Time_Pointer->tm_hour,Time_Pointer->tm_min,(Time_Pointer->tm_mon+1),(Time_Pointer->tm_year+1900));//Used for converting to a sting  
            Time_Lock_Main.unlock();//unlock Time_lock for critial section
            
            LCD.DDRAM_Address(0x00);
            LCD.Write_String("Current Time:");
            LCD.DDRAM_Address(0x40);
            LCD.Write_String(LCD_buffer);//Print the current time to the LCD
            
            if(Log_Value == 1){pc.printf("Checking Switches for next mode\n");}
            if(SW1.read() & SW2.read() == 1)
            {
                mode = 1;   
            }
        }
        else if(mode == 1)//Choose either date setting or time setting
        {
            if(Log_Value == 1){pc.printf("Choose Time or Date Mode 1\n");}
            LCD.Display_Clear();
            while(1)
            {
                LCD.DDRAM_Address(0x00);
                LCD.Write_String("Date        Time");
                LCD.DDRAM_Address(0x40);
                LCD.Write_String("<              >");
                Thread::wait(1000);
                if(Log_Value == 1){pc.printf("Checking SW1 to go to Date setting\n");}
                if(SW1.read() == 1 & SW2.read() == 0)
                {
                    mode = 2;//Date Setting
                    break;   
                }
                if(Log_Value == 1){pc.printf("Checking SW2 to go to Time setting\n");}
                if(SW2.read() == 1 & SW1.read() == 0)
                {
                    mode = 5;//Time Setting
                    break;
                }
            }
        } 
        else if(mode == 2)//Set the Year
        {
            if(Log_Value == 1){pc.printf("In Year Setting Mode\n");}
            LCD.Display_Clear();
            while(1)
            {          
                LCD_Write_Year();
                Thread::wait(1000);
                 if(Log_Value == 1){pc.printf("Checking SW1 and SW2 to go to Month setting\n");}
                if(SW1.read() & SW2.read() == 1)
                {
                    mode = 3;
                    break;   
                }
                if(Log_Value == 1){pc.printf("Checking SW1 to add Year\n");}
                if(SW1.read() == 1 & SW2.read() == 0)
                {
                    Add_Year();
                }
                if(Log_Value == 1){pc.printf("Checking SW2 to subtract Year\n");}
                else if(SW2.read() == 1 & SW1.read() == 0)
                {
                    Subtract_Year();   
                }
                LCD_Write_Year();
            }
        } 
        else if(mode == 3)//Set the Month
        {
            if(Log_Value == 1){pc.printf("In Month Setting Mode\n");}
            LCD.Display_Clear();
            while(1)
            {
                LCD_Write_Month();
                Thread::wait(1000);
                if(Log_Value == 1){pc.printf("Checking SW1 and SW2 to go to Day setting\n");}
                if(SW1.read() & SW2.read() == 1)
                {
                    mode = 4;
                    break;   
                }
                if(Log_Value == 1){pc.printf("Checking SW1 to add Month\n");}
                if(SW1.read() == 1 & SW2.read() == 0)
                {
                    Add_Month();
                }
                if(Log_Value == 1){pc.printf("Checking SW2 to subtract Month\n");}
                else if(SW2.read() == 1 & SW1.read() == 0)
                {
                    Subtract_Month();   
                }                

            }
        }
        else if(mode == 4)//Set the Day
        {
            if(Log_Value == 1){pc.printf("In Day Setting Mode\n");}
            LCD.Display_Clear();
            while(1)
            {      
                LCD_Write_Day();
                Thread::wait(1000);
                if(Log_Value == 1){pc.printf("Checking SW1 and SW2 to go Default setting\n");}
                if(SW1.read() & SW2.read() == 1)
                {
                    mode = 0;   
                    break;
                }
                if(Log_Value == 1){pc.printf("Checking SW1 to add Day\n");}
                if(SW1.read() == 1 & SW2.read() == 0)
                {
                    Add_Day();
                }
                if(Log_Value == 1){pc.printf("Checking SW2 to subtract Day\n");}
                else if(SW2.read() == 1 & SW1.read() == 0)
                {
                    Subtract_Day();   
                }                
            }
        } 
        else if(mode == 5)//Set the Hour
        {
            if(Log_Value == 1){pc.printf("In Hour Setting Mode\n");}
            LCD.Display_Clear();
            while(1)
            {
                LCD_Write_Hour();
                Thread::wait(1000);
                if(Log_Value == 1){pc.printf("Checking SW1 and SW2 to go Minute setting\n");}
                if(SW1.read() & SW2.read() == 1)
                {
                    mode = 6;  
                    break; 
                }
                if(Log_Value == 1){pc.printf("Checking SW1 to add Hour\n");}                
                if(SW1.read() == 1 & SW2.read() == 0)
                {
                    Add_Hour();
                }
                if(Log_Value == 1){pc.printf("Checking SW2 to subtract Hour\n");} 
                else if(SW2.read() == 1 & SW1.read() == 0)
                {
                    Subtract_Hour();   
                }
            }
        } 
        else if(mode == 6)//Set the Minute
        {
            if(Log_Value == 1){pc.printf("In Minute Setting Mode\n");}
            LCD.Display_Clear();
            while(1)
            {
                LCD_Write_Minute();
                Thread::wait(1000);
                if(Log_Value == 1){pc.printf("Checking SW1 and SW2 to go Seconds setting\n");}
                if(SW1.read() & SW2.read() == 1)
                {
                    mode = 7;  
                    break; 
                }                
                if(Log_Value == 1){pc.printf("Checking SW1 to add Minute\n");}
                if(SW1.read() == 1 & SW2.read() == 0)
                {
                    Add_Minute();
                }
                if(Log_Value == 1){pc.printf("Checking SW2 to subtract Minute\n");}
                else if(SW2.read() == 1 & SW1.read() == 0)
                {
                    Subtract_Minute();   
                }                
            }
        }  
        else if(mode == 7)//Set the Seconds
        {
            if(Log_Value == 1){pc.printf("In Second Setting Mode\n");}
            LCD.Display_Clear();
            while(1)
            {
                LCD_Write_Seconds();
                Thread::wait(1000);
                if(Log_Value == 1){pc.printf("Checking SW1 and SW2 to go Default setting\n");}
                if(SW1.read() & SW2.read() == 1)
                {
                    mode = 0;  
                    break; 
                }
                if(Log_Value == 1){pc.printf("Checking SW1 to add Second\n");}                
                if(SW1.read() == 1 & SW2.read() == 0)
                {
                    Add_Second();
                }
                if(Log_Value == 1){pc.printf("Checking SW1 to subtract Second\n");}   
                else if(SW2.read() == 1 & SW1.read() == 0)
                {
                    Subtract_Second();   
                }                
            }
        }
        else
        {
            if(Log_Value == 1){pc.printf("Mode Error occured mode now set to 0\n");}   
            mode = 0;
        }
}



