#include "FIFO.hpp"

//vae
DATA Data_Active;//Current data sample
DATA Data_Buffer[mailsize];//Data buffer
int Data_Buffer_Write_Pointer;
int Write_To_Data_Buffer(DATA Data_Store, int Write_Pointer);
int Write_Pointer = 0;
Mutex Data_Buffer_Lock;

int Write_Data(DATA Data_Store, int Write_Pointer)//Writes data passed in to the array at address Write Pointer
{
    Data_Buffer_Lock.lock();//Appling lock for critial section
    Data_Buffer[Write_Pointer] = Data_Store;
    if(Write_Pointer < mailsize - 1)//Checks if write pointer will be greater than mail size
    {
        Write_Pointer = Write_Pointer + 1;//Increment write pointer
    }
    else
    {
        Write_Pointer = 0;//Else set it to 0 thus a FIFO system   
    }
    Data_Buffer_Lock.unlock();//Releasing lock for critial section
    return Write_Pointer;//New address of Write pointer
    
}
DATA Read_Data(int Read_Pointer)
{
    Data_Buffer_Lock.lock();//Appling lock for critial section
    DATA Temp_Data = Data_Buffer[Read_Pointer];
    Data_Buffer_Lock.unlock();//Releasing lock for critial section
    
    return Temp_Data;
}
void Delete_Data(int Delete_Pointer)
{
    Data_Buffer_Lock.lock();//Appling lock for critial section
    Data_Buffer[Delete_Pointer].set_all_zero();
    Data_Buffer_Lock.unlock();//Releasing lock for critial section
}