/*
ELEC 351 Group T
Team Members : Christopher Hills, Thomas Morris
Current Verision 22
Overiew: Working Tasks 1,2,3,5,6,7,8,9,10,11,12,13,14,15

Last Revision: Added Mail Box to serial
Todo:
Commnet code
Check for race conditions
Other fixes
*/

#include "SETUP.hpp"
#include "NETWORK.hpp"
#include "FIFO.hpp"
#include "SD_CARD.hpp"
#include "SERIAL_COMMANDS.hpp"
#include "SAMPLE.hpp"
#include "THREADS.hpp"
void SD_Card()//Writes data to the SD card
{
    while(1)
    {
        Thread::signal_wait(1);
        Thread::wait(Sample_Rate*1000); //Waits until a new is taken before checking again
        SD_Card_Write();
    }
}
void Network()
{
    while(1)
    {
        Thread::wait(NetworkWaitTime);//Waits Network Wait amount of time
        Networking();
    }
}
void LCD_Output()
{
    while(1)
    {
        Thread::wait(10);//Small wait
        LCD_Print_Output();
    }
}
void Serial_Commands()
{
    while(1)
    {
        Serial_Commands_Output();   
    }

}
void LED_Logging()
{
    while(1)
    {
        if(Log_Value == 0)
        {
            Thread::wait(3000);
        }
        else if(Log_Value == 1)
        {
            Yellow_led.flash(0.2);
            Thread::wait(2800);
        }
        else if(Log_Value == 2)
        {
            Yellow_led.flash(0.2);
            Thread::wait(200);
            Yellow_led.flash(0.2);
            Thread::wait(2400);
        } 
        else if(Log_Value == 3)
        {
            Yellow_led.flash(0.2);
            Thread::wait(200);
            Yellow_led.flash(0.2);
            Thread::wait(200);
            Yellow_led.flash(0.2);
            Thread::wait(2000);
        } 
        else if(Log_Value == 4)
        {
            Yellow_led.flash(0.2);
            Thread::wait(200);
            Yellow_led.flash(0.2);
            Thread::wait(200);
            Yellow_led.flash(0.2);
            Thread::wait(200);
            Yellow_led.flash(0.2);
            Thread::wait(1600);
        } 
        else if(Log_Value == 5)
        {
            Yellow_led.flash(0.2);
            Thread::wait(200);
            Yellow_led.flash(0.2);
            Thread::wait(200);
            Yellow_led.flash(0.2);
            Thread::wait(200);
            Yellow_led.flash(0.2);
            Thread::wait(200);
            Yellow_led.flash(0.2);
            Thread::wait(1200);
        } 
        else
        {
            Log_Value = 0;   
        }
    }
}
void Sample()
{
    Sample_Event();   
}
int main()
{
    set_time(1515352584);               //Set RTC time to December 10 2017
    
    pc.baud(9600);                      //Sets the Serial Comms Baud Rate

    LCD.Initialise();
    LCD.DDRAM_Address(0x00);
 
    post();     //Power on Self Test

    Sample_Rate = TimerInterval;
    //Run interrupt
    Sampling_Timer.attach(&Sampling_ISR,Sample_Rate);

    t1.start(Sample);
    t2.start(SD_Card);
    t3.start(LCD_Output);
    t4.start(Network);
    t5.start(Serial_Commands);
    t6.start(LED_Logging);
    //Main thread ID

    idMain = osThreadGetId();   //CMSIS RTOS call

    //Thread ID
    id1 = t1.gettid();
    id2 = t2.gettid();
    id3 = t3.gettid();
    id4 = t4.gettid();
    id5 = t5.gettid();
    id6 = t6.gettid();

    while(true) 
    {
        if(SD_CARD_DETECT.read() == 1)
        {
            t2.signal_set(DONT_WRITE_TO_SD_CARD);
            errorCode(SD_CARD_REMOVED);
        } 
        else if(SD_CARD_DETECT.read() == 0)
        {
            t2.signal_set(SD_CARD_WRITE);
        }
        else
        {
            t2.signal_set(SD_CARD_WRITE);   
        }
        if(onBoardSwitch == 1)
        {   
            SD_Card_Eject();
            Green_led.switchOn();
        }
    }
}