#include "NETWORK.hpp"
#include <string>
AnalogIn ldr(PA_0);

//Now setup a web server
TCPServer srv;           //TCP/IP Server
TCPSocket clt_sock;      //Socket for communication
SocketAddress clt_addr;  //Address of incoming connection
string GateWay_IP;

int Network_Init()
{ 
    //Configure an ethernet connection
    EthernetInterface eth;
    eth.set_network(IP, NETMASK, GATEWAY);
    eth.connect();
    printf("The target IP address is '%s'\n", eth.get_ip_address());
    GateWay_IP = eth.get_ip_address();
    
    if(GateWay_IP != "10.0.0.10")
    {
        return 1;
        //Error code here   
    }
    /* Open the server on ethernet stack */
    srv.open(&eth);
    
    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(eth.get_ip_address(), 80);
    
    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    return 0;
}
void Networking()
{    
        if(Log_Value==2){pc.printf("In Network Thread\n");}
        
        time_t Time = Data_Buffer[(Write_Pointer - 1)].get_time();
        tm* Time_Pointer = localtime(&Time);
        int temp_day = Time_Pointer->tm_mday;
        int temp_month = (Time_Pointer->tm_mon+1);//Set to current month
        int temp_year = (Time_Pointer->tm_year+1900);//Set to current year
        
        int temp_hours = Time_Pointer->tm_hour;
        int temp_minute = Time_Pointer->tm_min;
        int temp_seconds = Time_Pointer->tm_sec;
        
        float temp_temperature = Data_Buffer[(Write_Pointer - 1)].get_temperature();
        float temp_pressure = Data_Buffer[(Write_Pointer - 1)].get_pressure();
        float temp_light = Data_Buffer[(Write_Pointer - 1)].get_light();
        //using namespace std;
        //Block and wait on an incoming connection
        srv.accept(&clt_sock, &clt_addr);
        //printf("Networking connection accept %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port());
        //Uses a C++ string to make it easier to concatinate
        string response;
        //This is a C string
        char output1_str[64];
        char output2_str[64];
        char output3_str[64];
        char output4_str[64];
        char output5_str[64];
        char output6_str[64];
        char output7_str[64];
        char output8_str[64];
        char output9_str[64];
        
        //Convert to a C String
        sprintf(output1_str, "%02d/" , temp_day);//Print Day
        sprintf(output2_str, "%02d/" , temp_month);//Print Month
        sprintf(output3_str, "%d   " , temp_year);//Print Year
        sprintf(output4_str, "Time:%02d:" , temp_hours);//Print Hours
        sprintf(output5_str, "%02d:" , temp_minute);//Print Minute
        sprintf(output6_str, "%02d   " , temp_seconds);//Print Seconds
        sprintf(output7_str, "Temperature is : %1.1f   " , temp_temperature);//Print temperature
        sprintf(output8_str, "Pressure is : %1.1f   " , temp_pressure);//Print Pressure
        sprintf(output9_str, "Light is : %5.3f   " , temp_light);//Print Light level
        
        
        //Build the C++ string response
        response = HTTP_MESSAGE_BODY1;
        response +=output1_str;
        response +=output2_str;
        response +=output3_str;
        response +=output4_str;
        response +=output5_str;
        response +=output6_str;
        response +=output7_str;
        response +=output8_str;
        response +=output9_str;
        response += HTTP_MESSAGE_BODY2;
        
        
        if(Log_Value==2){pc.printf("Printing Network Data\n");}
        //Send static HTML response (as a C string)
        clt_sock.send(response.c_str(), response.size()+6);    
}