#include "mbed.h"           //Include the mbed libraries
#include "LCD.hpp"          //Include the header file, this acts like a series of forward declarations
 
//Constructor
LCD::LCD(PinName E,PinName RS,PinName RW,PinName DB0,PinName DB1,PinName DB2,PinName DB3,PinName DB4,PinName DB5,PinName DB6,PinName DB7) : _E(E),_RS(RS),_RW(RW),_DB0(DB0),_DB1(DB1),_DB2(DB2),_DB3(DB3),_DB4(DB4),_DB5(DB5),_DB6(DB6),_DB7(DB7)
{}

LCD::~LCD(){}   //Destructor

void LCD::clock_in(){_E = 1; wait(0.001); _E = 0; wait(0.001); _E = 1;}

void LCD::Function_Set()     {_RS = 0; _RW = 0; _DB7 = 0; _DB6 = 0; _DB5 = 1; _DB4 = 1; _DB3 = 1; _DB2 = 1; _DB1 = 0; _DB0 = 0; clock_in();}    //DB4 sets Data Width. DB3 sets No. Lines. DB2 sets font.
void LCD::Display_Off()      {_RS = 0; _RW = 0; _DB7 = 0; _DB6 = 0; _DB5 = 0; _DB4 = 0; _DB3 = 1; _DB2 = 0; _DB1 = 0; _DB0 = 0; clock_in();}    //Turns the display off.
void LCD::Display_Clear()    {_RS = 0; _RW = 0; _DB7 = 0; _DB6 = 0; _DB5 = 0; _DB4 = 0; _DB3 = 0; _DB2 = 0; _DB1 = 0; _DB0 = 1; clock_in();}    //Clears display sets position to 0.
void LCD::Entry_Mode_Set()   {_RS = 0; _RW = 0; _DB7 = 0; _DB6 = 0; _DB5 = 0; _DB4 = 0; _DB3 = 0; _DB2 = 1; _DB1 = 1; _DB0 = 0; clock_in();}    //DB1 sets increment(1) vs decrement(0). DB0 sets display shift(1) vs cursor shift(0).
void LCD::Display_On()       {_RS = 0; _RW = 0; _DB7 = 0; _DB6 = 0; _DB5 = 0; _DB4 = 0; _DB3 = 1; _DB2 = 1; _DB1 = 1; _DB0 = 1; clock_in();}    //DB1 sets cursor on(1) vs off(0). DB0 sets blink(1) vs not(0).

void LCD::Initialise(){                         //Use previous functions to initialise LCD
        Function_Set();     wait(0.020);        //Function set followed by wait.
        Display_Off();      wait(0.020);        //Display off followed by wait.
        Display_Clear();    wait(0.020);        //Display clear followed by wait.
        Entry_Mode_Set();   wait(0.020);        //Entry Mode Set followed by wait.
        Display_On();       wait(0.020);        //Turn the display on.
        DDRAM_Address(0);   wait(0.020);        //Set the address to 0.
}

void LCD::DDRAM_Address(int Address){           //Sets the address to integer address
    _RS = 0;
    _RW = 0; 
    _DB7 = 1; 
    _DB6 = (Address & 0b1000000) >> 6; _DB5 = (Address & 0b0100000) >> 5; _DB4 = (Address & 0b0010000) >> 4;                                        //Use bit shifting to convert integer to binary.
    _DB3 = (Address & 0b0001000) >> 3; _DB2 = (Address & 0b0000100) >> 2; _DB1 = (Address & 0b0000010) >> 1; _DB0 = (Address & 0b0000001) >> 0;     //Use bit shifting to convert integer to binary.
    clock_in();     //Clock the data into the LCD.
    }

void LCD::Write_String(string Word){            //Writes the string Word to the LCD starting at the current address
    int ASCII_Converted;                        //Temporary values
    for (int i = 0; i < Word.length(); i++)     //For loop running between 0 and length of string Word
    {
        ASCII_Converted = Word.at(i);           //Set ASCII_Converted to current character value
        _RS = 1; _RW = 0;                       //Set RS and RW
        _DB7 = (ASCII_Converted & 0b10000000) >> 7; _DB6 = (ASCII_Converted & 0b01000000) >> 6; _DB5 = (ASCII_Converted & 0b00100000) >> 5; _DB4 = (ASCII_Converted & 0b00010000) >> 4; //Use bit shifting to convert hex to binary.
        _DB3 = (ASCII_Converted & 0b00001000) >> 3; _DB2 = (ASCII_Converted & 0b00000100) >> 2; _DB1 = (ASCII_Converted & 0b00000010) >> 1; _DB0 = (ASCII_Converted & 0b00000001) >> 0; //Use bit shifting to convert hex to binary.
        clock_in(); //Clock the data into the LCD.
    }      
}
