#include "Accelerometre.h"

Accelerometre::Accelerometre(void)
{
    position =0;
    _acc =NULL; 
    for (i=0; i<3;i++){
        readings[i] = 0 ;
    }
}


Accelerometre::Accelerometre(ADXL345_I2C * acc)
{
    position =0;
       for (i=0; i<3;i++){
        readings[i] = 0 ;
    }
    if (_acc) delete _acc; // destruction de l'objet accelerometre 
    _acc =acc;  
    
}




Accelerometre ::~Accelerometre(void){
   if (_acc) delete _acc; // destruction de l'objet accelerometre 
   if (readings) delete readings;

}


int Accelerometre::initAcc(void){
    if (_acc) {
            
            // These are here to test whether any of the initialization fails. It will print the failure
        if (_acc->setPowerControl(0x00)){
             //pc.printf("didn't intitialize power control\n\r"); 
             return 1;  }
         //Full resolution, +/-16g, 4mg/LSB.
         wait(.001);
         
         if(_acc->setDataFormatControl(0x0B)){
            //pc.printf("didn't set data format\n\r");
            return 2;  }
         wait(.001);
         
         //3.2kHz data rate.
         if(_acc->setDataRate(ADXL345_3200HZ)){
            //pc.printf("didn't set data rate\n\r");
            return 3;    }
         wait(.001);
         
         //Measurement mode.
        if(_acc->setPowerControl(MeasurementMode)) {
        //pc.printf("didn't set the power control to measurement\n\r"); 
        return 4;   }
         
         _acc->getOutput(readingPrec);
         
          for(i=0;i<3;i++){
                if ((int16_t)readingPrec[i]<0){
                    readingPrecABS[i] = readingPrec[i]*(-1);
                }
                else{
                    
                    readingPrecABS[i] = readingPrec[i];
                } 
                  
            }
         return 10;
        }
        return 0;      
}

void Accelerometre::calculeABS(){ 
    for(i=0;i<3;i++){
        if ((int16_t)readings[i]<0){
            readingsABS[i] = readings[i]*(-1);
        }
        else{ 
            readingsABS[i] = readings[i];
        } 
          
    }
}





char Accelerometre::getPosition(void){
        _acc->getOutput(readings);
        
        calculeABS();
        
       
            
            if(((int16_t)readings[0]>150)&&((int16_t)readings[1]<150)&&((int16_t)readings[1]>-150)){ //bas
                position = 3;
            }   
            else {if(((int16_t)readings[0]<-100)&&((int16_t)readings[1]<150)&&((int16_t)readings[1]>-150)){//haut
                    position = 1;
                }
                else {if(((int16_t)readings[1]>150)&&((int16_t)readings[0]<150)&&((int16_t)readings[0]>-100)){//gauche
                        position = 2;
                    }
                    else {if(((int16_t)readings[1]<-150)&&((int16_t)readings[0]<150)&&((int16_t)readings[0]>-100)){//droite
                            position = 4;
                        }
                        else{position=0;} // attente
                    }
                }
            }           
       
        
        for (i=0;i<3;i++){
            readingPrecABS[i] = readingsABS[i];
            readingPrec[i] = readings[i];
        }
        
        
        return position;
        
}

void Accelerometre::getXYZ(int* posXYZ){
        _acc->getOutput(readings);    
        posXYZ[0] = readings[0];
        posXYZ[1] = readings[1];
        posXYZ[2] = readings[2];
    }
    
