//Include Necessary Imports
#include "mbed.h"
#include "uLCD_4DGL.h"

//Create Objects for Moisture Sensors
AnalogIn ms1(p15);
AnalogIn ms2(p16);
AnalogIn ms3(p17);
AnalogIn ms4(p18);
 
//Create Objects for Pumps
DigitalOut pump1(p8);
DigitalOut pump2(p9);
DigitalOut pump3(p10);
DigitalOut pump4(p11);

//Create Object for Push Button
DigitalIn pb1(p12);

//Create Object for LCD Screen
uLCD_4DGL uLCD(p28, p27, p29);

//Set Initial Values for Calibrated Mositure Percents
int msp1 = 100;
int msp2 = 100;
int msp3 = 100;
int msp4 = 100;

//Set Couter Variables For Water Use
int p1 = 0;
int p2 = 0;
int p3 = 0;
int p4 = 0;

//Create arrrays for the line plot
int m1Arr[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int m2Arr[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int m3Arr[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int m4Arr[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

//Determing a time interval for line chart
int plotInterval = 10;

//Create Ticker Objects for Interrupts
Ticker flipper;
Ticker arrayChanger;

//Turn Desired Pump On/Off Based on Seonsor Readings
void flipPump(){
    if(msp1 < 30) {
        pump1 = 0;
        p1 += 1;
    } else {
        pump1 = 1;
    }
    if(msp2 < 30) {
        pump2 = 0;
        p2 += 1;
    } else {
        pump2 = 1;
    }
    if(msp3 < 30) {
        pump3 = 0;
        p3 += 1;
    } else {
        pump3 = 1;
    }
    if(msp4 < 30) {
        pump4 = 0;
        p4 += 1;
    } else {
        pump4 = 1;
    }    
}

//Update Line Plot Arrays
void updateArr() {
    for(int i = 9; i >= 0; i--) {
        m1Arr[i + 1] = m1Arr[i];
        m2Arr[i + 1] = m2Arr[i];
        m3Arr[i + 1] = m3Arr[i];
        m4Arr[i + 1] = m4Arr[i];
    }
    m1Arr[0] = msp1;
    m2Arr[0] = msp2;
    m3Arr[0] = msp3;
    m4Arr[0] = msp4;
}

//Function to Find the Max
int max(int a, int b, int c, int d){
    int ab = (a<b)?b:a;
    int abc = (ab<c)?c:ab;
    return (abc<d)?d:abc;
}

int main() {
    //Clear the LCD to Start
    uLCD.cls();
     
    //Set the flipPump Interrupt to Run Every Second
    flipper.attach(&flipPump, 1.0);
    arrayChanger.attach(&updateArr, plotInterval);
    
    //Set Push Button Mode
    pb1.mode(PullUp);
    
    //Set Screen Number
    int pageNumber = 0;
    
    //Set Calibration for Mositure Sensors
    float inAir = 0.85;
    float inWater = 0.40;
    
    //Create a Color Array for Graphics
    int colors[] = {0xFF0000, 0xFF3400, 0xFF6900, 0xFFD300, 0xF7FF00, 0xC2FF00, 0x8DFF00, 0x58FF00, 0x24FF00, 0x00FF00};
    
    //Create a variable to keep track of screens
    int oldPage = 0;
    
    
    int count = 0;
    //Run forever
    while(1) {
        //Have buttons check for page number switches
        if(!pb1) pageNumber = (pageNumber + 1) % 3;
        
        //Turn moisture sensor readings into accurate percents
        msp1 = 100 - int((ms1 - inWater) / (inAir - inWater) * 100);
        if(msp1 > 100) msp1 = 100;
        else if(msp1 < 0) msp1 = 0;
        msp2 = 100 - int((ms2 - inWater) / (inAir - inWater) * 100);
        if(msp2 > 100) msp2 = 100;
        else if(msp2 < 0) msp2 = 0;
        msp3 = 100 - int((ms3 - inWater) / (inAir - inWater) * 100);
        if(msp3 > 100) msp3 = 100;
        else if(msp3 < 0) msp3 = 0;
        msp4 = 100 - int((ms4 - inWater) / (inAir - inWater) * 100);
        if(msp4 > 100) msp4 = 100;
        else if(msp4 < 0) msp4 = 0;
        
        //Clear the Screen if Page Switched
        if(pageNumber != oldPage || count > 10) {
            uLCD.cls();
            count = 0;
        }
        
        //Draw Page 1
        if(pageNumber == 0) {
            uLCD.filled_circle(64, 22, 20, colors[int(msp1 / 10)]);
            uLCD.filled_circle(64, 106, 20, colors[int(msp3 / 10)]);
            uLCD.filled_circle(22, 64, 20, colors[int(msp4 / 10)]);
            uLCD.filled_circle(106, 64, 20, colors[int(msp2 / 10)]);
            uLCD.color(BLACK);
            uLCD.text_mode(TRANSPARENT);
            uLCD.locate(7, 2);
            uLCD.printf("P1:%i", msp1);
            uLCD.locate(7, 13);
            uLCD.printf("P3:%i", msp3);
            uLCD.locate(1, 8);
            uLCD.printf("P4:%i", msp4);
            uLCD.locate(13, 8);
            uLCD.printf("P2:%i", msp2);
        }
        //DrawPage 2
        else if(pageNumber == 1) {
            uLCD.filled_rectangle(14, 14, 114, 114, BLACK);
            uLCD.color(WHITE);
            uLCD.locate(1, 0);
            uLCD.printf("Moisture History\n\r");
            uLCD.locate(1, 15);
            uLCD.printf("Interval (x%i s)", plotInterval);
            uLCD.line(14, 14, 14, 114, WHITE);
            uLCD.line(14, 114, 114, 114, WHITE);
            uLCD.locate(14, 2);
            uLCD.color(RED);
            uLCD.printf("P1-");
            uLCD.locate(14, 3);
            uLCD.color(0xFFFF00);
            uLCD.printf("P2-");
            uLCD.locate(14, 4);
            uLCD.color(GREEN);
            uLCD.printf("P3-");
            uLCD.locate(14, 5);
            uLCD.color(BLUE);
            uLCD.printf("P4-");
            for(int i = 0; i < 10; i++) {
                uLCD.line(14 + (i * 10), 14 + (100 - m1Arr[i]), 14 + ((i + 1) * 10), 14 + (100 - m1Arr[i + 1]), RED);
                uLCD.line(14 + (i * 10), 14 + (100 - m2Arr[i]), 14 + ((i + 1) * 10), 14 + (100 - m2Arr[i + 1]), 0xFFFF00);
                uLCD.line(14 + (i * 10), 14 + (100 - m3Arr[i]), 14 + ((i + 1) * 10), 14 + (100 - m3Arr[i + 1]), GREEN);
                uLCD.line(14 + (i * 10), 14 + (100 - m4Arr[i]), 14 + ((i + 1) * 10), 14 + (100 - m4Arr[i + 1]), BLUE);
            }
        }
        //Draw Page 3
        else if(pageNumber == 2) {
            uLCD.filled_rectangle(19, 14, 39, 114, BLACK);
            uLCD.filled_rectangle(44, 14, 64, 114, BLACK);
            uLCD.filled_rectangle(69, 14, 89, 114, BLACK);
            uLCD.filled_rectangle(94, 14, 114, 114, BLACK);
            uLCD.text_mode(TRANSPARENT);
            uLCD.color(WHITE);
            uLCD.locate(3, 0);
            uLCD.printf("Water Useage\n\r");
            uLCD.locate(4, 15);
            uLCD.printf("Pumps 1-4", plotInterval);
            uLCD.line(14, 14, 14, 114, WHITE);
            uLCD.line(14, 114, 114, 114, WHITE);
            int m = max(p1, p2, p3, p4);
            uLCD.filled_rectangle(19, 14 + 100 - (int(100 * p1 / m)), 39, 114, RED);
            uLCD.filled_rectangle(44, 14 + 100 - (int(100 * p2 / m)), 64, 114, 0xFFFF00);
            uLCD.filled_rectangle(69, 14 + 100 - (int(100 * p3 / m)), 89, 114, GREEN);
            uLCD.filled_rectangle(94, 14 + 100 - (int(100 * p4 / m)), 114, 114, BLUE);
            uLCD.locate(3, 12);
            uLCD.printf("%i", p1);
            uLCD.locate(7, 12);
            uLCD.printf("%i", p2);
            uLCD.locate(10, 12);
            uLCD.printf("%i", p3);
            uLCD.locate(14, 12);
            uLCD.printf("%i", p4);
        }
        //Update Vairaibles
        count++;
        oldPage = pageNumber;
        wait(1);
    }
}