#ifndef PAT9125_MBED_H
#define PAT9125_MBED_H
#include <stdint.h>
#include <stddef.h>
#include "mbed.h"
#include "pat9125_i2c.h"
#include "pixart_lcm.h"

typedef uint8_t boolean;
typedef struct
{
    pat9125_i2c         *p_i2c;
    Serial              *p_pc ;
    DigitalIn           *pBTN_L ;
    DigitalIn           *pBTN_R ;
    InterruptIn         *pINT ;
    DigitalOut          *pRLED ;
    DigitalOut          *pGLED ;
    pixart_lcm          *pLCM ;    
    uint8_t             slave_id ;
    boolean             sen_status ;
} pat9125_mbed_state_s;

class pat9125_mbed
{
    public:           
        pat9125_mbed(pat9125_mbed_state_s *state) ;
        void task() ;
};

#endif