/* PixArt Optical Finger Navigation, OFN, sensor driver.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */

#pragma once
#include "mbed.h"
#include "Pixart_ComPort.h"

class Pixart_OTS_Task
{
public:
    virtual void reset_task(Pixart_ComPort &com_port){
        com_port.writeRegister(0x7F, 0x00);
        com_port.writeRegister(0x06, 0x80);}
    virtual void pre_task(Pixart_ComPort &com_port) {}
    virtual void periodic_task(Pixart_ComPort &com_port) {}
};

class Pixart_OTS_Task_5101: public Pixart_OTS_Task
{
private:
    uint16_t LD2LED_TH;
    uint16_t LED2LD_TH;
    uint16_t FIQ[8];
    uint16_t FIQ_AVG;
    uint8_t FIQt;
    uint8_t EXTLED_ON; // Mode index, 0:LD, 1:LED
    DigitalOut &m_ldp_enl;

    void PAA5101_LD_MODE(Pixart_ComPort &com_port);
    void PAA5101_EXTLED_MODE(Pixart_ComPort &com_port);
    
public:
    Pixart_OTS_Task_5101(DigitalOut &ldp_enl_pin);

    virtual void reset_task(Pixart_ComPort &com_port);
    virtual void pre_task(Pixart_ComPort &com_port);
    virtual void periodic_task(Pixart_ComPort &com_port);
};
