/* PixArt Optical Finger Navigation, OFN, sensor driver.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */
 
#include "Pixart_OTS_Task.h"

Pixart_OTS_Task_5101::Pixart_OTS_Task_5101(DigitalOut &ldp_enl_pin)
    : LD2LED_TH(0x700)
    , LED2LD_TH(0x500)
    , FIQ_AVG(0)
    , FIQt(0)
    , EXTLED_ON(0)
    , m_ldp_enl(ldp_enl_pin)
{
    m_ldp_enl = 0;
}

void Pixart_OTS_Task_5101::reset_task(Pixart_ComPort &com_port)
{
    com_port.writeRegister(0x7F, 0x00);
    com_port.writeRegister(0x08, 0x01);
}

void Pixart_OTS_Task_5101::pre_task(Pixart_ComPort &com_port)
{
    com_port.writeRegister(0x5D, 0x3E);
    wait_ms(10); // 10ms delay
    com_port.writeRegister(0x5D, 0x3F);
    PAA5101_LD_MODE(com_port); // LD mode is default
    com_port.writeRegister(0x09, 0x00); // enable write protect
}

void Pixart_OTS_Task_5101::periodic_task(Pixart_ComPort &com_port)
{
    uint8_t loopi = 0;
    FIQ_AVG = 0;
    
    uint8_t data_msb = com_port.readRegister(0x75);
    uint8_t data_lsb = com_port.readRegister(0x76);
    FIQ[FIQt] = ((uint16_t)(data_msb))*256 + (uint16_t)data_lsb;
    
    if(FIQt==7) //every 8 sampling to decide LD/LED mode
    {
        for(loopi=0;loopi<8;loopi++)
        {
            FIQ_AVG = FIQ_AVG + FIQ[loopi];
        }
        
        if(EXTLED_ON == 1 && FIQ_AVG < LED2LD_TH) // Check if change to LD MODE
        {
            PAA5101_LD_MODE(com_port);
            wait_ms(40); // delay for light source change
            com_port.writeRegister(0x03,0x00);
        }
        else if(EXTLED_ON == 0 && FIQ_AVG < LD2LED_TH) // Check if change to external LED MODE
        {
            PAA5101_EXTLED_MODE(com_port);
            wait_ms(40); // delay for light source change
            com_port.writeRegister(0x03,0x00);
        }
    }
    FIQt = (FIQt+1) & 0x07;
    // LD/LED switch process END
}

void Pixart_OTS_Task_5101::PAA5101_LD_MODE(Pixart_ComPort &com_port)
{
    EXTLED_ON = 0; // Mode index: LD
    
    com_port.writeRegister(0x7F, 0x00); // Bank0
    com_port.writeRegister(0x09, 0x5A); // disable write protect
    com_port.writeRegister(0x53, 0x01);
    com_port.writeRegister(0x07, 0xCC);
    com_port.writeRegister(0x0D, 0x05);
    com_port.writeRegister(0x0E, 0x05);
    com_port.writeRegister(0x19, 0x24);
    com_port.writeRegister(0x7F, 0x01); // Bank1
    com_port.writeRegister(0x1D, 0x18);
    com_port.writeRegister(0x1F, 0x12);
    com_port.writeRegister(0x42, 0x40);
    com_port.writeRegister(0x37, 0x60);
    com_port.writeRegister(0x43, 0x0A);
    com_port.writeRegister(0x7F, 0x04); // Bank4
    com_port.writeRegister(0x06, 0x03);
    com_port.writeRegister(0x7F, 0x05); // Bank5
    com_port.writeRegister(0x2E, 0x02);
    com_port.writeRegister(0x48, 0x00);
    com_port.writeRegister(0x3E, 0x05);
    com_port.writeRegister(0x7F, 0x06); // Bank6
    com_port.writeRegister(0x34, 0x01);
    com_port.writeRegister(0x7F, 0x00); // Bank0
    com_port.writeRegister(0x09, 0x00); // enable write protect
    
    m_ldp_enl = 0; // GPIO controls PMOS to low (i.e. turn on LD power)
}

void Pixart_OTS_Task_5101::PAA5101_EXTLED_MODE(Pixart_ComPort &com_port)
{
    EXTLED_ON = 1; // Mode index: LED
    m_ldp_enl = 1; // GPIO controls PMOS to high (i.e. turn off LD power)
    
    com_port.writeRegister(0x7F, 0x00); // Bank0
    com_port.writeRegister(0x09, 0x5A); // disable write protect
    com_port.writeRegister(0x07, 0x55);
    com_port.writeRegister(0x0D, 0x7D);
    com_port.writeRegister(0x0E, 0x7D);
    com_port.writeRegister(0x19, 0x3C);
    com_port.writeRegister(0x7F, 0x01); // Bank1
    com_port.writeRegister(0x1D, 0x00);
    com_port.writeRegister(0x1F, 0x00);
    com_port.writeRegister(0x42, 0x20);
    com_port.writeRegister(0x37, 0x18);
    com_port.writeRegister(0x43, 0x02);
    com_port.writeRegister(0x7F, 0x04); // Bank4
    com_port.writeRegister(0x06, 0x00);
    com_port.writeRegister(0x7F, 0x05); // Bank5
    com_port.writeRegister(0x2E, 0x08);
    com_port.writeRegister(0x48, 0x02);
    com_port.writeRegister(0x3E, 0x85);
    com_port.writeRegister(0x7F, 0x06); // Bank6
    com_port.writeRegister(0x34, 0x09);
    com_port.writeRegister(0x7F, 0x00); // Bank0
    com_port.writeRegister(0x53, 0x00);
    com_port.writeRegister(0x09, 0x00); // enable write protect
}
