/* PixArt Optical Finger Navigation, OFN, sensor driver.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */

#pragma once
#include "mbed.h"
#include "Build_info.h"
#include "Pixart_ComPort.h"
#include "Pixart_OTS_GrabData.h"
#include "Pixart_OTS_Task.h"
#include "Pixart_OTS_InitSetting.h"

#include <vector>
#include <string>

enum Pixart_OTS_Model
{
    PIXART_OTS_MODEL_9125,
    PIXART_OTS_MODEL_9126,
    PIXART_OTS_MODEL_9150,
    PIXART_OTS_MODEL_9130,
    PIXART_OTS_MODEL_5101,
};

struct Pixart_OTS_Register
{
    uint8_t addr;
    uint8_t value;
};


class Pixart_OTS
{
public:
    Pixart_OTS(Serial &pc, Pixart_ComPort *comPort, Pixart_OTS_GrabData *grabData, Pixart_OTS_Task *task, const std::vector<Pixart_OTS_Register> &initRegisters, const std::string &model, const std::string &HwVer);

    bool sensor_init();
    void periodic_callback();
    static int get_default_i2c_slave_address();
    std::string get_model() const;
    std::string get_HwVer() const;
    
private:
    Serial &m_pc;
    Pixart_ComPort *m_comPort;
    Pixart_OTS_GrabData *m_grabData;
    Pixart_OTS_Task *m_task;
    std::vector<Pixart_OTS_Register> m_initRegisters;
    std::string m_model;
    std::string m_HwVer;

    int16_t m_totalX;
    int16_t m_totalY;
    
    void print_build_info();
};

Pixart_OTS* create_pixart_ots(Pixart_OTS_Model model, Serial &pc, I2C &i2c);
Pixart_OTS* create_pixart_ots(Pixart_OTS_Model model, Serial &pc, SPI &spi, DigitalOut &cs);
Pixart_OTS* create_pixart_ots(Pixart_OTS_Model model, Serial &pc, SPI &spi, DigitalOut &cs, DigitalOut &ldp_enl_pin);
